/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInstanceRoleValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;

public class InstanceRoleMoveValidator
extends AbstractInstanceRoleValidator {
    @Override
    public boolean isValid(ChangeBoundsRequest request) {
        boolean valid = super.isValid(request);
        if (this.instanceRoles.size() != 0) {
            SequenceDiagram sequenceDiagram = ((InstanceRole)this.instanceRoles.get(0)).getDiagram();
            List allInstanceRoles = sequenceDiagram.getSortedInstanceRole();
            RequestQuery query = new RequestQuery((Request)request);
            Point moveDelta = query.getLogicalDelta().getLocation();
            Collections.sort(this.instanceRoles, this.comparator);
            if (!request.isConstrainedMove()) {
                moveDelta.y = 0;
            }
            Iterable notMovedIRBounds = Iterables.transform((Iterable)Iterables.filter((Iterable)allInstanceRoles, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)this.instanceRoles))), (Function)ISequenceElement.PROPER_LOGICAL_BOUNDS);
            block0: for (InstanceRole instanceRole : this.instanceRoles) {
                this.moveDeltas.put(instanceRole, moveDelta.getCopy());
                Rectangle boundBeforeResizing = instanceRole.getBounds();
                Rectangle boundAfterResizing = boundBeforeResizing.getTranslated(moveDelta);
                for (Rectangle notMovedBounds : notMovedIRBounds) {
                    boolean leftOverlapFixIR;
                    int nmbLeftX = notMovedBounds.getLeft().x;
                    int nmbRightX = notMovedBounds.getRight().x;
                    int mLeftX = boundAfterResizing.getLeft().x;
                    boolean bl = leftOverlapFixIR = nmbLeftX <= mLeftX && mLeftX <= nmbRightX;
                    if (!leftOverlapFixIR) continue;
                    valid = false;
                    continue block0;
                }
            }
        }
        return valid;
    }
}

