/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.finders.ContextMenuFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SiriusContextMenuFinder
extends ContextMenuFinder {
    public SiriusContextMenuFinder(Control control) {
        super(control);
    }

    public boolean findMenuEnablement(Matcher<MenuItem> matcher) {
        return this.findMenuEnablement(this.getShells(), matcher, true);
    }

    public boolean findMenuEnablement(Shell[] shells, Matcher<MenuItem> matcher, boolean recursive) {
        boolean result = false;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            result = result || this.findMenuEnablement(this.menuBar(shell), matcher, recursive);
            ++n2;
        }
        return result;
    }

    public boolean findMenuEnablement(final Menu bar, final Matcher<MenuItem> matcher, final boolean recursive) {
        return (Boolean)UIThreadRunnable.syncExec((Display)this.display, (Result)new BoolResult(){

            public Boolean run() {
                List menus = SiriusContextMenuFinder.this.findMenusInternal(bar, (Matcher<MenuItem>)matcher, recursive);
                Assert.assertEquals((String)"Only one widget was expected to be found", (long)1L, (long)menus.size());
                return ((MenuItem)menus.get(0)).getEnabled();
            }
        });
    }

    private List<MenuItem> findMenusInternal(Menu bar, Matcher<MenuItem> matcher, boolean recursive) {
        LinkedHashSet<MenuItem> result = new LinkedHashSet<MenuItem>();
        if (bar != null) {
            MenuItem[] items;
            bar.notifyListeners(22, new Event());
            MenuItem[] menuItemArray = items = bar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (!this.isSeparator(menuItem)) {
                    if (matcher.matches((Object)menuItem)) {
                        result.add(menuItem);
                    }
                    if (recursive) {
                        result.addAll(this.findMenusInternal(menuItem.getMenu(), matcher, recursive));
                    }
                }
                ++n2;
            }
            bar.notifyListeners(23, new Event());
        }
        return new ArrayList<MenuItem>(result);
    }

    private boolean isSeparator(MenuItem menuItem) {
        return (menuItem.getStyle() & 2) != 0;
    }
}

