/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.user;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLMessages;

public final class UserEPackagesField {
    private static final String EPACKAGES_FIELD = "ePackages";
    private static final String INCLUDE_DEFAULT_EPACKAGES_ARG = "includeDefaultEPackages";
    private static final int COMPLEXITY = 1;
    private static final String DEFAULT_METAMODELS_SEPARATOR = ",";

    private UserEPackagesField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(EPACKAGES_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("UserEPackageConnection")).argument(SiriusGraphQLPaginationArguments.build()).argument(UserEPackagesField.getIncludeDefaultEPackagesArg()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(UserEPackagesField.getEPackagesDataFetcher()).build();
    }

    private static GraphQLArgument getIncludeDefaultEPackagesArg() {
        return GraphQLArgument.newArgument().name(INCLUDE_DEFAULT_EPACKAGES_ARG).type((GraphQLInputType)Scalars.GraphQLBoolean).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getEPackagesDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> EPackage.Registry.INSTANCE.values().stream().map(object -> {
            EPackage ePackage = null;
            if (object instanceof EPackage) {
                ePackage = (EPackage)object;
            } else if (object instanceof EPackage.Descriptor) {
                ePackage = ((EPackage.Descriptor)object).getEPackage();
            }
            return ePackage;
        }).filter(ePackage -> UserEPackagesField.filter(environment, ePackage)).collect(Collectors.toList()), UserEPackagesField::computeEPackageCursor);
    }

    private static String computeEPackageCursor(EPackage ePackage) {
        String unEncodedCursor = ePackage.getNsURI();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }

    private static boolean filter(DataFetchingEnvironment environment, EPackage ePackage) {
        boolean includeDefaultEPackages = Optional.ofNullable(environment.getArgument(INCLUDE_DEFAULT_EPACKAGES_ARG)).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(Boolean.FALSE);
        String[] defaultMetamodels = SiriusGraphQLMessages.SiriusGraphQLUserEPackagesField_defaultMetamodels.split(DEFAULT_METAMODELS_SEPARATOR);
        return includeDefaultEPackages || !Arrays.asList(defaultMetamodels).contains(ePackage.getNsURI());
    }
}

