/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.frontend.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.sirius.server.api.ISiriusServerConfigurator;
import org.eclipse.sirius.server.frontend.internal.SiriusServerFrontendFilter;
import org.eclipse.sirius.server.frontend.internal.SiriusServerFrontendPlugin;
import org.osgi.framework.Bundle;

public class SiriusServerFrontendConfigurator
implements ISiriusServerConfigurator {
    private static final String CONTEXT_PATH = "/";
    private static final String SERVLET_HOLDER_NAME = "SiriusFrontendServletHolder";
    private static final String FRONTEND_RESOURCES_PATH = "./sirius-frontend";
    private static final String SERVLET_PATH = "/";

    public void configure(Server server) {
        ServletContextHandler servletContextHandler = new ServletContextHandler(5);
        servletContextHandler.setContextPath("/");
        servletContextHandler.addFilter(SiriusServerFrontendFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.INCLUDE));
        try {
            Bundle bundle = SiriusServerFrontendPlugin.getPlugin().getBundle();
            URL frontendResourcesURL = bundle.getResource(FRONTEND_RESOURCES_PATH);
            URL resolvedURL = FileLocator.resolve((URL)frontendResourcesURL);
            URI frontendResourcesURI = URIUtil.toURI((URL)resolvedURL);
            String frontendResourcesPath = new File(frontendResourcesURI).getAbsolutePath();
            ServletHolder servletHolder = new ServletHolder(SERVLET_HOLDER_NAME, (Servlet)new DefaultServlet());
            servletHolder.setInitParameter("resourceBase", frontendResourcesPath);
            servletHolder.setInitParameter("dirAllowed", "false");
            servletContextHandler.addServlet(servletHolder, "/");
            Handler handler = server.getHandler();
            if (handler instanceof HandlerCollection) {
                HandlerCollection handlerCollection = (HandlerCollection)handler;
                handlerCollection.addHandler((Handler)servletContextHandler);
            }
        }
        catch (IOException | URISyntaxException exception) {
            Status status = new Status(4, "org.eclipse.sirius.server.frontend", exception.getMessage(), (Throwable)exception);
            SiriusServerFrontendPlugin.getPlugin().log(status);
        }
    }
}

