/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.emf.internal.schema;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;

public class EDataTypeCoercing
implements Coercing<Object, Object> {
    private final EDataType eDataType;
    private final EFactory eFactoryInstance;

    public EDataTypeCoercing(EDataType eDataType) {
        this.eDataType = eDataType;
        this.eFactoryInstance = this.eDataType.getEPackage().getEFactoryInstance();
    }

    public Object parseLiteral(Object literal) throws CoercingParseLiteralException {
        if (literal instanceof StringValue) {
            StringValue stringValue = (StringValue)literal;
            String value = stringValue.getValue();
            Object result = this.eFactoryInstance.createFromString(this.eDataType, value);
            return result;
        }
        throw new CoercingParseValueException();
    }

    public Object parseValue(Object value) throws CoercingParseValueException {
        if (value instanceof String) {
            String stringValue = (String)value;
            Object result = this.eFactoryInstance.createFromString(this.eDataType, stringValue);
            return result;
        }
        throw new CoercingParseValueException();
    }

    public Object serialize(Object value) throws CoercingSerializeException {
        return this.eFactoryInstance.convertToString(this.eDataType, value);
    }
}

