/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.images.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.osgi.framework.Bundle;

public class SiriusServerImagesFilter
implements Filter {
    private static final String JPG = "jpg";
    private static final String JPEG = "jpeg";
    private static final String JPEG_MIME_TYPE = "image/jpeg";
    private static final String GIF = "gif";
    private static final String GIF_MIME_TYPE = "image/gif";
    private static final String BMP = "bmp";
    private static final String BMP_MIME_TYPE = "image/bmp";
    private static final String PNG = "png";
    private static final String PNG_MIME_TYPE = "image/png";
    private static final String SVG = "svg";
    private static final String SVG_MIME_TYPE = "image/svg+xml";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String requestURI = httpServletRequest.getRequestURI();
            if (this.isStaticImage(requestURI)) {
                this.handleStaticImage(httpServletRequest, httpServletResponse, chain);
            } else if (this.isEObjectImage(httpServletRequest)) {
                this.handleEObjectImage(httpServletRequest, httpServletResponse, chain);
            }
        }
    }

    private boolean isStaticImage(String requestURI) {
        boolean isImagePath = requestURI.startsWith("/images");
        boolean isImageExtension = requestURI.endsWith(JPG);
        isImageExtension = isImageExtension || requestURI.endsWith(JPEG);
        isImageExtension = isImageExtension || requestURI.endsWith(GIF);
        isImageExtension = isImageExtension || requestURI.endsWith(BMP);
        isImageExtension = isImageExtension || requestURI.endsWith(PNG);
        boolean bl = isImageExtension = isImageExtension || requestURI.endsWith(SVG);
        return isImagePath && isImageExtension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStaticImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws ServletException, IOException {
        String requestURI = httpServletRequest.getRequestURI();
        String[] segments = requestURI.split("/");
        if (segments.length >= 4) {
            String bundleSymbolicName = segments[2];
            String imagePath = Arrays.stream(segments).skip(3L).reduce("", (string1, string2) -> String.valueOf(string1) + '/' + string2);
            Optional<Bundle> optionalBundle = Optional.ofNullable(Platform.getBundle((String)bundleSymbolicName));
            Optional<URL> optionalImageUrl = optionalBundle.map(bundle -> bundle.getEntry(imagePath));
            if (optionalImageUrl.isPresent()) {
                URL url = optionalImageUrl.get();
                URLConnection connection = url.openConnection();
                httpServletResponse.setContentLength(connection.getContentLength());
                httpServletResponse.setContentType(this.getContentType(imagePath));
                Throwable throwable = null;
                Object var13_14 = null;
                try {
                    InputStream inputStream = connection.getInputStream();
                    try {
                        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();){
                            this.copy(inputStream, (OutputStream)outputStream);
                            outputStream.flush();
                        }
                        if (inputStream == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private String getContentType(String path) {
        String contentType = null;
        if (path.endsWith(JPG) || path.endsWith(JPEG)) {
            contentType = JPEG_MIME_TYPE;
        } else if (path.endsWith(GIF)) {
            contentType = GIF_MIME_TYPE;
        } else if (path.endsWith(BMP)) {
            contentType = BMP_MIME_TYPE;
        } else if (path.endsWith(PNG)) {
            contentType = PNG_MIME_TYPE;
        } else if (path.endsWith(SVG)) {
            contentType = SVG_MIME_TYPE;
        }
        return contentType;
    }

    private long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int index;
        long byteRead = 0L;
        byte[] buffer = new byte[4096];
        while ((index = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, index);
            byteRead += (long)index;
        }
        return byteRead;
    }

    private boolean isEObjectImage(HttpServletRequest httpServletRequest) {
        boolean isImagePath = httpServletRequest.getRequestURI().startsWith("/images");
        boolean hasFragment = httpServletRequest.getParameterMap().containsKey("fragment");
        return isImagePath && hasFragment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEObjectImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws ServletException, IOException {
        String requestURI = httpServletRequest.getRequestURI();
        String[] segments = requestURI.split("/");
        if (segments.length >= 4) {
            Optional optionalSession;
            String projectName = segments[2];
            String resourcePath = Arrays.stream(segments).skip(3L).reduce("", (string1, string2) -> String.valueOf(string1) + '/' + string2);
            String eObjectFragment = httpServletRequest.getParameter("fragment");
            Optional<IProject> optionalProject = Optional.ofNullable(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
            Optional<IFile> optionalFile = optionalProject.map(iProject -> iProject.getFile((IPath)new Path(resourcePath)));
            Optional<EObject> optionalResource = optionalFile.flatMap(arg_0 -> SiriusServerImagesFilter.lambda$5(optionalSession = optionalProject.flatMap(SiriusServicesCommonOptionalUtils::toSession), arg_0));
            Optional<EObject> optionalEObject = optionalResource.map(resource -> resource.getEObject(eObjectFragment));
            Optional optionalImage = optionalEObject.flatMap(this::toImage);
            Optional optionalURL = optionalImage.flatMap(this::toURL);
            if (optionalURL.isPresent()) {
                URL imageURL = (URL)optionalURL.get();
                URLConnection connection = imageURL.openConnection();
                httpServletResponse.setContentLength(connection.getContentLength());
                httpServletResponse.setContentType(this.getContentType(imageURL.toString()));
                Throwable throwable = null;
                Object var21_20 = null;
                try {
                    InputStream inputStream = connection.getInputStream();
                    try {
                        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();){
                            this.copy(inputStream, (OutputStream)outputStream);
                            outputStream.flush();
                        }
                        if (inputStream == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private Optional<URL> toURL(Object object) {
        Optional<URL> optionalURL = Optional.of(object).filter(URL.class::isInstance).map(URL.class::cast);
        if (!optionalURL.isPresent()) {
            optionalURL = Optional.of(object).filter(ComposedImage.class::isInstance).map(ComposedImage.class::cast).map(ComposedImage::getImages).map(Collection::stream).flatMap(Stream::findFirst).filter(URL.class::isInstance).map(URL.class::cast);
        }
        return optionalURL;
    }

    private Optional<Object> toImage(EObject eObject) {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return Optional.of(composedAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)).filter(IItemLabelProvider.class::isInstance).map(IItemLabelProvider.class::cast).map(labelProvider -> labelProvider.getImage((Object)eObject));
    }

    public void destroy() {
    }

    private static /* synthetic */ Optional lambda$5(Optional optional, IFile iFile) {
        return optional.flatMap(session -> SiriusServicesCommonOptionalUtils.toResource((Session)session, (IFile)iFile));
    }
}

