/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.ContentAlignment;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class HierarchicalNodeResizingProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Resize child graph to fit parent.", 1.0f);
        for (Layer layer : graph) {
            graph.getLayerlessNodes().addAll(layer.getNodes());
            layer.getNodes().clear();
        }
        for (LNode node : graph.getLayerlessNodes()) {
            node.setLayer(null);
        }
        graph.getLayers().clear();
        this.resizeGraph(graph);
        if (this.isNested(graph)) {
            this.graphLayoutToNode(graph.getParentNode(), graph);
        }
        progressMonitor.done();
    }

    private void graphLayoutToNode(LNode node, LGraph lgraph) {
        for (LNode childNode : lgraph.getLayerlessNodes()) {
            Object origin = childNode.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof LPort)) continue;
            LPort port = (LPort)((Object)origin);
            KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, childNode, port.getSize().x, port.getSize().y);
            port.getPosition().x = portPosition.x;
            port.getPosition().y = portPosition.y;
            port.setSide((PortSide)childNode.getProperty(InternalProperties.EXT_PORT_SIDE));
        }
        KVector actualGraphSize = lgraph.getActualSize();
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            node.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
            ((Set)node.getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.NON_FREE_PORTS);
            LGraphUtil.resizeNode(node, actualGraphSize, false, true);
        } else {
            LGraphUtil.resizeNode(node, actualGraphSize, true, true);
        }
    }

    private boolean isNested(LGraph graph) {
        return graph.getParentNode() != null;
    }

    private void resizeGraph(LGraph lgraph) {
        Set sizeConstraint = (Set)lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        Set sizeOptions = (Set)lgraph.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        KVector calculatedSize = lgraph.getActualSize();
        KVector adjustedSize = new KVector(calculatedSize);
        if (sizeConstraint.contains(SizeConstraint.MINIMUM_SIZE)) {
            KVector minSize = (KVector)lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
            if (sizeOptions.contains(SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minSize.x <= 0.0) {
                    minSize.x = 20.0;
                }
                if (minSize.y <= 0.0) {
                    minSize.y = 20.0;
                }
            }
            adjustedSize.x = Math.max(calculatedSize.x, minSize.x);
            adjustedSize.y = Math.max(calculatedSize.y, minSize.y);
        }
        this.resizeGraphNoReallyIMeanIt(lgraph, calculatedSize, adjustedSize);
    }

    private void resizeGraphNoReallyIMeanIt(LGraph lgraph, KVector oldSize, KVector newSize) {
        Set contentAlignment = (Set)lgraph.getProperty(LayeredOptions.CONTENT_ALIGNMENT);
        if (newSize.x > oldSize.x) {
            if (contentAlignment.contains(ContentAlignment.H_CENTER)) {
                lgraph.getOffset().x += (newSize.x - oldSize.x) / 2.0;
            } else if (contentAlignment.contains(ContentAlignment.H_RIGHT)) {
                lgraph.getOffset().x += newSize.x - oldSize.x;
            }
        }
        if (newSize.y > oldSize.y) {
            if (contentAlignment.contains(ContentAlignment.V_CENTER)) {
                lgraph.getOffset().y += (newSize.y - oldSize.y) / 2.0;
            } else if (contentAlignment.contains(ContentAlignment.V_BOTTOM)) {
                lgraph.getOffset().y += newSize.y - oldSize.y;
            }
        }
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS) && (newSize.x > oldSize.x || newSize.y > oldSize.y)) {
            for (LNode node : lgraph.getLayerlessNodes()) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (extPortSide == PortSide.EAST) {
                    node.getPosition().x += newSize.x - oldSize.x;
                    continue;
                }
                if (extPortSide != PortSide.SOUTH) continue;
                node.getPosition().y += newSize.y - oldSize.y;
            }
        }
        LPadding padding = lgraph.getPadding();
        lgraph.getSize().x = newSize.x - padding.left - padding.right;
        lgraph.getSize().y = newSize.y - padding.top - padding.bottom;
    }
}

