/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.api.TreeTestCase;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class TreeItemRefreshTest
extends TreeTestCase {
    private String TREE_DESCRIPTION_ID = "Tree";
    protected static final int ELEMENTS_NUMBER_IN_TREE = 12;
    private static final String SEMANTIC_MODEL_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/refresh/tree.ecore";
    private static final String MODELER_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/refresh/tree.odesign";
    private static final String SESSION_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/refresh/tree.aird";
    private static final String NEWECLASS = "NewECLass";
    private DTreeEditor treeEditor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.genericSetUp(SEMANTIC_MODEL_PATH, MODELER_PATH, SESSION_PATH);
    }

    private int countNamedEClasses(EObject semanticModel, String name) {
        int count = 0;
        EObject root = (EObject)semanticModel.eResource().getContents().get(0);
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (!(current instanceof EClass) || !name.equals(((EClass)current).getName())) continue;
            ++count;
        }
        return count;
    }

    public void testRefreshElement() throws Exception {
        TreeDescription treeDescription = this.find(this.TREE_DESCRIPTION_ID);
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        Assert.assertEquals((String)"The unit test data seems incorrect", (long)3L, (long)treeDescription.getSubItemMappings().size());
        DTree newTree = (DTree)this.getRepresentations(this.TREE_DESCRIPTION_ID).toArray()[0];
        TreeDescription desc = newTree.getDescription();
        IEditorPart openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)newTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = (DTreeEditor)openedEditor;
        Tree tree = (Tree)this.treeEditor.getControl();
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertTrue((String)"The editor has not the good number element", (TreeItemRefreshTest.getModelHtml().length() == currentHtml.length() ? 1 : 0) != 0);
        int instanceCount = -1;
        Assert.assertNotNull((String)"Unit test data is not correct", (Object)desc);
        Assert.assertEquals((String)"We have 13 elements in ecore model, so we should have 13 elements in tree.", (long)12L, (long)newTree.getOwnedTreeItems().size());
        instanceCount = this.countNamedEClasses(this.semanticModel, "NewEClass");
        Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)4L, (long)instanceCount);
        this.applyRefresh((DRepresentation)newTree);
        instanceCount = this.countNamedEClasses(this.semanticModel, "NewEClass");
        Assert.assertEquals((String)"Wrong count of elementhaving the wanted value.", (long)4L, (long)instanceCount);
        Assert.assertEquals((String)"We have 13 elements in ecore model, so we should have 13 elements in tree.", (long)13L, (long)newTree.getOwnedTreeItems().size());
        currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertTrue((String)"The refesh is not effetive in editor", (TreeItemRefreshTest.getModelHtml().length() == currentHtml.length() ? 1 : 0) != 0);
    }

    public void testRefreshTreeAfterSemanticModelModification() throws Exception {
        TreeDescription treeDescription = this.find(this.TREE_DESCRIPTION_ID);
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        Assert.assertEquals((String)"The unit test data seems incorrect", (long)3L, (long)treeDescription.getSubItemMappings().size());
        DTree newTree = (DTree)this.getRepresentations(this.TREE_DESCRIPTION_ID).toArray()[0];
        this.treeEditor = (DTreeEditor)DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)newTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        Tree tree = (Tree)this.treeEditor.getControl();
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertTrue((String)"The editor has not the good number element", (TreeItemRefreshTest.getModelHtml().length() == currentHtml.length() ? 1 : 0) != 0);
        int instanceCount = -1;
        instanceCount = this.countNamedEClasses(this.semanticModel, "EClass1");
        Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)1L, (long)instanceCount);
        final EPackage semanticPackage = (EPackage)newTree.getTarget();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new SiriusCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                semanticPackage.getEClassifier("EClass1").setName("EClass21");
            }
        });
        instanceCount = this.countNamedEClasses(this.semanticModel, "EClass21");
        this.applyRefresh((DRepresentation)newTree);
        currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertTrue((String)"The tree representation must be contain the new EClass name. The refresh doesn't perform.", (boolean)currentHtml.contains("EClass21"));
    }

    private static String getModelHtml() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(NEWECLASS));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(NEWECLASS));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(NEWECLASS));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(NEWECLASS));
        return TreeUIHelper.toHTML(expected);
    }

    @Override
    protected void tearDown() throws Exception {
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.treeEditor, false);
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = null;
        super.tearDown();
    }
}

