/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk.debug;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.service.LayoutConnectorsService;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.CanLayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.LayoutOptionTarget;
import org.eclipse.sirius.diagram.elk.ElkDiagramLayoutConnector;
import org.eclipse.sirius.diagram.elk.IELKLayoutExtension;
import org.eclipse.sirius.diagram.elk.debug.Messages;
import org.eclipse.sirius.diagram.elk.debug.gmf.layout.LayoutService;
import org.eclipse.sirius.diagram.ui.internal.layout.GenericLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportToElkGraphHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection structuredSelection;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (selection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)selection).getFirstElement() instanceof DiagramEditPart) {
            CustomLayoutConfiguration customLayoutConfiguration;
            DiagramEditPart diagramEditPart = (DiagramEditPart)structuredSelection.getFirstElement();
            Optional<CustomLayoutConfiguration> optionnalCustomLayoutConfiguration = this.getAssociatedElkLayoutConfiguration(diagramEditPart);
            if (optionnalCustomLayoutConfiguration.isPresent()) {
                customLayoutConfiguration = optionnalCustomLayoutConfiguration.get();
            } else {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.ExportToElkGraphHandler_elkExportDialogTitle, (String)Messages.ExportToElkGraphHandler_elkExportDialogNoAssociatedLayoutMessage);
                DescriptionFactory layoutDescriptionFactory = DescriptionFactory.eINSTANCE;
                customLayoutConfiguration = layoutDescriptionFactory.createCustomLayoutConfiguration();
                customLayoutConfiguration.setId("org.eclipse.elk.layered");
                EnumLayoutOption enumLayoutOption = layoutDescriptionFactory.createEnumLayoutOption();
                enumLayoutOption.setId("org.eclipse.elk.hierarchyHandling");
                EnumLayoutValue enumLayoutValue = layoutDescriptionFactory.createEnumLayoutValue();
                enumLayoutValue.setName(HierarchyHandling.INCLUDE_CHILDREN.name());
                enumLayoutOption.setValue(enumLayoutValue);
                enumLayoutOption.getTargets().add((Object)LayoutOptionTarget.PARENT);
                enumLayoutOption.getTargets().add((Object)LayoutOptionTarget.NODE);
                customLayoutConfiguration.getLayoutOptions().add((Object)enumLayoutOption);
            }
            Command command = diagramEditPart.getCommand(new Request((Object)"resetOrigin"));
            DiagramCommandStack commandStack = this.getDiagramCommandStack(workbenchPart);
            if (commandStack != null) {
                commandStack.execute(command);
            }
            Injector injector = LayoutConnectorsService.getInstance().getInjector(null, (Object)diagramEditPart.getChildren());
            ElkDiagramLayoutConnector connector = (ElkDiagramLayoutConnector)injector.getInstance(ElkDiagramLayoutConnector.class);
            connector.setLayoutConfiguration(customLayoutConfiguration);
            LayoutMapping layoutMapping = connector.buildLayoutGraph(diagramEditPart, (Object)diagramEditPart.getChildren(), true, false);
            List elkLayoutExtensions = IELKLayoutExtension.getLayoutExtensions();
            elkLayoutExtensions.forEach(e -> e.beforeELKLayout(layoutMapping));
            ElkDiagramLayoutConnector.storeResult((ElkNode)layoutMapping.getLayoutGraph(), (String)((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement()).getName(), (String)"", (boolean)true);
            if (commandStack != null) {
                commandStack.undo();
            }
        }
        return null;
    }

    public Optional<CustomLayoutConfiguration> getAssociatedElkLayoutConfiguration(DiagramEditPart diagramEditPart) {
        LayoutProvider layoutProvider;
        Optional result = Optional.empty();
        LayoutService layoutService = LayoutService.getInstance();
        ArrayList<String> hints = new ArrayList<String>(2);
        hints.add("DEFAULT");
        hints.add((String)diagramEditPart);
        ObjectAdapter layoutHint = new ObjectAdapter(hints);
        List editparts = diagramEditPart.getChildren();
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(editparts.size());
        for (IGraphicalEditPart ep : editparts) {
            View view = ep.getNotationView();
            if (!ep.isActive() || view == null || !(view instanceof Node) || ep == layoutHint.getAdapter(EditPart.class)) continue;
            Rectangle bounds = ep.getFigure().getBounds();
            nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
        }
        Option<IProvider> optionalProvider = layoutService.getMainProvider((IOperation)new CanLayoutNodesOperation(nodes, true, (IAdaptable)layoutHint));
        if (optionalProvider.some() && optionalProvider.get() instanceof AbstractLayoutProvider && (layoutProvider = ((AbstractLayoutProvider)optionalProvider.get()).getDiagramLayoutProvider(diagramEditPart, (IAdaptable)layoutHint)) instanceof GenericLayoutProvider) {
            result = ((GenericLayoutProvider)layoutProvider).getLayoutConfiguration((IGraphicalEditPart)diagramEditPart);
        }
        return result;
    }

    private DiagramCommandStack getDiagramCommandStack(IWorkbenchPart workbenchPart) {
        Object stack = workbenchPart.getAdapter(CommandStack.class);
        return stack instanceof DiagramCommandStack ? (DiagramCommandStack)stack : null;
    }
}

