/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.IResourceCollector;
import org.eclipse.sirius.business.internal.session.danalysis.SessionLazyCrossReferencer;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;

public class LocalResourceCollectorCrossReferencer
extends SessionLazyCrossReferencer
implements IResourceCollector {
    private Map<Resource, Collection<Resource>> directlyReferencingResources = new WeakHashMap<Resource, Collection<Resource>>();
    private Map<Resource, Collection<Resource>> directlyReferencedResources = new WeakHashMap<Resource, Collection<Resource>>();

    public LocalResourceCollectorCrossReferencer(DAnalysisSessionImpl session) {
        super(session);
    }

    protected ECrossReferenceAdapter.InverseCrossReferencer createInverseCrossReferencer() {
        return new LocalInverseCrossReferencer();
    }

    public void addInterResourceResourceReference(Resource referencingResource, Resource referencedResource) {
        if (!this.isAnAirdOrSrmResourceConcerned(referencingResource, referencedResource)) {
            Collection<Resource> allReferencedResourcesByResource = this.directlyReferencedResources.get(referencingResource);
            if (allReferencedResourcesByResource == null) {
                allReferencedResourcesByResource = new LinkedHashSet<Resource>();
                this.directlyReferencedResources.put(referencingResource, allReferencedResourcesByResource);
            }
            allReferencedResourcesByResource.add(referencedResource);
            Collection<Resource> allReferencingResourcesByResource = this.directlyReferencingResources.get(referencedResource);
            if (allReferencingResourcesByResource == null) {
                allReferencingResourcesByResource = new LinkedHashSet<Resource>();
                this.directlyReferencingResources.put(referencedResource, allReferencingResourcesByResource);
            }
            allReferencingResourcesByResource.add(referencingResource);
        }
    }

    private boolean isAnAirdOrSrmResourceConcerned(Resource referencingResource, Resource referencedResource) {
        return new ResourceQuery(referencingResource).isAirdOrSrmResource() || new ResourceQuery(referencedResource).isAirdOrSrmResource();
    }

    public void removeInterResourceResourceReference(Resource referencingResource, Resource referencedResource) {
        this.directlyReferencedResources.remove(referencingResource);
        this.directlyReferencingResources.remove(referencedResource);
    }

    @Override
    public Collection<Resource> getAllReferencedResources(Resource resource) {
        if (!this.initialized) {
            this.initialize();
        }
        if (!resource.eAdapters().contains((Object)this)) {
            resource.eAdapters().add((Object)this);
        }
        Collection<Resource> allReferencedResources = this.getTransitivelyAllResoures(this.directlyReferencedResources, resource, Collections.emptyList());
        allReferencedResources.removeIf(res -> res.getResourceSet() == null);
        return allReferencedResources;
    }

    @Override
    public Collection<Resource> getAllReferencingResources(Resource resource) {
        if (!this.initialized) {
            this.initialize();
        }
        if (!resource.eAdapters().contains((Object)this)) {
            resource.eAdapters().add((Object)this);
        }
        Collection<Resource> allReferencingResources = this.getTransitivelyAllResoures(this.directlyReferencingResources, resource, Collections.emptyList());
        allReferencingResources.removeIf(res -> res.getResourceSet() == null);
        return allReferencingResources;
    }

    private Collection<Resource> getTransitivelyAllResoures(Map<Resource, Collection<Resource>> map, Resource resource, Collection<Resource> resourcesAlreadyVisited) {
        LinkedHashSet<Resource> allTransitiveResources = new LinkedHashSet<Resource>(resourcesAlreadyVisited);
        Collection<Resource> transitiveResources = map.get(resource);
        if (transitiveResources != null) {
            allTransitiveResources.addAll(transitiveResources);
            for (Resource transitiveResource : transitiveResources) {
                if (resourcesAlreadyVisited.contains(transitiveResource)) continue;
                allTransitiveResources.addAll(this.getTransitivelyAllResoures(map, transitiveResource, allTransitiveResources));
            }
        }
        return allTransitiveResources;
    }

    @Override
    public void dispose() {
        this.directlyReferencingResources = null;
        this.directlyReferencedResources = null;
    }

    public class LocalInverseCrossReferencer
    extends SiriusCrossReferenceAdapter.SiriusInverseCrossReferencer {
        private static final long serialVersionUID = 1L;
        private Map<Resource, Map<EObject, Map<EObject, EStructuralFeature>>> resourcesRefs;

        public LocalInverseCrossReferencer() {
            super((SiriusCrossReferenceAdapter)LocalResourceCollectorCrossReferencer.this);
            this.resourcesRefs = new WeakHashMap<Resource, Map<EObject, Map<EObject, EStructuralFeature>>>();
        }

        protected void add(InternalEObject eObject, EReference eReference, EObject crossReferencedEObject) {
            super.add(eObject, eReference, crossReferencedEObject);
            Resource referencingResource = eObject.eResource();
            Resource referencedResource = crossReferencedEObject.eResource();
            if (referencingResource != null && referencedResource != null && referencingResource != referencedResource && !LocalResourceCollectorCrossReferencer.this.isAnAirdOrSrmResourceConcerned(referencingResource, referencedResource)) {
                EStructuralFeature.Setting setting;
                Map<EObject, EStructuralFeature> settings;
                Map<EObject, Map<EObject, EStructuralFeature>> referencedEObjects = this.resourcesRefs.get(referencingResource);
                if (referencedEObjects == null) {
                    referencedEObjects = new LinkedHashMap<EObject, Map<EObject, EStructuralFeature>>();
                    this.resourcesRefs.put(referencingResource, referencedEObjects);
                }
                if ((settings = referencedEObjects.get(crossReferencedEObject)) == null) {
                    settings = new LinkedHashMap<EObject, EStructuralFeature>();
                    referencedEObjects.put(crossReferencedEObject, settings);
                }
                if ((setting = eObject.eSetting((EStructuralFeature)eReference)).getEStructuralFeature() != EcorePackage.Literals.EGENERIC_TYPE__ECLASSIFIER) {
                    settings.put(setting.getEObject(), setting.getEStructuralFeature());
                }
                LocalResourceCollectorCrossReferencer.this.addInterResourceResourceReference(referencingResource, referencedResource);
            }
        }

        public void remove(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            super.remove(eObject, eReference, crossReferencedEObject);
            Resource referencingResource = eObject.eResource();
            Resource referencedResource = crossReferencedEObject.eResource();
            if (referencingResource != null && referencedResource != null && referencingResource != referencedResource && !LocalResourceCollectorCrossReferencer.this.isAnAirdOrSrmResourceConcerned(referencingResource, referencedResource)) {
                this.removeInMap(referencedResource, referencingResource, eObject, crossReferencedEObject);
            }
        }

        private void removeInMap(Resource referencedResource, Resource referencingResource, EObject eObject, EObject crossReferencedEObject) {
            Map<EObject, Map<EObject, EStructuralFeature>> referencedEObjects = this.resourcesRefs.get(referencingResource);
            if (referencedEObjects != null) {
                Map<EObject, EStructuralFeature> settings = referencedEObjects.get(crossReferencedEObject);
                if (settings != null) {
                    settings.remove(eObject);
                }
                if (settings == null || settings.isEmpty()) {
                    referencedEObjects.remove(crossReferencedEObject);
                    if (referencedEObjects.isEmpty()) {
                        this.resourcesRefs.remove(referencingResource);
                        LocalResourceCollectorCrossReferencer.this.removeInterResourceResourceReference(referencingResource, referencedResource);
                    }
                }
            }
        }
    }
}

