/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.CollapseDTreeItemRunnableWithProgress;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandAllTreeItemsChangeTrigger;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandDTreeItemRunnableWithProgress;
import org.eclipse.sirius.ui.tools.internal.editor.ChangeExpandeStateRunnable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TreeItemExpansionManager
implements Listener {
    private Tree tree;
    private Session session;
    private IPermissionAuthority permissionAuthority;

    public TreeItemExpansionManager(Tree tree, Session session) {
        this.tree = tree;
        this.session = session;
        tree.addListener(17, (Listener)this);
        tree.addListener(18, (Listener)this);
        tree.addListener(12, (Listener)this);
        this.permissionAuthority = session.getModelAccessor().getPermissionAuthority();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 18: {
                TreeItemExpansionManager.handleTreeCollapse(event, Optional.empty(), this.session, this.permissionAuthority);
                break;
            }
            case 17: {
                TreeItemExpansionManager.handleTreeExpand(event, Optional.empty(), this.session, this.permissionAuthority, false, 0);
                break;
            }
            case 12: {
                this.handleDispose();
                break;
            }
        }
    }

    public static void handleTreeCollapse(Event event, Optional<TreeItem> currentTreeItem, Session currentSession, IPermissionAuthority currentPermissionAuthority) {
        TreeItem treeItem = null;
        if (currentTreeItem.isPresent()) {
            treeItem = currentTreeItem.get();
        } else if (event.item instanceof TreeItem) {
            treeItem = (TreeItem)event.item;
        }
        if (treeItem != null) {
            TreeItemExpansionManager.handleTreeCollapse(event, List.of(treeItem), currentSession, currentPermissionAuthority);
        }
    }

    public static void handleTreeCollapse(Event event, List<TreeItem> treeItemsToCollapse, Session currentSession, IPermissionAuthority currentPermissionAuthority) {
        if (treeItemsToCollapse.size() > 0) {
            TreeItem treeItem = treeItemsToCollapse.get(treeItemsToCollapse.size() - 1);
            Object data = treeItem.getData();
            boolean isAlreadyCollapsed = !treeItem.getExpanded();
            boolean isCollapseToRevert = false;
            if (data instanceof DTreeItem) {
                DTreeItem dTreeItem = (DTreeItem)data;
                if (TreeItemExpansionManager.isForDTreeItemExpandable(treeItem, currentPermissionAuthority)) {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IProgressService ps = wb.getProgressService();
                    try {
                        if (treeItemsToCollapse.size() == 1 && dTreeItem.isExpanded()) {
                            ps.busyCursorWhile((IRunnableWithProgress)new CollapseDTreeItemRunnableWithProgress(currentSession, dTreeItem));
                        } else if (treeItemsToCollapse.size() > 1) {
                            ps.busyCursorWhile((IRunnableWithProgress)new CollapseDTreeItemRunnableWithProgress(currentSession, TreeItemExpansionManager.getDTreeItemsFromTreeItems(treeItemsToCollapse)));
                        }
                    }
                    catch (InvocationTargetException e) {
                        TreeUIPlugin.INSTANCE.log(new Status(4, "org.eclipse.sirius.tree.ui", MessageFormat.format(Messages.TreeItemExpansionManager_expandOrCollaseError, Messages.TreeItemExpansionManager_treeCollapsing), (Throwable)e));
                    }
                    catch (InterruptedException interruptedException) {
                        isCollapseToRevert = !isAlreadyCollapsed;
                    }
                } else {
                    boolean bl = isCollapseToRevert = !isAlreadyCollapsed;
                }
            }
            if (isCollapseToRevert || !TreeItemExpansionManager.isForDTreeItemExpandable(treeItem, currentPermissionAuthority) && !isAlreadyCollapsed) {
                event.type = 0;
                new ChangeExpandeStateRunnable(treeItem, true).run();
            }
        }
    }

    private static List<DTreeItem> getDTreeItemsFromTreeItems(List<TreeItem> treeItemsToCollapse) {
        ArrayList<DTreeItem> result = new ArrayList<DTreeItem>();
        for (TreeItem treeItem : treeItemsToCollapse) {
            Object data = treeItem.getData();
            if (!(data instanceof DTreeItem)) continue;
            result.add((DTreeItem)data);
        }
        return result;
    }

    public static void handleTreeExpand(Event event, Optional<TreeItem> currentTreeItem, Session currentSession, IPermissionAuthority currentPermissionAuthority, boolean all, int expandDepthLimit) {
        TreeItem treeItem = null;
        if (currentTreeItem.isPresent()) {
            treeItem = currentTreeItem.get();
        } else if (event.item instanceof TreeItem) {
            treeItem = (TreeItem)event.item;
        }
        if (treeItem != null) {
            boolean isAlreadyExpanded = treeItem.getExpanded();
            Object data = treeItem.getData();
            if (data instanceof DTreeItem) {
                DTreeItem dTreeItem = (DTreeItem)data;
                boolean isExpandToRevert = false;
                if (TreeItemExpansionManager.isForDTreeItemExpandable(treeItem, currentPermissionAuthority)) {
                    ExpandAllTreeItemsChangeTrigger modelChangeTrigger = null;
                    if (all) {
                        modelChangeTrigger = new ExpandAllTreeItemsChangeTrigger(currentSession, expandDepthLimit);
                        currentSession.getEventBroker().addLocalTrigger(ExpandAllTreeItemsChangeTrigger.IS_IMPACTING, (ModelChangeTrigger)modelChangeTrigger);
                    }
                    try {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IProgressService ps = wb.getProgressService();
                        try {
                            if (dTreeItem.isExpanded() && all) {
                                ps.busyCursorWhile((IRunnableWithProgress)new ExpandDTreeItemRunnableWithProgress(currentSession, TreeItemExpansionManager.getAllChilrenWithDepth(treeItem, 1, expandDepthLimit), all));
                            }
                            ps.busyCursorWhile((IRunnableWithProgress)new ExpandDTreeItemRunnableWithProgress(currentSession, dTreeItem));
                        }
                        catch (InvocationTargetException e) {
                            TreeUIPlugin.INSTANCE.log(new Status(4, "org.eclipse.sirius.tree.ui", MessageFormat.format(Messages.TreeItemExpansionManager_expandOrCollaseError, Messages.TreeItemExpansionManager_treeExpanding), (Throwable)e));
                        }
                        catch (InterruptedException interruptedException) {
                            isExpandToRevert = !isAlreadyExpanded;
                        }
                    }
                    finally {
                        if (all) {
                            currentSession.getEventBroker().removeLocalTrigger((ModelChangeTrigger)modelChangeTrigger);
                        }
                    }
                } else {
                    boolean bl = isExpandToRevert = !isAlreadyExpanded;
                }
                if (isExpandToRevert) {
                    new ChangeExpandeStateRunnable(treeItem, false).run();
                }
            }
        }
    }

    private static boolean isForDTreeItemExpandable(TreeItem treeItem, IPermissionAuthority currentPermissionAuthority) {
        Object data;
        boolean isForDTreeItemExpandable = true;
        if (treeItem != null && (data = treeItem.getData()) instanceof DTreeItem) {
            boolean canEditFeature;
            DTreeItem dTreeItem = (DTreeItem)data;
            isForDTreeItemExpandable = canEditFeature = currentPermissionAuthority != null && currentPermissionAuthority.canEditFeature((EObject)dTreeItem, TreePackage.Literals.DTREE_ITEM__EXPANDED.getName());
        }
        return isForDTreeItemExpandable;
    }

    private static Map<DTreeItem, Integer> getAllChilrenWithDepth(TreeItem parent, int depth, int expandDepthLimit) {
        LinkedHashMap<DTreeItem, Integer> result = new LinkedHashMap<DTreeItem, Integer>();
        if (depth < expandDepthLimit) {
            int i = 0;
            while (i < parent.getItemCount()) {
                TreeItem treeItem = parent.getItems()[i];
                Object data = treeItem.getData();
                if (data instanceof DTreeItem) {
                    DTreeItem dTreeItem = (DTreeItem)data;
                    if (dTreeItem.isExpanded()) {
                        result.putAll(TreeItemExpansionManager.getAllChilrenWithDepth(treeItem, depth + 1, expandDepthLimit));
                    } else {
                        result.put(dTreeItem, depth);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private void handleDispose() {
        if (this.tree != null) {
            this.tree.removeListener(12, (Listener)this);
            this.tree.removeListener(18, (Listener)this);
            this.tree.removeListener(17, (Listener)this);
        }
        this.tree = null;
        this.session = null;
        this.permissionAuthority = null;
    }
}

