/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.seconditeration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.graph.ElkNode;

public final class InitialPlacement {
    private InitialPlacement() {
    }

    protected static List<RectRow> place(List<ElkNode> rectangles, double boundingWidth, double nodeNodeSpacing) {
        ArrayList<RectRow> rows = new ArrayList<RectRow>();
        RectRow row = new RectRow(0.0);
        double drawingHeight = 0.0;
        row.addBlock(new Block(0.0, 0.0, row, nodeNodeSpacing));
        for (ElkNode rect : rectangles) {
            Block block;
            double potentialRowWidth = row.getWidth() + rect.getWidth();
            if (potentialRowWidth > boundingWidth) {
                block = row.getLastBlock();
                if (InitialPlacement.placeRectInBlock(row, block, rect, boundingWidth, nodeNodeSpacing)) continue;
                rows.add(row);
                row = new RectRow(drawingHeight += row.getHeight());
                row.addBlock(new Block(0.0, row.getY(), row, nodeNodeSpacing));
            }
            if ((block = row.getLastBlock()).getChildren().isEmpty() || InitialPlacement.isSimilarHeight(block, rect, nodeNodeSpacing)) {
                block.addChild(rect);
                continue;
            }
            Block newBlock = new Block(block.getX() + block.getWidth(), row.getY(), row, nodeNodeSpacing);
            row.addBlock(newBlock);
            newBlock.addChild(rect);
        }
        rows.add(row);
        return rows;
    }

    public static boolean placeRectInBlock(RectRow row, Block block, ElkNode rect, double boundingWidth, double nodeNodeSpacing) {
        if (InitialPlacement.isSimilarHeight(block, rect, nodeNodeSpacing)) {
            if (rect.getWidth() + nodeNodeSpacing <= boundingWidth - block.getLastRowNewX() && (block.getLastRowY() - row.getY() + rect.getHeight() + nodeNodeSpacing <= row.getHeight() || row.getChildren().size() == 1)) {
                block.addChild(rect);
                return true;
            }
            if (rect.getWidth() <= boundingWidth - block.getX() && (block.getHeight() + rect.getHeight() + nodeNodeSpacing <= row.getHeight() || row.getChildren().size() == 1)) {
                block.addChildInNewRow(rect);
                return true;
            }
        }
        return false;
    }

    public static boolean isSimilarHeight(Block block, ElkNode rect, double nodeNodeSpacing) {
        if (rect.getHeight() + nodeNodeSpacing >= block.getSmallestRectHeight() && rect.getHeight() + nodeNodeSpacing <= block.getMinHeight()) {
            return true;
        }
        return block.getAverageHeight() * 0.5 <= rect.getHeight() + nodeNodeSpacing && block.getAverageHeight() * 1.5 >= rect.getHeight() + nodeNodeSpacing;
    }
}

