/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.SiriusProjectDependencies;
import org.eclipse.sirius.business.api.query.SiriusProjectDependencyQuery;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.image.ImageDependenciesAnnotationHelper;
import org.eclipse.sirius.business.internal.query.SiriusSessionQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class SessionDetailsReport {
    private static final String ARROW = " -> ";
    private static final String CR = System.lineSeparator();
    private static final String TAB = "  ";
    private static final String SPACE = " ";
    private static final String STARS = "*** ";
    private static final String SEPARATOR = " - ";
    private static final String BRACKET_IN = "[";
    private static final String BRACKET_OUT = "]";
    private static final String COLON = ":";
    private static final String NOT_ANALYSED = "(Not analysed)";
    private static final String TRANSITIVE_DEPENDENCY = "(Transitive dependency)";
    private Session session;
    private IFile resourceAird;

    public SessionDetailsReport(IFile resourceAird) {
        this.resourceAird = resourceAird;
        URI airdURI = URI.createPlatformResourceURI((String)resourceAird.getFullPath().toString(), (boolean)true);
        this.session = SessionManager.INSTANCE.getExistingSession(airdURI);
    }

    public String getSessionFormattedInformation() {
        StringBuilder informations = new StringBuilder();
        informations.append(STARS);
        informations.append(Messages.SessionQuery_Date).append(SPACE).append(Date.from(Instant.now())).append(CR).append(CR);
        this.addDependenciesInformation(informations);
        if (this.session != null) {
            this.addResourcesInformation(informations);
            this.addViewpointsInformation(informations);
            this.addRepresentationsInformation(informations);
        }
        return informations.toString();
    }

    private void addRepresentationsInformation(StringBuilder informations) {
        Collection<DRepresentation> loadedReps = DialectManager.INSTANCE.getAllLoadedRepresentations(this.session);
        List repElements = loadedReps.stream().flatMap(rep -> rep.getRepresentationElements().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        Set representationsWithoutTarget = repElements.stream().filter(repElement -> {
            EObject target = repElement.getTarget();
            return target == null || target.eResource() == null;
        }).map(repElement -> new DRepresentationElementQuery((DRepresentationElement)repElement).getParentRepresentation()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        Collection<DRepresentationDescriptor> allRepDescs = DialectManager.INSTANCE.getAllRepresentationDescriptors(this.session);
        ArrayList<DRepresentationDescriptor> invalidReps = new ArrayList<DRepresentationDescriptor>();
        LinkedHashMap<DRepresentationDescriptor, String> repDescToTags = new LinkedHashMap<DRepresentationDescriptor, String>();
        this.processGeneralInformation(informations, allRepDescs, invalidReps, repDescToTags);
        informations.append(CR).append(Messages.SessionQuery_LoadedReps).append(TAB).append(loadedReps.size()).append(CR);
        informations.append(Messages.SessionQuery_NbRepElements).append(TAB).append(repElements.size()).append(CR);
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_LoadedBrokenReps, representationsWithoutTarget.size())).append(CR);
        representationsWithoutTarget.stream().map(rep -> new DRepresentationQuery((DRepresentation)rep).getRepresentationDescriptor()).forEach(repDescriptor -> {
            informations.append(TAB);
            this.addRepresentationDescriptorSimpleInfo(informations, (DRepresentationDescriptor)repDescriptor);
            informations.append(CR);
        });
        informations.append(Messages.SessionQuery_LoadedBrokenRepsInfo).append(CR);
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_InvalidReps, invalidReps.size())).append(CR);
        invalidReps.stream().forEach(repDescriptor -> {
            informations.append(TAB);
            this.addRepresentationDescriptorSimpleInfo(informations, (DRepresentationDescriptor)repDescriptor);
            informations.append(CR);
        });
        informations.append(Messages.SessionQuery_InvalidRepsInfo).append(CR);
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_RepresentationDescriptorDetails, allRepDescs.size())).append(CR);
        allRepDescs.stream().forEach(repDescriptor -> {
            informations.append(TAB);
            this.addRepresentationDescriptorExtendedInfo(informations, (DRepresentationDescriptor)repDescriptor, (Map<DRepresentationDescriptor, String>)repDescToTags);
            informations.append(CR);
        });
    }

    private void processGeneralInformation(StringBuilder informations, Collection<DRepresentationDescriptor> allRepDescs, List<DRepresentationDescriptor> invalidReps, Map<DRepresentationDescriptor, String> repDescToTags) {
        long nbDiagram = 0L;
        long nbEditionTables = 0L;
        long nbCrossTables = 0L;
        long nbTree = 0L;
        long nbSequence = 0L;
        for (DRepresentationDescriptor dRepresentationDescriptor : allRepDescs) {
            StringBuilder tags = new StringBuilder();
            if (!new DRepresentationDescriptorQuery(dRepresentationDescriptor).isRepresentationValid()) {
                invalidReps.add(dRepresentationDescriptor);
                tags.append(BRACKET_IN + Messages.SessionQuery_TagInvalid + BRACKET_OUT);
            }
            if (dRepresentationDescriptor.isLoadedRepresentation()) {
                tags.append(BRACKET_IN + Messages.SessionQuery_TagLoaded + BRACKET_OUT);
            }
            String simpleNameForDescription = dRepresentationDescriptor.getDescription().getClass().getSimpleName();
            if ((simpleNameForDescription = simpleNameForDescription.replace("Description", "")).contains("Diagram")) {
                ++nbDiagram;
                tags.append(BRACKET_IN + Messages.SessionQuery_Diagram + BRACKET_OUT);
            } else if (simpleNameForDescription.contains("EditionTable")) {
                ++nbEditionTables;
                tags.append(BRACKET_IN + Messages.SessionQuery_EditionTable + BRACKET_OUT);
            } else if (simpleNameForDescription.contains("CrossTable")) {
                ++nbCrossTables;
                tags.append(BRACKET_IN + Messages.SessionQuery_CrossTable + BRACKET_OUT);
            } else if (simpleNameForDescription.contains("Tree")) {
                ++nbTree;
                tags.append(BRACKET_IN + Messages.SessionQuery_Tree + BRACKET_OUT);
            } else if (simpleNameForDescription.contains("Sequence")) {
                ++nbSequence;
                tags.append(BRACKET_IN + Messages.SessionQuery_Sequence + BRACKET_OUT);
            } else {
                tags.append(BRACKET_IN + simpleNameForDescription + BRACKET_OUT);
            }
            repDescToTags.put(dRepresentationDescriptor, tags.toString());
        }
        informations.append(CR).append(STARS);
        informations.append(Messages.SessionQuery_Representations).append(CR).append(CR);
        informations.append(Messages.SessionQuery_AllRepresentations).append(SPACE).append(allRepDescs.size()).append(CR);
        informations.append(TAB).append(Messages.SessionQuery_Diagram).append(COLON).append(SPACE).append(nbDiagram).append(CR);
        informations.append(TAB).append(Messages.SessionQuery_Sequence).append(COLON).append(SPACE).append(nbSequence).append(CR);
        informations.append(TAB).append(Messages.SessionQuery_EditionTable).append(COLON).append(SPACE).append(nbEditionTables).append(CR);
        informations.append(TAB).append(Messages.SessionQuery_CrossTable).append(COLON).append(SPACE).append(nbCrossTables).append(CR);
        informations.append(TAB).append(Messages.SessionQuery_Tree).append(COLON).append(SPACE).append(nbTree).append(CR);
    }

    private void addDependenciesInformation(StringBuilder informations) {
        informations.append(STARS);
        informations.append(Messages.SessionQuery_Dependencies).append(CR);
        SiriusProjectDependencies dependencies = new SiriusProjectDependencyQuery(this.resourceAird.getProject()).getAllDependencies();
        if (dependencies != null) {
            this.addGeneralProjectsDependencies(informations, dependencies);
            this.addImageProjectsDependencies(informations, dependencies);
        } else {
            informations.append(Messages.SessionQuery_sessionNotOpened).append(CR);
        }
        informations.append(CR);
    }

    private void addResourcesInformation(StringBuilder informations) {
        informations.append(STARS);
        informations.append(Messages.SessionQuery_Resources).append(CR);
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_SessionResources, this.session.getAllSessionResources().size())).append(CR);
        this.session.getAllSessionResources().forEach(res -> {
            informations.append(TAB);
            this.addResourceDescription(informations, (Resource)res);
            informations.append(CR);
        });
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_SemanticResources, this.session.getSemanticResources().size())).append(CR);
        this.session.getSemanticResources().forEach(res -> {
            informations.append(TAB);
            this.addResourceDescription(informations, (Resource)res);
            informations.append(CR);
        });
        EList controlledResources = ((DAnalysisSessionEObject)this.session).getControlledResources();
        if (controlledResources.size() > 0) {
            informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_ControlledResources, controlledResources.size())).append(CR);
            controlledResources.forEach(res -> {
                informations.append(TAB);
                this.addResourceDescription(informations, (Resource)res);
                informations.append(CR);
            });
        }
    }

    private String getViewpointDescription(Viewpoint viewpoint) {
        String vpDescription = null;
        if (viewpoint != null) {
            Resource resource = viewpoint.eResource();
            vpDescription = resource == null ? viewpoint.toString() : String.valueOf(viewpoint.getName()) + SPACE + Messages.SessionQuery_LoadedFromResource + SPACE + resource.getURI().toString();
        }
        return vpDescription;
    }

    private void addRepresentationDescriptorExtendedInfo(StringBuilder informations, DRepresentationDescriptor repDescriptor, Map<DRepresentationDescriptor, String> repDescToTags) {
        this.addRepresentationDescriptorSimpleInfo(informations, repDescriptor);
        informations.append(SEPARATOR);
        RepresentationDescription description = repDescriptor.getDescription();
        if (description != null) {
            informations.append("description: ");
            informations.append(description.getName());
            informations.append(SEPARATOR);
            Viewpoint vp = (Viewpoint)description.eContainer();
            if (vp != null) {
                informations.append("viewpoint: ");
                informations.append(vp.getName());
            } else {
                informations.append("viewpoint: null");
            }
        } else {
            informations.append("description: null");
        }
        informations.append(SEPARATOR);
        ResourceDescriptor repPath = repDescriptor.getRepPath();
        if (repPath != null) {
            informations.append("repPath: ");
            informations.append(repPath.toString());
        } else {
            informations.append("repPath: null");
        }
        informations.append(ARROW);
        EObject target = repDescriptor.getTarget();
        if (target != null) {
            informations.append(new EObjectQuery(target).getGenericDecription());
        } else {
            informations.append("null");
        }
        informations.append(TAB);
        informations.append(repDescToTags.get(repDescriptor));
    }

    public void addRepresentationDescriptorSimpleInfo(StringBuilder informations, DRepresentationDescriptor repDescriptor) {
        informations.append(repDescriptor.getName());
        informations.append(SEPARATOR);
        informations.append("uid: ");
        informations.append(repDescriptor.getUid());
    }

    private void addViewpointsInformation(StringBuilder informations) {
        Collection<DView> selectedViews = this.session.getSelectedViews();
        Set selectedViewpointDescriptions = selectedViews.stream().map(view -> view.getViewpoint()).map(this::getViewpointDescription).collect(Collectors.toSet());
        ArrayList<DView> unselectedViews = new ArrayList<DView>(this.session.getOwnedViews());
        unselectedViews.removeAll(selectedViews);
        Set unselectedViewpointDescriptions = unselectedViews.stream().map(view -> view.getViewpoint()).map(this::getViewpointDescription).collect(Collectors.toSet());
        informations.append(CR).append(STARS);
        informations.append(Messages.SessionQuery_Viewpoints).append(CR).append(CR);
        informations.append(MessageFormat.format(Messages.SessionQuery_ActiveViewpoints, selectedViewpointDescriptions.size())).append(CR);
        selectedViewpointDescriptions.stream().forEach(vpURI -> informations.append(TAB).append((String)vpURI).append(CR));
        informations.append(CR);
        informations.append(MessageFormat.format(Messages.SessionQuery_InactiveViewpoints, unselectedViewpointDescriptions.size())).append(CR);
        unselectedViewpointDescriptions.stream().forEach(vpURI -> informations.append(TAB).append((String)vpURI).append(CR));
    }

    private void addResourceDescription(StringBuilder informations, Resource resource) {
        URI uri = resource.getURI();
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(EcoreUtil.getAllProperContents((Resource)resource, (boolean)false), 0);
        long nbElements = StreamSupport.stream(spliterator, false).count();
        long fileSize = 0L;
        Option<IResource> correspondingResource = new URIQuery(uri).getCorrespondingResource();
        if (correspondingResource.some() && correspondingResource.get() instanceof IFile) {
            java.net.URI locationURI = ((IFile)correspondingResource.get()).getLocationURI();
            try {
                fileSize = EFS.getStore((java.net.URI)locationURI).fetchInfo().getLength();
            }
            catch (CoreException coreException) {}
        }
        informations.append(uri.toString()).append(SEPARATOR).append(nbElements).append(SPACE).append(Messages.SessionQuery_Elements).append(SEPARATOR).append(fileSize).append(SPACE).append(Messages.SessionQuery_FileSize);
    }

    private void addGeneralProjectsDependencies(StringBuilder informations, SiriusProjectDependencies dependencies) {
        TreeSet<String> directDependencyProjectNames = new TreeSet<String>(dependencies.getGeneralProjectDirectDependencies());
        TreeSet<String> transitiveDependencyProjectNames = new TreeSet<String>(dependencies.getGeneralProjectTransitiveDependencies());
        TreeSet<String> notAnalysedDependencyProjectNames = new TreeSet<String>(dependencies.getNotAnalysedGeneralProjectDependencies());
        int nbProjects = directDependencyProjectNames.size() + transitiveDependencyProjectNames.size() + notAnalysedDependencyProjectNames.size();
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_GeneralProjectsDependencies, nbProjects)).append(CR);
        directDependencyProjectNames.forEach(project -> {
            informations.append(TAB);
            informations.append((String)project);
            informations.append(CR);
        });
        transitiveDependencyProjectNames.forEach(project -> {
            informations.append(TAB);
            informations.append(TRANSITIVE_DEPENDENCY);
            informations.append((String)project);
            informations.append(CR);
        });
        notAnalysedDependencyProjectNames.forEach(project -> {
            informations.append(TAB);
            informations.append(NOT_ANALYSED);
            informations.append((String)project);
            informations.append(CR);
        });
    }

    private void addImageProjectsDependencies(StringBuilder informations, SiriusProjectDependencies dependencies) {
        TreeSet<String> imageProjectsDirectDependencies = new TreeSet<String>(dependencies.getImageProjectsDirectDependencies());
        if (this.session != null) {
            String sessionProjectName = new SiriusSessionQuery(this.session).getSharedProjectName();
            Set imageProjectsDirectDependenciesSet = this.session.getAllSessionResources().stream().flatMap(res -> res.getContents().stream()).filter(DAnalysis.class::isInstance).map(DAnalysis.class::cast).flatMap(dAnalysis -> ImageDependenciesAnnotationHelper.getAllImageProjectsDirectDependencies(dAnalysis).stream()).filter(projectName -> !projectName.equals(sessionProjectName)).collect(Collectors.toSet());
            imageProjectsDirectDependencies = new TreeSet(imageProjectsDirectDependenciesSet);
        }
        informations.append(CR).append(MessageFormat.format(Messages.SessionQuery_ImageProjectsDependencies, imageProjectsDirectDependencies.size())).append(CR);
        imageProjectsDirectDependencies.forEach(project -> {
            informations.append(TAB);
            informations.append((String)project);
            informations.append(CR);
        });
    }
}

