/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.model.business.internal.query;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class ResourceQueryInternal {
    private Resource resource;

    public ResourceQueryInternal(Resource resource) {
        this.resource = resource;
    }

    public boolean hasControlledRootIn(Collection<Resource> scope) {
        for (EObject root : this.resource.getContents()) {
            Resource containerResource;
            EObject container = root.eContainer();
            Resource resource = containerResource = container != null ? container.eResource() : null;
            if (containerResource == this.resource) continue;
            boolean result = false;
            if (scope.contains(containerResource)) {
                result = true;
            } else if (containerResource != null) {
                result = new ResourceQueryInternal(containerResource).hasControlledRootIn(scope);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    public EObject findSemanticRoot() {
        EClass eClass;
        ExtendedMetaData extendedMetaData;
        EObject root = null;
        EList contents = this.resource.getContents();
        if (contents != null && contents.size() > 0 && (extendedMetaData = ExtendedMetaData.INSTANCE).isDocumentRoot(eClass = (root = (EObject)contents.get(0)).eClass())) {
            EReference xmlnsPrefixMapFeature = extendedMetaData.getXMLNSPrefixMapFeature(eClass);
            EReference xsiSchemaLocationFeature = extendedMetaData.getXSISchemaLocationMapFeature(eClass);
            EAttribute mixedFeatureFeature = extendedMetaData.getMixedFeature(eClass);
            int featureID = 0;
            while (featureID < eClass.getFeatureCount()) {
                Object obj;
                EStructuralFeature feature = eClass.getEStructuralFeature(featureID);
                if (feature != mixedFeatureFeature && feature != xmlnsPrefixMapFeature && feature != xsiSchemaLocationFeature && (obj = root.eGet(feature)) instanceof EObject) {
                    root = (EObject)obj;
                    break;
                }
                ++featureID;
            }
        }
        return root;
    }
}

