/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.ITopdownLayoutProvider;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.data.DeprecatedLayoutOptionReplacer;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutAlgorithmResolver;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.ContentAlignment;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.TopdownNodeTypes;
import org.eclipse.elk.core.options.TopdownSizeApproximator;
import org.eclipse.elk.core.testing.TestController;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class RecursiveGraphLayoutEngine
implements IGraphLayoutEngine {
    @Override
    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        this.layout(layoutGraph, null, progressMonitor);
    }

    public void layout(ElkNode layoutGraph, TestController testController, IElkProgressMonitor progressMonitor) {
        int nodeCount = this.countNodesRecursively(layoutGraph, true);
        progressMonitor.begin("Recursive Graph Layout", nodeCount);
        ElkUtil.applyVisitors(layoutGraph, new DeprecatedLayoutOptionReplacer());
        if (!layoutGraph.hasProperty(CoreOptions.RESOLVED_ALGORITHM)) {
            ElkUtil.applyVisitors(layoutGraph, new LayoutAlgorithmResolver());
        }
        this.layoutRecursively(layoutGraph, testController, progressMonitor);
        progressMonitor.done();
    }

    protected List<ElkEdge> layoutRecursively(ElkNode layoutNode, TestController testController, IElkProgressMonitor progressMonitor) {
        boolean hasInsideSelfLoops;
        if (progressMonitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (((Boolean)layoutNode.getProperty(CoreOptions.NO_LAYOUT)).booleanValue()) {
            return Collections.emptyList();
        }
        boolean hasChildren = !layoutNode.getChildren().isEmpty();
        List<ElkEdge> insideSelfLoops = this.gatherInsideSelfLoops(layoutNode);
        boolean bl = hasInsideSelfLoops = !insideSelfLoops.isEmpty();
        if (hasChildren || hasInsideSelfLoops) {
            int nodeCount;
            LayoutAlgorithmData algorithmData = (LayoutAlgorithmData)layoutNode.getProperty(CoreOptions.RESOLVED_ALGORITHM);
            if (algorithmData == null) {
                throw new UnsupportedConfigurationException("Resolved algorithm is not set; apply a LayoutAlgorithmResolver before computing layout.");
            }
            boolean supportsInsideSelfLoops = algorithmData.supportsFeature(GraphFeature.INSIDE_SELF_LOOPS);
            this.evaluateHierarchyHandlingInheritance(layoutNode);
            if (!hasChildren && hasInsideSelfLoops && !supportsInsideSelfLoops) {
                return Collections.emptyList();
            }
            ArrayList childrenInsideSelfLoops = Lists.newArrayList();
            if (layoutNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN && (algorithmData.supportsFeature(GraphFeature.COMPOUND) || algorithmData.supportsFeature(GraphFeature.CLUSTERS))) {
                if (((Boolean)layoutNode.getProperty(CoreOptions.TOPDOWN_LAYOUT)).booleanValue()) {
                    throw new UnsupportedConfigurationException("Topdown layout cannot be used together with hierarchy handling.");
                }
                nodeCount = this.countNodesWithHierarchy(layoutNode);
                LinkedList nodeQueue = Lists.newLinkedList();
                nodeQueue.addAll(layoutNode.getChildren());
                while (!nodeQueue.isEmpty()) {
                    boolean stopHierarchy;
                    ElkNode node = (ElkNode)nodeQueue.poll();
                    this.evaluateHierarchyHandlingInheritance(node);
                    boolean bl2 = stopHierarchy = node.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN;
                    if (stopHierarchy || node.hasProperty(CoreOptions.ALGORITHM) && !algorithmData.equals(node.getProperty(CoreOptions.RESOLVED_ALGORITHM))) {
                        List<ElkEdge> childLayoutSelfLoops = this.layoutRecursively(node, testController, progressMonitor);
                        childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                        node.setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.SEPARATE_CHILDREN);
                        ElkUtil.applyConfiguredNodeScaling(node);
                        continue;
                    }
                    nodeQueue.addAll(node.getChildren());
                }
            } else {
                nodeCount = layoutNode.getChildren().size();
                if (((Boolean)layoutNode.getProperty(CoreOptions.TOPDOWN_LAYOUT)).booleanValue()) {
                    IElkProgressMonitor topdownLayoutMonitor = progressMonitor.subTask(1.0f);
                    topdownLayoutMonitor.begin("Topdown Layout", 1.0f);
                    if (layoutNode.getProperty(CoreOptions.TOPDOWN_NODE_TYPE) == null) {
                        throw new UnsupportedConfigurationException(String.valueOf(layoutNode.getIdentifier()) + " has not been assigned a top-down node type.");
                    }
                    if (((TopdownNodeTypes)((Object)layoutNode.getProperty(CoreOptions.TOPDOWN_NODE_TYPE))).equals((Object)TopdownNodeTypes.HIERARCHICAL_NODE) || ((TopdownNodeTypes)((Object)layoutNode.getProperty(CoreOptions.TOPDOWN_NODE_TYPE))).equals((Object)TopdownNodeTypes.ROOT_NODE)) {
                        for (ElkNode childNode : layoutNode.getChildren()) {
                            LayoutAlgorithmData localAlgorithmData = (LayoutAlgorithmData)childNode.getProperty(CoreOptions.RESOLVED_ALGORITHM);
                            if (childNode.getChildren().size() > 0 && localAlgorithmData.getInstancePool().fetch() instanceof ITopdownLayoutProvider) {
                                if (((TopdownNodeTypes)((Object)childNode.getProperty(CoreOptions.TOPDOWN_NODE_TYPE))).equals((Object)TopdownNodeTypes.HIERARCHICAL_NODE)) {
                                    throw new UnsupportedConfigurationException("Topdown Layout Providers should only be used on parallel nodes.");
                                }
                                ITopdownLayoutProvider topdownLayoutProvider = (ITopdownLayoutProvider)((Object)localAlgorithmData.getInstancePool().fetch());
                                KVector requiredSize = topdownLayoutProvider.getPredictedGraphSize(childNode);
                                childNode.setDimensions(Math.max(childNode.getWidth(), requiredSize.x), Math.max(childNode.getHeight(), requiredSize.y));
                                continue;
                            }
                            if (childNode.getProperty(CoreOptions.TOPDOWN_SIZE_APPROXIMATOR) == null) continue;
                            TopdownSizeApproximator approximator = (TopdownSizeApproximator)((Object)childNode.getProperty(CoreOptions.TOPDOWN_SIZE_APPROXIMATOR));
                            KVector size = approximator.getSize(childNode);
                            childNode.setDimensions(Math.max(childNode.getWidth(), size.x), Math.max(childNode.getHeight(), size.y));
                        }
                    }
                    ElkPadding padding = (ElkPadding)layoutNode.getProperty(CoreOptions.PADDING);
                    double childAreaAvailableWidth = layoutNode.getWidth() - (padding.left + padding.right);
                    double childAreaAvailableHeight = layoutNode.getHeight() - (padding.top + padding.bottom);
                    topdownLayoutMonitor.log("Available Child Area: (" + childAreaAvailableWidth + "|" + childAreaAvailableHeight + ")");
                    layoutNode.setProperty(CoreOptions.ASPECT_RATIO, (Object)(childAreaAvailableWidth / childAreaAvailableHeight));
                    this.executeAlgorithm(layoutNode, algorithmData, testController, progressMonitor.subTask(nodeCount));
                    if (((TopdownNodeTypes)((Object)layoutNode.getProperty(CoreOptions.TOPDOWN_NODE_TYPE))).equals((Object)TopdownNodeTypes.ROOT_NODE)) {
                        ElkUtil.computeChildAreaDimensions(layoutNode);
                        layoutNode.setDimensions(padding.left + (Double)layoutNode.getProperty(CoreOptions.CHILD_AREA_WIDTH) + padding.right, padding.top + (Double)layoutNode.getProperty(CoreOptions.CHILD_AREA_HEIGHT) + padding.bottom);
                    }
                    topdownLayoutMonitor.log("Executed layout algorithm: " + (String)layoutNode.getProperty(CoreOptions.ALGORITHM) + " on node " + layoutNode.getIdentifier());
                    if (((TopdownNodeTypes)((Object)layoutNode.getProperty(CoreOptions.TOPDOWN_NODE_TYPE))).equals((Object)TopdownNodeTypes.HIERARCHICAL_NODE)) {
                        if (childAreaAvailableWidth < 0.0 || childAreaAvailableHeight < 0.0) {
                            throw new UnsupportedConfigurationException("The size defined by the parent parallel node is too small for the space provided by the paddings of the child hierarchical node. " + layoutNode.getIdentifier());
                        }
                        if (!layoutNode.hasProperty(CoreOptions.CHILD_AREA_WIDTH) && !layoutNode.hasProperty(CoreOptions.CHILD_AREA_HEIGHT)) {
                            ElkUtil.computeChildAreaDimensions(layoutNode);
                        }
                        double childAreaDesiredWidth = (Double)layoutNode.getProperty(CoreOptions.CHILD_AREA_WIDTH);
                        double childAreaDesiredHeight = (Double)layoutNode.getProperty(CoreOptions.CHILD_AREA_HEIGHT);
                        topdownLayoutMonitor.log("Desired Child Area: (" + childAreaDesiredWidth + "|" + childAreaDesiredHeight + ")");
                        double scaleFactorX = childAreaAvailableWidth / childAreaDesiredWidth;
                        double scaleFactorY = childAreaAvailableHeight / childAreaDesiredHeight;
                        double scaleFactor = Math.min(scaleFactorX, Math.min(scaleFactorY, (Double)layoutNode.getProperty(CoreOptions.TOPDOWN_SCALE_CAP)));
                        layoutNode.setProperty(CoreOptions.TOPDOWN_SCALE_FACTOR, (Object)scaleFactor);
                        topdownLayoutMonitor.log(String.valueOf(layoutNode.getIdentifier()) + " -- Local Scale Factor (X|Y): (" + scaleFactorX + "|" + scaleFactorY + ")");
                        Set contentAlignment = (Set)layoutNode.getProperty(CoreOptions.CONTENT_ALIGNMENT);
                        double alignmentShiftX = 0.0;
                        double alignmentShiftY = 0.0;
                        if (scaleFactor < scaleFactorX) {
                            if (contentAlignment.contains((Object)ContentAlignment.H_CENTER)) {
                                alignmentShiftX = (childAreaAvailableWidth / 2.0 - childAreaDesiredWidth * scaleFactor / 2.0) / scaleFactor;
                            } else if (contentAlignment.contains((Object)ContentAlignment.H_RIGHT)) {
                                alignmentShiftX = (childAreaAvailableWidth - childAreaDesiredWidth * scaleFactor) / scaleFactor;
                            }
                        }
                        if (scaleFactor < scaleFactorY) {
                            if (contentAlignment.contains((Object)ContentAlignment.V_CENTER)) {
                                alignmentShiftY = (childAreaAvailableHeight / 2.0 - childAreaDesiredHeight * scaleFactor / 2.0) / scaleFactor;
                            } else if (contentAlignment.contains((Object)ContentAlignment.V_BOTTOM)) {
                                alignmentShiftY = (childAreaAvailableHeight - childAreaDesiredHeight * scaleFactor) / scaleFactor;
                            }
                        }
                        double xShift = alignmentShiftX + (padding.left / scaleFactor - padding.left);
                        double yShift = alignmentShiftY + (padding.top / scaleFactor - padding.top);
                        topdownLayoutMonitor.log("Shift: (" + xShift + "|" + yShift + ")");
                        for (ElkNode node : layoutNode.getChildren()) {
                            node.setX(node.getX() + xShift);
                            node.setY(node.getY() + yShift);
                        }
                        for (ElkEdge edge : layoutNode.getContainedEdges()) {
                            for (ElkEdgeSection section : edge.getSections()) {
                                section.setStartLocation(section.getStartX() + xShift, section.getStartY() + yShift);
                                section.setEndLocation(section.getEndX() + xShift, section.getEndY() + yShift);
                                for (ElkBendPoint bendPoint : section.getBendPoints()) {
                                    bendPoint.set(bendPoint.getX() + xShift, bendPoint.getY() + yShift);
                                }
                            }
                            for (ElkLabel label : edge.getLabels()) {
                                label.setLocation(label.getX() + xShift, label.getY() + yShift);
                            }
                            KVectorChain junctionPoints = (KVectorChain)edge.getProperty(CoreOptions.JUNCTION_POINTS);
                            for (KVector junctionPoint : junctionPoints) {
                                junctionPoint.x += xShift;
                                junctionPoint.y += yShift;
                            }
                            edge.setProperty(CoreOptions.JUNCTION_POINTS, (Object)junctionPoints);
                        }
                    }
                    topdownLayoutMonitor.done();
                }
                for (ElkNode child : layoutNode.getChildren()) {
                    List<ElkEdge> childLayoutSelfLoops = this.layoutRecursively(child, testController, progressMonitor);
                    childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                    ElkUtil.applyConfiguredNodeScaling(child);
                }
            }
            if (progressMonitor.isCanceled()) {
                return Collections.emptyList();
            }
            for (ElkEdge selfLoop : childrenInsideSelfLoops) {
                selfLoop.setProperty(CoreOptions.NO_LAYOUT, (Object)true);
            }
            if (!((Boolean)layoutNode.getProperty(CoreOptions.TOPDOWN_LAYOUT)).booleanValue()) {
                this.executeAlgorithm(layoutNode, algorithmData, testController, progressMonitor.subTask(nodeCount));
            }
            this.postProcessInsideSelfLoops(childrenInsideSelfLoops);
            if (hasInsideSelfLoops && supportsInsideSelfLoops) {
                return insideSelfLoops;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected void executeAlgorithm(ElkNode layoutNode, LayoutAlgorithmData algorithmData, TestController testController, IElkProgressMonitor progressMonitor) {
        AbstractLayoutProvider layoutProvider = algorithmData.getInstancePool().fetch();
        if (testController != null && testController.targets(algorithmData)) {
            testController.install(layoutProvider);
        }
        try {
            try {
                layoutProvider.layout(layoutNode, progressMonitor);
                algorithmData.getInstancePool().release(layoutProvider);
            }
            catch (Exception exception) {
                layoutProvider.dispose();
                throw exception;
            }
        }
        finally {
            if (testController != null) {
                testController.uninstall();
            }
        }
    }

    protected int countNodesRecursively(ElkNode layoutNode, boolean countAncestors) {
        int count = layoutNode.getChildren().size();
        for (ElkNode childNode : layoutNode.getChildren()) {
            if (childNode.getChildren().isEmpty()) continue;
            count += this.countNodesRecursively(childNode, false);
        }
        if (countAncestors) {
            ElkNode parent = layoutNode.getParent();
            while (parent != null) {
                count += parent.getChildren().size();
                parent = parent.getParent();
            }
        }
        return count;
    }

    private void evaluateHierarchyHandlingInheritance(ElkNode layoutNode) {
        if (layoutNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INHERIT) {
            if (layoutNode.getParent() == null) {
                layoutNode.setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.SEPARATE_CHILDREN);
            } else {
                HierarchyHandling parentHandling = (HierarchyHandling)((Object)layoutNode.getParent().getProperty(CoreOptions.HIERARCHY_HANDLING));
                layoutNode.setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)parentHandling);
            }
        }
    }

    private int countNodesWithHierarchy(ElkNode parentNode) {
        int count = parentNode.getChildren().size();
        for (ElkNode childNode : parentNode.getChildren()) {
            LayoutAlgorithmData childData;
            LayoutAlgorithmData parentData;
            if (childNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN || (parentData = (LayoutAlgorithmData)parentNode.getProperty(CoreOptions.RESOLVED_ALGORITHM)) != (childData = (LayoutAlgorithmData)childNode.getProperty(CoreOptions.RESOLVED_ALGORITHM)) && (parentData == null || !parentData.equals(childData)) || childNode.getChildren().isEmpty()) continue;
            count += this.countNodesWithHierarchy(childNode);
        }
        return count;
    }

    protected List<ElkEdge> gatherInsideSelfLoops(ElkNode node) {
        if (((Boolean)node.getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE)).booleanValue()) {
            ArrayList insideSelfLoops = Lists.newArrayList();
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
                if (!edge.isSelfloop() || !((Boolean)edge.getProperty(CoreOptions.INSIDE_SELF_LOOPS_YO)).booleanValue()) continue;
                insideSelfLoops.add(edge);
            }
            return insideSelfLoops;
        }
        return Collections.emptyList();
    }

    protected void postProcessInsideSelfLoops(List<ElkEdge> insideSelfLoops) {
        for (ElkEdge selfLoop : insideSelfLoops) {
            ElkNode node = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)selfLoop.getSources().get(0)));
            double xOffset = node.getX();
            double yOffset = node.getY();
            ElkEdgeSection section = (ElkEdgeSection)selfLoop.getSections().get(0);
            section.setStartLocation(section.getStartX() + xOffset, section.getStartY() + yOffset);
            section.setEndLocation(section.getEndX() + xOffset, section.getEndY() + yOffset);
            for (ElkBendPoint bend : section.getBendPoints()) {
                bend.set(bend.getX() + xOffset, bend.getY() + yOffset);
            }
            ((KVectorChain)selfLoop.getProperty(CoreOptions.JUNCTION_POINTS)).offset(xOffset, yOffset);
        }
    }
}

