/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.model.business.internal.description.spec.ContainerMappingSpec;
import org.eclipse.sirius.diagram.model.business.internal.helper.ContentHelper;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingExtHelper;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class ContainerMappingWithInterpreterHelper {
    private IInterpreter interpreter;

    public ContainerMappingWithInterpreterHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public static DiagramElementMapping getBestMapping(ContainerDropDescription dropTool, DragAndDropTarget targetContainer, EObject droppedElement) {
        DDiagram diagram;
        DiagramElementMapping bestMapping = null;
        Iterator iterCandidates = null;
        if (targetContainer instanceof DDiagram) {
            Session session;
            DDiagram diagram2 = (DDiagram)targetContainer;
            DiagramDescription desc = diagram2.getDescription();
            Collection<Object> selectedViewpoints = Collections.emptyList();
            if (diagram2 instanceof DSemanticDiagram && (session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram2).getTarget())) != null) {
                selectedViewpoints = session.getSelectedViewpoints(false);
            }
            allMappings = new LinkedList<ContainerMapping>((Collection<ContainerMapping>)new DiagramComponentizationManager().getAllContainerMappings(selectedViewpoints, desc));
            allMappings.addAll(ContainerMappingWithInterpreterHelper.getAllMappingsWithSuperMappings(selectedViewpoints, desc));
            allMappings.addAll((Collection<Object>)new DiagramComponentizationManager().getAllEdgeMappings(selectedViewpoints, desc));
            iterCandidates = allMappings.iterator();
        } else if (targetContainer instanceof DDiagramElementContainer) {
            DDiagramElementContainer elementContainer = (DDiagramElementContainer)targetContainer;
            RepresentationElementMapping mapping = elementContainer.getMapping();
            if (mapping instanceof ContainerMapping) {
                ContainerMapping containerMapping = (ContainerMapping)mapping;
                allMappings = new LinkedList(MappingHelper.getAllContainerMappings((ContainerMapping)containerMapping));
                allMappings.addAll(ContainerMappingWithInterpreterHelper.getAllMappingsWithSuperMappings(containerMapping));
                allMappings.addAll((Collection<Object>)MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)containerMapping));
                diagram = elementContainer.getParentDiagram();
                DiagramDescription desc = diagram.getDescription();
                allMappings.addAll((Collection<Object>)ContentHelper.getAllEdgeMappings((DiagramDescription)desc, (boolean)false));
                iterCandidates = allMappings.iterator();
            }
        } else if (targetContainer instanceof DNode) {
            DNode viewNode = (DNode)targetContainer;
            NodeMapping nodeMapping = viewNode.getActualMapping();
            LinkedList allMappings = new LinkedList(MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)nodeMapping));
            iterCandidates = allMappings.iterator();
        }
        if (iterCandidates == null) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ContainerDropDescriptionSpec_unknownTgtMsg, targetContainer), (Throwable)new RuntimeException());
            return null;
        }
        Session session = SessionManager.INSTANCE.getSession(droppedElement);
        ModelAccessor extendedPackage = session.getModelAccessor();
        while (iterCandidates.hasNext()) {
            DiagramMappingsManager mappingManager;
            DiagramElementMapping currentMapping = (DiagramElementMapping)iterCandidates.next();
            String domainClass = ContainerMappingWithInterpreterHelper.getDomainClass(currentMapping);
            if (!dropTool.getMappings().contains((Object)currentMapping) || domainClass == null || StringUtil.isEmpty((String)domainClass.trim()) || !extendedPackage.eInstanceOf(droppedElement, domainClass) || (diagram = ContainerMappingWithInterpreterHelper.getDiagram(targetContainer)) == null || !LayerHelper.isInActivatedLayer(mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram), diagram, currentMapping)) continue;
            bestMapping = currentMapping;
            break;
        }
        return bestMapping;
    }

    private static Collection<DiagramElementMapping> getAllMappingsWithSuperMappings(ContainerMapping containerMapping) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (NodeMapping nM : MappingHelper.getAllNodeMappings((ContainerMapping)containerMapping)) {
            result.add((DiagramElementMapping)nM);
        }
        return result;
    }

    private static Collection<DiagramElementMapping> getAllMappingsWithSuperMappings(Collection<Viewpoint> selectedViewpoints, DiagramDescription desc) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (NodeMapping nM : new DiagramComponentizationManager().getAllNodeMappings(selectedViewpoints, desc)) {
            result.add((DiagramElementMapping)nM);
        }
        return result;
    }

    private static DDiagram getDiagram(DragAndDropTarget target) {
        DDiagram diagram = null;
        if (target instanceof DDiagramElement) {
            diagram = ((DDiagramElement)target).getParentDiagram();
        } else if (target instanceof DDiagram) {
            diagram = (DDiagram)target;
        }
        return diagram;
    }

    private static String getDomainClass(DiagramElementMapping mapping) {
        String domainClass = null;
        if (mapping instanceof EdgeMapping) {
            EdgeMapping edgeMapping = (EdgeMapping)mapping;
            if (edgeMapping.isUseDomainElement()) {
                domainClass = edgeMapping.getDomainClass();
            }
        } else if (mapping instanceof AbstractNodeMapping) {
            domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
        }
        return domainClass;
    }

    public DDiagramElementContainer createContainer(ContainerMapping self, EObject modelElement, EObject container, DDiagram dDiagram) {
        ContainerStyle containerStyle;
        DNodeList newContainer = null;
        if (new ContainerMappingQuery(self).isListContainer()) {
            newContainer = DiagramFactory.eINSTANCE.createDNodeList();
        } else {
            newContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
            DNodeContainer nodeContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
            nodeContainer.setChildrenPresentation(self.getChildrenPresentation());
            newContainer = nodeContainer;
        }
        ContainerStyleDescription style = (ContainerStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, modelElement, (EObject)newContainer, container, dDiagram);
        newContainer.setTarget(modelElement);
        newContainer.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)self, (DDiagramElement)newContainer, this.interpreter);
        this.interpreter.setVariable("diagram", (Object)dDiagram);
        this.interpreter.setVariable("view", (Object)newContainer);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                newContainer.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if ((containerStyle = (ContainerStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)self, modelElement, (EObject)newContainer, container, dDiagram)) != null) {
            newContainer.setOwnedStyle(containerStyle);
        }
        if (newContainer.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle((Style)newContainer.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        MappingExtHelper.addDoneNode((AbstractNodeMapping)self, (DDiagramElement)newContainer);
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        AbstractNodeMappingSpecOperations.createBorderingNodes((AbstractNodeMapping)self, modelElement, (DDiagramElement)newContainer, Collections.EMPTY_LIST, dDiagram);
        return newContainer;
    }

    public void updateContainer(ContainerMapping self, DDiagramElementContainer container) {
        DSemanticDecorator cContainer = (DSemanticDecorator)container.eContainer();
        ContainerStyleDescription style = null;
        DDiagram parentDiagram = container.getParentDiagram();
        if (cContainer != null) {
            style = (ContainerStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, container.getTarget(), (EObject)container, (EObject)container, parentDiagram);
        }
        this.interpreter.setVariable("view", (Object)container);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(container.getTarget(), style.getLabelExpression());
                container.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if (style != null && style.getTooltipExpression() != null) {
            try {
                try {
                    this.interpreter.setVariable("view", (Object)container);
                    String tooltip = this.interpreter.evaluateString(container.getTarget(), style.getTooltipExpression());
                    container.setTooltipText(tooltip);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression(), (Throwable)e);
                    this.interpreter.unSetVariable("view");
                }
            }
            finally {
                this.interpreter.unSetVariable("view");
            }
        }
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)self, (DDiagramElement)container, this.interpreter);
        EObject containerVariable = null;
        if (container.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)container.eContainer()).getTarget();
        }
        Style currentStyle = container.getStyle();
        Style bestStyle = new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)self, container.getTarget(), (EObject)container, containerVariable, parentDiagram);
        StyleHelper sHelper = new StyleHelper(this.interpreter);
        if (currentStyle == null) {
            sHelper.setAndRefreshStyle((DDiagramElement)container, null, bestStyle);
        } else if (currentStyle.getCustomFeatures().isEmpty()) {
            if (currentStyle.getDescription() != bestStyle.getDescription() || !currentStyle.equals(bestStyle)) {
                sHelper.setAndRefreshStyle((DDiagramElement)container, currentStyle, bestStyle);
            } else {
                sHelper.refreshStyle(currentStyle);
            }
        }
        MappingExtHelper.addDoneNode((AbstractNodeMapping)self, (DDiagramElement)container);
    }

    public ContainerStyle getBestStyle(ContainerMapping containerMapping, EObject modelElement, EObject viewVariable, EObject containerVariable) {
        ContainerStyle result = null;
        if (containerMapping instanceof ContainerMappingImport) {
            ContainerMappingImport containerMappingImport = (ContainerMappingImport)containerMapping;
            StyleHelper sHelper = new StyleHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement));
            result = sHelper.createContainerStyle(containerMapping.getStyle());
            ContainerMapping importedMappingStyle = containerMappingImport.getImportedMapping();
            if (result == null && importedMappingStyle != null && importedMappingStyle != containerMapping) {
                result = importedMappingStyle instanceof ContainerMappingSpec ? (ContainerStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)importedMappingStyle, modelElement, viewVariable, containerVariable, (DDiagram)new EObjectQuery(viewVariable).getParentDiagram().get()) : this.getBestStyle(importedMappingStyle, modelElement, viewVariable, containerVariable);
            }
        }
        return result;
    }
}

