/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.compatibility.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.acceleo.ui.interpreter.internal.compatibility.view.IFormMessageManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.widgets.Form;

public class FormMessageManagerGanymede
implements IFormMessageManager {
    private static final String[] MULTIPLE_MESSAGE_SUMMARY_KEYS = new String[]{"interpreter.message.summary.information", "interpreter.message.summary.information", "interpreter.message.summary.warning", "interpreter.message.summary.error"};
    private final Form managedForm;
    private List<Message> messages = new ArrayList<Message>();

    public FormMessageManagerGanymede(Form managedForm) {
        this.managedForm = managedForm;
    }

    @Override
    public synchronized void addMessage(Object key, String message, int type) {
        int index = -1;
        int i = 0;
        while (i < this.messages.size() && index == -1) {
            if (key.equals(this.messages.get(i).getKey())) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.messages.remove(index);
        }
        this.messages.add(new Message(key, message, type));
        this.updateMessages();
    }

    @Override
    public synchronized void addMessage(String key, String message, int type, Control control) {
        int index = -1;
        int i = 0;
        while (i < this.messages.size() && index == -1) {
            if (key.equals(this.messages.get(i).getKey())) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.messages.remove(index);
        }
        this.messages.add(new Message(key, message, type, control));
        this.updateMessages();
    }

    @Override
    public synchronized void removeAllMessages() {
        this.messages.clear();
        this.updateMessages();
    }

    @Override
    public synchronized void removeMessage(Object key) {
        int index = -1;
        int i = 0;
        while (i < this.messages.size() && index == -1) {
            if (key.equals(this.messages.get(i).getKey())) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.messages.remove(index);
        }
    }

    @Override
    public synchronized void removeMessages(Control control) {
        for (Message message : new ArrayList<Message>(this.messages)) {
            if (!control.equals(message.getControl())) continue;
            this.messages.remove(message);
        }
    }

    @Override
    public void setDecorationPosition(int position) {
    }

    private synchronized void updateMessages() {
        if (this.messages.isEmpty()) {
            this.managedForm.setMessage(null, 0);
        } else if (this.messages.size() == 1) {
            Message message = this.messages.get(0);
            this.managedForm.setMessage(message.getMessage(), message.getMessageType());
        } else {
            Collections.sort(this.messages);
            int type = this.messages.get(0).getMessageType();
            String summary = InterpreterMessages.getString(MULTIPLE_MESSAGE_SUMMARY_KEYS[type], this.messages.size());
            this.managedForm.setMessage(summary, type, this.messages.toArray(new IMessage[this.messages.size()]));
        }
    }

    private class Message
    implements Comparable<Message>,
    IMessage {
        private Control control;
        private Object key;
        private String message;
        private int type;

        Message(Object key, String message, int type) {
            this(key, message, type, null);
        }

        Message(Object key, String message, int type, Control control) {
            this.key = key;
            this.message = message;
            this.type = type;
            this.control = control;
        }

        @Override
        public int compareTo(Message o) {
            if (this.type < o.type) {
                return 1;
            }
            return this.message.compareTo(o.message);
        }

        public Control getControl() {
            return this.control;
        }

        public Object getData() {
            return null;
        }

        public Object getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }

        public String getPrefix() {
            return null;
        }
    }
}

