/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EndLabelStyle;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;

public class DEdgeQuery
extends DDiagramElementQuery {
    private final DEdge edge;

    public DEdgeQuery(DEdge edge) {
        super((DDiagramElement)edge);
        this.edge = edge;
    }

    public boolean hasNonEmptyNameDefinition() {
        return this.hasNonEmptyNameDefinition((EStructuralFeature)StylePackage.Literals.EDGE_STYLE_DESCRIPTION__CENTER_LABEL_STYLE_DESCRIPTION);
    }

    private boolean hasNonEmptyNameDefinition(EStructuralFeature labelStyleFeature) {
        Object labelStyle;
        EdgeMapping edgeMapping;
        EdgeStyleDescription style;
        boolean hasEmptyNameDefinition = true;
        IEdgeMapping actualMapping = this.edge.getActualMapping();
        if (actualMapping instanceof EdgeMapping && (style = (edgeMapping = (EdgeMapping)actualMapping).getStyle()) != null && (labelStyle = style.eGet(labelStyleFeature)) instanceof BasicLabelStyleDescription) {
            String labelExpression = ((BasicLabelStyleDescription)labelStyle).getLabelExpression();
            hasEmptyNameDefinition = labelExpression.trim().length() != 0;
        }
        return hasEmptyNameDefinition;
    }

    public boolean hasNonEmptyNamesDefinition() {
        return this.hasNonEmptyBeginNameDefinition() || this.hasNonEmptyEndNameDefinition() || this.hasNonEmptyNameDefinition();
    }

    public boolean hasNonEmptyBeginNameDefinition() {
        return this.hasNonEmptyNameDefinition((EStructuralFeature)StylePackage.Literals.EDGE_STYLE_DESCRIPTION__BEGIN_LABEL_STYLE_DESCRIPTION);
    }

    public boolean hasNonEmptyEndNameDefinition() {
        return this.hasNonEmptyNameDefinition((EStructuralFeature)StylePackage.Literals.EDGE_STYLE_DESCRIPTION__END_LABEL_STYLE_DESCRIPTION);
    }

    public boolean hasBeginName() {
        return this.edge.getBeginLabel() != null && !this.edge.getBeginLabel().isEmpty();
    }

    public boolean hasEndName() {
        return this.edge.getEndLabel() != null && !this.edge.getEndLabel().isEmpty();
    }

    public boolean hasCenterName() {
        return this.edge.getName() != null && !this.edge.getName().isEmpty();
    }

    public int howManyLabels() {
        int labelCount = 0;
        if (this.hasBeginName()) {
            ++labelCount;
        }
        if (this.hasCenterName()) {
            ++labelCount;
        }
        if (this.hasEndName()) {
            ++labelCount;
        }
        return labelCount;
    }

    public Option<CenterLabelStyle> getCenterLabelStyle() {
        return Options.newSome((Object)this.edge.getOwnedStyle().getCenterLabelStyle());
    }

    public Option<BeginLabelStyle> getBeginLabelStyle() {
        return Options.newSome((Object)this.edge.getOwnedStyle().getBeginLabelStyle());
    }

    public Option<EndLabelStyle> getEndLabelStyle() {
        return Options.newSome((Object)this.edge.getOwnedStyle().getEndLabelStyle());
    }

    public boolean hasName() {
        boolean hasName = this.edge.getName() != null || this.edge.getEndLabel() != null || this.edge.getBeginLabel() != null;
        return hasName;
    }

    @Override
    public boolean areAllLabelsHidden() {
        Set hideLabelFilterSet = this.edge.getGraphicalFilters().stream().filter(HideLabelFilter.class::isInstance).map(HideLabelFilter.class::cast).collect(Collectors.toSet());
        if (!hideLabelFilterSet.isEmpty()) {
            HideLabelFilter hideLabelFilter = (HideLabelFilter)hideLabelFilterSet.iterator().next();
            return hideLabelFilter.getHiddenLabels().isEmpty() || hideLabelFilter.getHiddenLabels().size() == this.howManyLabels();
        }
        return false;
    }

    @Override
    public boolean isCustomized() {
        boolean isCustom = false;
        if (this.edge.getOwnedStyle() != null) {
            EdgeStyle edgeStyle = this.edge.getOwnedStyle();
            boolean bl = isCustom = !edgeStyle.getCustomFeatures().isEmpty();
            if (!isCustom && edgeStyle.getBeginLabelStyle() != null) {
                boolean bl2 = isCustom = !edgeStyle.getBeginLabelStyle().getCustomFeatures().isEmpty();
            }
            if (!isCustom && edgeStyle.getCenterLabelStyle() != null) {
                boolean bl3 = isCustom = !edgeStyle.getCenterLabelStyle().getCustomFeatures().isEmpty();
            }
            if (!isCustom && edgeStyle.getEndLabelStyle() != null) {
                isCustom = !edgeStyle.getEndLabelStyle().getCustomFeatures().isEmpty();
            }
        }
        return isCustom;
    }
}

