/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.filter.FilterTools;

public class SetCurrentConcernCommand
extends RecordingCommand {
    private final ConcernDescription desc;
    private final DDiagram diagram;

    public SetCurrentConcernCommand(TransactionalEditingDomain domain, DDiagram diagram, ConcernDescription desc) {
        super(domain, Messages.SetCurrentConcernCommand_label);
        this.diagram = diagram;
        this.desc = desc;
    }

    public boolean canUndo() {
        return false;
    }

    protected void doExecute() {
        if (this.diagram == null || this.desc == null) {
            return;
        }
        NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)5);
        ConcernDescription previousConcern = this.diagram.getCurrentConcern();
        if (this.diagram.getFilterVariableHistory() == null) {
            this.diagram.setFilterVariableHistory(DiagramFactory.eINSTANCE.createFilterVariableHistory());
        }
        try {
            for (FilterDescription fil : this.desc.getFilters()) {
                if (!(fil instanceof CompositeFilterDescription)) continue;
                for (Object objFilter : ((CompositeFilterDescription)fil).getFilters()) {
                    if (!(objFilter instanceof VariableFilter) || !(this.diagram instanceof DSemanticDiagram)) continue;
                    VariableFilter filter = (VariableFilter)objFilter;
                    FilterTools.askForFilterValues((DSemanticDiagram)this.diagram, filter);
                }
            }
            ConcernService.setCurrentConcern((DDiagram)this.diagram, (ConcernDescription)this.desc);
        }
        catch (InterruptedException interruptedException) {
            ConcernService.setCurrentConcern((DDiagram)this.diagram, (ConcernDescription)previousConcern);
        }
    }
}

