/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.networksimplex;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.common.networksimplex.NEdge;
import org.eclipse.elk.alg.common.networksimplex.NGraph;

public final class NNode {
    public int id;
    protected int internalId;
    public Object origin;
    public String type = "";
    public int layer;
    private ChangeAwareArrayList<NEdge> outgoingEdges = new ChangeAwareArrayList();
    private int outgoingEdgesModCnt = -1;
    private ChangeAwareArrayList<NEdge> incomingEdges = new ChangeAwareArrayList();
    private int incomingEdgesModCnt = -1;
    private ArrayList<NEdge> allEdges = Lists.newArrayList();
    protected boolean treeNode = false;
    protected Collection<NEdge> unknownCutvalues = Lists.newArrayList();

    private NNode() {
    }

    public static NNodeBuilder of() {
        return new NNodeBuilder();
    }

    public List<NEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public List<NEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<NEdge> getConnectedEdges() {
        if (this.incomingEdgesModCnt != this.incomingEdges.getModCnt() || this.outgoingEdgesModCnt != this.outgoingEdges.getModCnt()) {
            this.allEdges.clear();
            this.allEdges.ensureCapacity(this.incomingEdges.size() + this.outgoingEdges.size());
            this.allEdges.addAll(this.incomingEdges);
            this.allEdges.addAll(this.outgoingEdges);
            this.incomingEdgesModCnt = this.incomingEdges.getModCnt();
            this.outgoingEdgesModCnt = this.outgoingEdges.getModCnt();
        }
        return this.allEdges;
    }

    private static class ChangeAwareArrayList<E>
    implements List<E> {
        private final ArrayList<E> list = Lists.newArrayList();
        private int modCount;

        private ChangeAwareArrayList() {
        }

        private int getModCnt() {
            return this.modCount;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.list.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public boolean add(E e) {
            ++this.modCount;
            return this.list.add(e);
        }

        @Override
        public boolean remove(Object o) {
            ++this.modCount;
            return this.list.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            ++this.modCount;
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            ++this.modCount;
            return this.list.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = this.list.removeAll(c);
            if (changed) {
                ++this.modCount;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean changed = this.list.retainAll(c);
            if (changed) {
                ++this.modCount;
            }
            return changed;
        }

        @Override
        public void clear() {
            ++this.modCount;
            this.list.clear();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E set(int index, E element) {
            ++this.modCount;
            return this.list.set(index, element);
        }

        @Override
        public void add(int index, E element) {
            ++this.modCount;
            this.list.add(index, element);
        }

        @Override
        public E remove(int index) {
            ++this.modCount;
            return this.list.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }
    }

    public static final class NNodeBuilder {
        private NNode node = new NNode();

        private NNodeBuilder() {
        }

        public NNodeBuilder id(int id) {
            this.node.id = id;
            return this;
        }

        public NNodeBuilder origin(Object origin) {
            this.node.origin = origin;
            return this;
        }

        public NNodeBuilder type(String type) {
            this.node.type = type;
            return this;
        }

        public NNode create(NGraph graph) {
            graph.nodes.add(this.node);
            return this.node;
        }
    }
}

