/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.api.TreeTestCase;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;

public class TreeVariablesTest
extends TreeTestCase {
    private static String TREE_REPRESENTATION_NAME = "Tree";
    private static String PATH = "/data/tree/unit/variables/";
    private static String SEMANTIC_RESOURCE_FILENAME = "My.ecore";
    private static String MODELER_RESOURCE_FILENAME = "project.odesign";
    private static String SESSION_RESOURCE_FILENAME = "representations.aird";
    final String SEMANTIC_MODEL_PATH = "/org.eclipse.sirius.tests.junit" + PATH + SEMANTIC_RESOURCE_FILENAME;
    final String MODELER_PATH = "/org.eclipse.sirius.tests.junit" + PATH + MODELER_RESOURCE_FILENAME;
    final String SESSION_PATH = "/org.eclipse.sirius.tests.junit" + PATH + SESSION_RESOURCE_FILENAME;
    private IEditorPart openedEditor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.genericSetUp(this.SEMANTIC_MODEL_PATH, this.MODELER_PATH, this.SESSION_PATH);
        DTree tree = (DTree)this.getRepresentations(TREE_REPRESENTATION_NAME).toArray()[0];
        this.openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)tree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
    }

    public void testAvailableVariablesForTreeItem() {
        AbstractDTreeEditor treeEditor = (AbstractDTreeEditor)this.openedEditor;
        Tree tree = treeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        TreeVariablesTest.assertEquals((String)"Elements are not represented as expected", (String)TreeVariablesTest.getModelHtml(), (String)currentHtml);
    }

    private static String getModelHtml() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p4"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p5"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p6"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p7"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p7"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p8"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p6"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p7"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p9"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p10"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p11"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p11"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p12"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p10"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("p11"));
        return TreeUIHelper.toHTML(expected);
    }
}

