/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.page;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.ResourcePool;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PageNumber;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PageNumberFormat;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PageNumberPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PageNumberPrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.text.TextStyle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class PageNumberIterator
implements PrintIterator {
    private final Device device;
    private final GC gc;
    final PageNumber pageNumber;
    final TextStyle textStyle;
    final PageNumberFormat format;
    final Point size;
    boolean hasNext = true;

    PageNumberIterator(PageNumberPrint print, Device device, GC gc) {
        this.device = device;
        this.gc = gc;
        this.pageNumber = print.pageNumber;
        this.textStyle = print.textStyle;
        this.format = print.format;
        Font oldFont = gc.getFont();
        try {
            gc.setFont(ResourcePool.forDevice(device).getFont(this.textStyle.getFontData()));
            this.size = gc.textExtent(this.format.format(new PageNumber(){

                @Override
                public int getPageCount() {
                    return 9999;
                }

                @Override
                public int getPageNumber() {
                    return 9998;
                }
            }));
        }
        finally {
            gc.setFont(oldFont);
        }
    }

    PageNumberIterator(PageNumberIterator that) {
        this.device = that.device;
        this.gc = that.gc;
        this.pageNumber = that.pageNumber;
        this.textStyle = that.textStyle;
        this.format = that.format;
        this.size = that.size;
        this.hasNext = that.hasNext;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Point minimumSize() {
        return this.size;
    }

    @Override
    public Point preferredSize() {
        return this.size;
    }

    @Override
    public PrintPiece next(int width, int height) {
        if (width < this.size.x || height < this.size.y) {
            return null;
        }
        Point size = new Point(this.size.x, this.size.y);
        int align = this.textStyle.getAlignment();
        if (align == 0x1000000 || align == 131072) {
            size.x = width;
        }
        PageNumberPiece piece = new PageNumberPiece(this, this.device, size);
        this.hasNext = false;
        return piece;
    }

    @Override
    public PrintIterator copy() {
        return new PageNumberIterator(this);
    }
}

