/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.source.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.docmlet.tex.core.source.doc.TexDocumentConstants;
import org.eclipse.statet.docmlet.tex.core.source.util.LtxChunkHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.ltk.text.core.HeuristicTokenScanner;

@NonNullByDefault
public class LtxHeuristicTokenScanner
extends HeuristicTokenScanner {
    public static final CharPairSet LTX_BRACKETS = new CharPairSet(ImCollections.newIdentityList((Object[])new CharPair[]{Chars.CURLY_BRACKETS, Chars.ROUND_BRACKETS, Chars.SQUARE_BRACKETS}), '\\');

    public static boolean isEscaped(IDocument document, int offset) throws BadLocationException {
        boolean escaped = false;
        while (offset > 0 && document.getChar(--offset) == '\\') {
            boolean bl = escaped = !escaped;
        }
        return escaped;
    }

    public static int getSafeMathPartitionOffset(IDocumentPartitioner partitioner, int offset) throws BadLocationException, BadPartitioningException {
        int startOffset = offset;
        while (offset > 0) {
            ITypedRegion partition = partitioner.getPartition(offset - 1);
            String partitionType = partition.getType();
            if (partitionType == "Ltx.Default" || partitionType == "Ltx.Comment" || partitionType == "Ltx.Verbatim") {
                return startOffset;
            }
            offset = partitionType == "Ltx.Math" ? (startOffset = partition.getOffset()) : partition.getOffset();
        }
        return startOffset;
    }

    public static LtxHeuristicTokenScanner create(DocContentSections documentContentInfo) {
        return documentContentInfo.getPrimaryType() == "org.eclipse.statet.Ltx" ? new LtxHeuristicTokenScanner(documentContentInfo) : new LtxChunkHeuristicTokenScanner(documentContentInfo);
    }

    protected LtxHeuristicTokenScanner(DocContentSections documentContentInfo) {
        super(documentContentInfo, TexDocumentConstants.LTX_DEFAULT_CONTENT_CONSTRAINT);
    }

    public void configure(IDocument document, String partitionType) {
        if (partitionType == "Ltx.Math") {
            super.configure(document, new PartitionConstraint(){
                private boolean never;

                public boolean matches(String contentType) {
                    if (this.never) {
                        return false;
                    }
                    if (contentType == "Ltx.Math") {
                        return true;
                    }
                    if (LtxHeuristicTokenScanner.this.getDefaultPartitionConstraint().matches(contentType)) {
                        this.never = true;
                    }
                    return false;
                }
            });
            return;
        }
        super.configure(document, partitionType);
    }

    public @NonNull CharPairSet getDefaultBrackets() {
        return LTX_BRACKETS;
    }
}

