/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.rh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.server.RjsException;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.dbg.DbgListener;
import org.eclipse.statet.rj.server.dbg.ElementTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.ElementTracepoints;
import org.eclipse.statet.rj.server.dbg.FlagTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.SrcfileData;
import org.eclipse.statet.rj.server.dbg.Srcfiles;
import org.eclipse.statet.rj.server.dbg.Srcref;
import org.eclipse.statet.rj.server.dbg.TracepointEvent;
import org.eclipse.statet.rj.server.dbg.TracepointPosition;
import org.eclipse.statet.rj.server.dbg.TracepointState;
import org.eclipse.statet.rj.server.dbg.TracepointStatesUpdate;
import org.eclipse.statet.rj.server.dbg.Tracepoints;
import org.eclipse.statet.rj.server.rh.Handle;
import org.eclipse.statet.rj.server.rh.ObjectManager;
import org.eclipse.statet.rj.server.rh.ParsedExpr;
import org.eclipse.statet.rj.server.rh.RhEnv;

@NonNullByDefault
public abstract class AbstractTracepointManager {
    protected static final String TOPLEVEL_ELEMENT_ID = "200:";
    private static final String ENV_INSTALLED_TAG = "#w:dbg.tracepoints";
    private static final int MAX_HISTORY = 12;
    private static final int MAX_FUZZY = 8;
    protected static final ImList<TracepointPosition> NO_POSITIONS = ImCollections.emptyList();
    protected static final ElementTracepoints NO_POSITION_ELEMENT_TRACEPOINTS = new ElementTracepoints(new SrcfileData(null, null, 0L), "", null, (List<TracepointPosition>)NO_POSITIONS);
    protected static final ElementTracepoints NO_CHANGE_ELEMENT_TRACEPOINTS = new ElementTracepoints(new SrcfileData(null, null, 0L), "", null, (List<TracepointPosition>)NO_POSITIONS);
    protected final ObjectManager objManager;
    private final DbgListener listener;
    private final Map<String, PathEntry> pathMap = new HashMap<String, PathEntry>(32);
    private @Nullable ImList<PathEntry> pathList;
    private final Object stateUpdate = new Object();
    private volatile boolean isAnyEnabled;
    private final IdentitySet<String> envTags = new CopyOnWriteIdentityListSet();
    private boolean isBreakpointsEnabled = true;
    private @Nullable RhEnv updatingEnv;
    private boolean updatingEnvComplete;
    private final StateSet updatingStates = new StateSet(32);

    private static final boolean containsCommonElement(List<? extends ElementTracepoints> list) {
        for (ElementTracepoints elementTracepoints : list) {
            if (elementTracepoints.getElementId().equals(TOPLEVEL_ELEMENT_ID)) continue;
            return true;
        }
        return false;
    }

    private static final int indexOfStateEntry(List<StateEntry> entries, long id) {
        int idx = 0;
        while (idx < entries.size()) {
            if (entries.get(idx).getId() == id) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    protected static final @Nullable StateEntry getBreakpointState(StateSet states, long id) {
        StateEntry entry;
        TracepointState state;
        int idx = states.indexOfId(id);
        if (idx >= 0 && (state = (entry = (StateEntry)states.get(idx)).getState()) != null && (state.getType() & 0xF) != 0) {
            return entry;
        }
        return null;
    }

    protected static final @Nullable StateEntry getBreakpointState(StateSet states, @Nullable String elementId, int @Nullable [] index) {
        if (elementId != null && index != null) {
            int i = 0;
            while (i < states.size()) {
                StateEntry entry = (StateEntry)states.get(i);
                TracepointState state = entry.getState();
                if (state != null && (state.getType() & 0xF) != 0 && elementId.equals(state.getElementId()) && Arrays.equals(index, state.getIndex())) {
                    return entry;
                }
                ++i;
            }
        }
        return null;
    }

    private static final boolean isAllDeleted(List<? extends TracepointPosition> positions, StateSet states) {
        return false;
    }

    public AbstractTracepointManager(ObjectManager objManager, DbgListener listener) {
        this.objManager = objManager;
        this.listener = listener;
        this.objManager.addEnvListener(new ObjectManager.EnvListener(){

            @Override
            public void onEnvRemoved(RhEnv env, boolean finalized) {
                if (finalized && env.isReg(AbstractTracepointManager.ENV_INSTALLED_TAG)) {
                    AbstractTracepointManager.this.updateInstOnRemoved(env);
                }
            }
        });
    }

    protected boolean isAnyTracepointEnabled() {
        return this.isAnyEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PathEntry ensurePathEntry(String path) {
        Map<String, PathEntry> map = this.pathMap;
        synchronized (map) {
            PathEntry entry = this.pathMap.get(path);
            if (entry == null) {
                entry = new PathEntry(path);
                this.pathMap.put(path, entry);
                this.pathList = null;
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImList<PathEntry> getPathEntries() {
        Map<String, PathEntry> map = this.pathMap;
        synchronized (map) {
            ImList pathList = this.pathList;
            if (pathList == null) {
                this.pathList = pathList = ImCollections.toList(this.pathMap.values());
            }
            return pathList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable PathEntry getPathEntry(String path) {
        Map<String, PathEntry> map = this.pathMap;
        synchronized (map) {
            return this.pathMap.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable PathEntry findPathEntryByFileName(String fileName) {
        Map<String, PathEntry> map = this.pathMap;
        synchronized (map) {
            for (PathEntry entry : this.pathMap.values()) {
                SrcfileData srcfile = entry.srcfile;
                if (srcfile == null || !fileName.equals(srcfile.getName())) continue;
                return entry;
            }
            return null;
        }
    }

    private void addTracepoints(ElementTracepoints tracepoints, long updateStamp) {
        SrcfileData srcfile = tracepoints.getSrcfile();
        String srcfilePath = srcfile.getPath();
        if (srcfilePath != null) {
            PathEntry entry = this.ensurePathEntry(srcfilePath);
            entry.addTracepoints(tracepoints, updateStamp);
        }
    }

    protected void addTracepoints(List<? extends ElementTracepoints> tracepointsList) {
        long updateStamp = System.nanoTime();
        for (ElementTracepoints elementTracepoints : tracepointsList) {
            this.addTracepoints(elementTracepoints, updateStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RjsStatus updateTracepointStates(TracepointStatesUpdate request) {
        Object object = this.stateUpdate;
        synchronized (object) {
            StateSet stateSet;
            ArrayList<String> reset;
            if (request.getReset()) {
                Map<String, PathEntry> map = this.pathMap;
                synchronized (map) {
                    reset = new ArrayList<String>(this.pathMap.keySet());
                }
            } else {
                reset = null;
            }
            boolean isAnyEnabled = reset != null ? false : this.isAnyEnabled;
            ArrayList<StateEntry> oldStateEntries = new ArrayList<StateEntry>();
            List<TracepointState> list = request.getStates();
            int i = 0;
            while (i < list.size()) {
                String path = list.get(i).getFilePath();
                if (path == null) {
                    ++i;
                    continue;
                }
                PathEntry pathEntry = this.ensurePathEntry(path);
                stateSet = pathEntry.states;
                synchronized (stateSet) {
                    if (reset != null && reset.remove(path) && !pathEntry.states.isEmpty()) {
                        oldStateEntries.addAll((Collection<StateEntry>)((Object)pathEntry.states));
                        pathEntry.states.clear();
                    }
                    while (i < list.size()) {
                        TracepointState state = list.get(i);
                        if (!path.equals(state.getFilePath())) break;
                        int idx = pathEntry.states.indexOfId(state.getId());
                        StateEntry entry = null;
                        if (idx >= 0) {
                            entry = (StateEntry)pathEntry.states.get(idx);
                        }
                        if (state.getType() != 0x1000000) {
                            int oldIdx;
                            if (entry == null && reset != null && (oldIdx = AbstractTracepointManager.indexOfStateEntry(oldStateEntries, state.getId())) >= 0) {
                                entry = (StateEntry)oldStateEntries.remove(oldIdx);
                            }
                            if (entry == null) {
                                entry = new StateEntry(path, state.getId());
                            }
                            entry.setState(state);
                            if (idx < 0) {
                                pathEntry.states.add(entry);
                            }
                            isAnyEnabled |= state.isEnabled();
                        } else if (idx >= 0) {
                            pathEntry.states.remove(idx);
                            oldStateEntries.add(entry);
                        }
                        ++i;
                    }
                }
                this.onRemoved(oldStateEntries);
                oldStateEntries.clear();
                this.isAnyEnabled = isAnyEnabled;
            }
            if (reset != null) {
                for (String path : reset) {
                    PathEntry entry = this.ensurePathEntry(path);
                    if (entry.states.isEmpty()) continue;
                    stateSet = entry.states;
                    synchronized (stateSet) {
                        this.onRemoved((List<StateEntry>)((Object)entry.states));
                        entry.states.clear();
                    }
                }
            }
            return RjsStatus.OK_STATUS;
        }
    }

    private void onRemoved(List<StateEntry> entries) {
        for (StateEntry entry : entries) {
            entry.removed();
        }
    }

    public void setBreakpointsEnabled(boolean enabled) {
        this.isBreakpointsEnabled = enabled;
    }

    public final boolean isBreakpointsEnabled() {
        return this.isBreakpointsEnabled;
    }

    public void registerEnv(String key, Handle envHandle, @Nullable List<String> objectNames) {
        key = key.intern();
        this.envTags.add((Object)key);
        RhEnv env = this.objManager.registerEnv(envHandle, key);
        this.updateInst(env, objectNames);
        this.finishUpdatingInst();
    }

    public void unregisterEnv(String key, Handle envHandle) {
        this.objManager.unregisterEnv(envHandle, key.intern());
    }

    public void unregisterEnvs(String key) {
        this.objManager.unregisterEnvs(key.intern());
    }

    protected void addEnvWithParents(List<RhEnv> envs, RhEnv env) throws RjsException {
        RhEnv env0 = env;
        while (env0 != null && !envs.contains(env0)) {
            envs.add(env0);
            env0 = this.objManager.getParentEnv(env0);
        }
    }

    public RjsStatus installTracepoints(ElementTracepointInstallationRequest request) throws RjsException {
        List<? extends ElementTracepoints> tracepointsList = request.getRequests();
        this.addTracepoints(tracepointsList);
        if (AbstractTracepointManager.containsCommonElement(tracepointsList)) {
            this.updateInst();
        }
        return RjsStatus.OK_STATUS;
    }

    public RjsStatus installTracepoints(FlagTracepointInstallationRequest request) throws RjsException {
        byte[] types = request.getTypes();
        int[] flags = request.getFlags();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 5: {
                    this.performUpdatingInstEB(flags[i]);
                    break;
                }
            }
            ++i;
        }
        return RjsStatus.OK_STATUS;
    }

    public void updateInst() throws RjsException {
        try {
            this.objManager.update();
            ArrayList<RhEnv> envs = new ArrayList<RhEnv>(64);
            envs.addAll((Collection<RhEnv>)this.objManager.getSearchPath());
            for (RhEnv env : this.objManager.getStackFrames()) {
                this.addEnvWithParents(envs, env);
            }
            for (RhEnv env : this.objManager.getEnvs()) {
                if (!env.isReg(ENV_INSTALLED_TAG) && !env.isRegAny((Collection<String>)this.envTags) || envs.contains(env)) continue;
                envs.add(env);
            }
            for (RhEnv env : envs) {
                this.performUpdatingInst(env, null);
            }
        }
        finally {
            this.finishUpdatingInst();
        }
    }

    public void updateInst(RhEnv env, @Nullable List<String> objectNames) {
        try {
            this.performUpdatingInst(env, objectNames);
        }
        finally {
            this.finishUpdatingInst();
        }
    }

    protected abstract void performUpdatingInstEB(int var1);

    protected abstract void performUpdatingInst(RhEnv var1, @Nullable List<String> var2);

    protected void notifyListeners(List<TracepointEvent> events) {
        if (!events.isEmpty()) {
            this.listener.handle(events);
        }
    }

    protected void notifyListeners(TracepointEvent event) {
        this.listener.handle((List<TracepointEvent>)ImCollections.newList((Object)event));
    }

    protected void beginUpdatingInstEnv(RhEnv env, @Nullable List<String> namesToUpdate) {
        this.updatingEnv = env;
        boolean bl = this.updatingEnvComplete = namesToUpdate == null;
        if (Tracepoints.LOGGER.isLoggable(Level.FINE)) {
            if (namesToUpdate != null) {
                Tracepoints.LOGGER.log(Level.FINE, "[TP] Updating element tracpoints in selected element(s) of {0}...\n\telementNames= {1}", new Object[]{env, namesToUpdate});
            } else {
                Tracepoints.LOGGER.log(Level.FINE, "[TP] Updating element tracpoints in all elements of {0}...", new Object[]{env});
            }
        }
    }

    protected final boolean getClearUpdatingInst() {
        return this.updatingEnvComplete;
    }

    protected void finishUpdatingInstEnv() {
        RhEnv env = this.updatingEnv;
        if (env != null) {
            try {
                try {
                    boolean clear = this.updatingEnvComplete;
                    StateSet prevInstalled = (StateSet)((Object)env.getData(ENV_INSTALLED_TAG));
                    StateSet installed = clear || prevInstalled == null ? new StateSet(0) : prevInstalled;
                    ImList<PathEntry> pathEntries = this.getPathEntries();
                    for (PathEntry entry : pathEntries) {
                        entry.finishUpdatingInst(env, clear, installed, this.updatingStates);
                    }
                    if (!installed.isEmpty()) {
                        if (installed != prevInstalled) {
                            env.addReg(ENV_INSTALLED_TAG, (Object)installed);
                        }
                    } else if (prevInstalled != null) {
                        env.removeReg(ENV_INSTALLED_TAG);
                    }
                }
                catch (Exception e) {
                    LogRecord record = new LogRecord(Level.SEVERE, "[TP] An error occured when updating tracepoint installation states for {0}.");
                    record.setParameters(new Object[]{env});
                    record.setThrown(e);
                    Tracepoints.LOGGER.log(record);
                    this.updatingEnv = null;
                }
            }
            finally {
                this.updatingEnv = null;
            }
        }
    }

    protected void finishUpdatingInst() {
        if (!this.updatingStates.isEmpty()) {
            ArrayList<TracepointEvent> events = new ArrayList<TracepointEvent>();
            Iterator iterator = this.updatingStates.iterator();
            while (iterator.hasNext()) {
                StateEntry entry = (StateEntry)iterator.next();
                entry.finishUpdatingInst(events);
            }
            this.notifyListeners(events);
            this.updatingStates.clear();
        }
    }

    protected void updateInstOnRemoved(RhEnv env) {
        StateSet installed = (StateSet)((Object)ObjectUtils.nonNullAssert((Object)((Object)((StateSet)((Object)env.getData(ENV_INSTALLED_TAG))))));
        ArrayList<TracepointEvent> events = new ArrayList<TracepointEvent>();
        Iterator iterator = installed.iterator();
        while (iterator.hasNext()) {
            StateEntry stateEntry = (StateEntry)iterator.next();
            stateEntry.removeInst(env, events);
        }
        this.notifyListeners(events);
    }

    protected static class ElementEntry {
        private final String id;
        private final List<ElementTracepoints> history = new ArrayList<ElementTracepoints>();
        private long updateStamp;

        public ElementEntry(String id) {
            this.id = id;
        }

        public final String getId() {
            return this.id;
        }

        protected void setTracepoints(ElementTracepoints tracepoints, long updateStamp) {
            this.updateStamp = updateStamp;
            if (this.history.isEmpty()) {
                this.history.add(tracepoints);
            } else if (this.history.get(0).getSrcfile().getTimestamp() == tracepoints.getSrcfile().getTimestamp()) {
                this.history.set(0, tracepoints);
            } else {
                if (this.history.size() >= 12) {
                    this.history.remove(this.history.size() - 1);
                }
                this.history.add(0, tracepoints);
            }
        }

        public long getUpdateStamp() {
            return this.updateStamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementTracepoints getCurrentTracepoints() {
            List<ElementTracepoints> list = this.history;
            synchronized (list) {
                return !this.history.isEmpty() ? this.history.get(0) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementTracepoints getTracepoints(long timestamp) {
            List<ElementTracepoints> list = this.history;
            synchronized (list) {
                if (!this.history.isEmpty() && timestamp != 0L) {
                    int i = 0;
                    while (i < this.history.size()) {
                        ElementTracepoints cand = this.history.get(i);
                        if (Srcfiles.equalsTimestamp(cand.getSrcfile().getTimestamp(), timestamp)) {
                            return cand;
                        }
                        ++i;
                    }
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementTracepoints findTracepoints(long timestamp, @Nullable StateSet states) {
            List<ElementTracepoints> list = this.history;
            synchronized (list) {
                if (!this.history.isEmpty()) {
                    ElementTracepoints current = this.history.get(0);
                    int end = this.history.size();
                    if (states != null && !current.getPositions().isEmpty() && AbstractTracepointManager.isAllDeleted(current.getPositions(), states)) {
                        return NO_POSITION_ELEMENT_TRACEPOINTS;
                    }
                    if (end > 1 && !current.getPositions().isEmpty()) {
                        ElementTracepoints best = null;
                        List<TracepointPosition> timestampPositions = null;
                        if (timestamp != 0L) {
                            ElementTracepoints cand;
                            int i = 0;
                            while (i < end) {
                                cand = this.history.get(i);
                                if (Srcfiles.equalsTimestamp(cand.getSrcfile().getTimestamp(), timestamp)) {
                                    if (Tracepoints.containsPositionsById(cand.getPositions(), current.getPositions())) {
                                        return cand;
                                    }
                                    best = cand;
                                    timestampPositions = Tracepoints.filterPositionsById(cand.getPositions(), current.getPositions());
                                    end = i;
                                    break;
                                }
                                ++i;
                            }
                            if (timestampPositions != null && !timestampPositions.isEmpty()) {
                                i = 0;
                                while (i < end) {
                                    cand = this.history.get(i);
                                    if (Tracepoints.equalsPositions(cand.getPositions(), (List<? extends TracepointPosition>)timestampPositions, (List<? extends TracepointPosition>)timestampPositions)) {
                                        return cand;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (best != null) {
                            return best;
                        }
                    }
                    return current;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementTracepointsCollection findCurrentTracepoints(long timestamp, int @Nullable [] srcref, @Nullable StateSet states) {
            List<ElementTracepoints> list = this.history;
            synchronized (list) {
                if (!this.history.isEmpty()) {
                    ElementTracepoints current = this.history.get(0);
                    int end = this.history.size();
                    if (states != null && !current.getPositions().isEmpty() && AbstractTracepointManager.isAllDeleted(current.getPositions(), states)) {
                        return new ElementTracepointsCollection(this.updateStamp, NO_POSITION_ELEMENT_TRACEPOINTS, NO_POSITION_ELEMENT_TRACEPOINTS, 0L);
                    }
                    if (end > 1 && !current.getPositions().isEmpty()) {
                        ElementTracepoints cand;
                        int i;
                        if (timestamp != 0L) {
                            List<TracepointPosition> timestampActualPositions = null;
                            i = 0;
                            while (i < end) {
                                cand = this.history.get(i);
                                if (Srcfiles.equalsTimestamp(cand.getSrcfile().getTimestamp(), timestamp)) {
                                    if (Tracepoints.containsPositionsById(cand.getPositions(), current.getPositions())) {
                                        return new ElementTracepointsCollection(this.updateStamp, current, cand, timestamp);
                                    }
                                    timestampActualPositions = Tracepoints.filterPositionsById(cand.getPositions(), current.getPositions());
                                    end = i;
                                    break;
                                }
                                ++i;
                            }
                            if (timestampActualPositions != null && !timestampActualPositions.isEmpty()) {
                                i = 0;
                                while (i < end) {
                                    cand = this.history.get(i);
                                    if (Tracepoints.containsPositionsById(cand.getPositions(), current.getPositions()) && Tracepoints.equalsPositions(cand.getPositions(), timestampActualPositions, timestampActualPositions)) {
                                        return new ElementTracepointsCollection(this.updateStamp, current, cand, timestamp);
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (srcref != null) {
                            ArrayList<ElementTracepoints> selected = new ArrayList<ElementTracepoints>(8);
                            selected.add(current);
                            i = 1;
                            while (i < end && selected.size() < 8) {
                                cand = this.history.get(i);
                                if (cand.getElementSrcref() != null && Srcref.equalsDim(cand.getElementSrcref(), srcref) && Tracepoints.containsPositionsById(cand.getPositions(), current.getPositions()) && !Tracepoints.equalsPositions(cand.getPositions(), ((ElementTracepoints)selected.get(selected.size() - 1)).getPositions(), current.getPositions())) {
                                    selected.add(cand);
                                }
                                ++i;
                            }
                            return new ElementTracepointsCollection(this.updateStamp, current, selected, timestamp);
                        }
                    }
                    return new ElementTracepointsCollection(this.updateStamp, current, current, timestamp);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementTracepointsCollection findCurrentNestedTracepoints(long timestamp, int[] srcref, @Nullable StateSet states) {
            List<ElementTracepoints> list = this.history;
            synchronized (list) {
                if (!this.history.isEmpty()) {
                    ElementTracepoints current = this.history.get(0);
                    int end = this.history.size();
                    if (current.getPositions().isEmpty() || states != null && AbstractTracepointManager.isAllDeleted(current.getPositions(), states)) {
                        return this.createNoPositionCollection();
                    }
                    if (timestamp != 0L) {
                        ElementTracepoints cand;
                        int[] timestampSrcref = null;
                        List<TracepointPosition> timestampPositions = null;
                        int i = 0;
                        while (i < end) {
                            cand = this.history.get(i);
                            if (Srcfiles.equalsTimestamp(cand.getSrcfile().getTimestamp(), timestamp)) {
                                if (cand.getElementSrcref() == null) break;
                                int[] index = Tracepoints.findIndexBySrcref(cand.getPositions(), (int[])ObjectUtils.nonNullAssert((Object)cand.getElementSrcref()), srcref);
                                if (index != null) {
                                    timestampSrcref = (int[])ObjectUtils.nonNullAssert((Object)Tracepoints.getSrcrefForIndex(cand.getPositions(), index));
                                    timestampPositions = Tracepoints.rebasePositionsByIndex(cand.getPositions(), index);
                                    if (Tracepoints.containsPositionsById(cand.getPositions(), current.getPositions())) {
                                        return this.createNestedCollection(current, this.createNested(cand, timestampSrcref, Tracepoints.filterPositionsById(timestampPositions, current.getPositions())), timestamp, states);
                                    }
                                }
                                end = i;
                                break;
                            }
                            ++i;
                        }
                        if (timestampPositions != null && !timestampPositions.isEmpty()) {
                            i = 0;
                            while (i < end) {
                                List<TracepointPosition> compareList;
                                int[] index;
                                cand = this.history.get(i);
                                if (Tracepoints.containsPositionsById(cand.getPositions(), current.getPositions()) && (index = Tracepoints.findIndexByReference(compareList = Tracepoints.filterPositionsById(cand.getPositions(), (List<? extends TracepointPosition>)timestampPositions), (List<? extends TracepointPosition>)timestampPositions)) != null) {
                                    int[] candSrcref = (int[])ObjectUtils.nonNullAssert((Object)Tracepoints.getSrcrefForIndex(compareList, index));
                                    List<TracepointPosition> candPositions = Tracepoints.rebasePositionsByIndex(cand.getPositions(), index);
                                    if (Tracepoints.equalsPositions(candPositions, timestampPositions, timestampPositions)) {
                                        return this.createNestedCollection(current, this.createNested(cand, candSrcref, Tracepoints.filterPositionsById(candPositions, current.getPositions())), timestamp, states);
                                    }
                                }
                                ++i;
                            }
                            List<TracepointPosition> positions = Tracepoints.filterPositionsById((List<? extends TracepointPosition>)timestampPositions, current.getPositions());
                            if (positions.isEmpty() || states != null && AbstractTracepointManager.isAllDeleted(positions, states)) {
                                return this.createNoPositionCollection();
                            }
                        }
                        return this.createNoChangeCollection();
                    }
                }
                return null;
            }
        }

        private ElementTracepointsCollection createNoPositionCollection() {
            return new ElementTracepointsCollection(this.updateStamp, NO_POSITION_ELEMENT_TRACEPOINTS, NO_POSITION_ELEMENT_TRACEPOINTS, 0L);
        }

        private ElementTracepointsCollection createNoChangeCollection() {
            return new ElementTracepointsCollection(this.updateStamp, NO_CHANGE_ELEMENT_TRACEPOINTS, NO_CHANGE_ELEMENT_TRACEPOINTS, 0L);
        }

        private ElementTracepoints createNested(ElementTracepoints cand, int[] srcref, List<TracepointPosition> nestedPositions) {
            return new ElementTracepoints(cand.getSrcfile(), this.id, srcref, nestedPositions);
        }

        private ElementTracepointsCollection createNestedCollection(ElementTracepoints current, ElementTracepoints nested, long requestedTimestamp, @Nullable StateSet states) {
            List<TracepointPosition> currentPositions = Tracepoints.filterPositionsById(current.getPositions(), nested.getPositions());
            if (currentPositions.isEmpty() || states != null && AbstractTracepointManager.isAllDeleted(currentPositions, states)) {
                return this.createNoPositionCollection();
            }
            return new ElementTracepointsCollection(this.updateStamp, new ElementTracepoints(current.getSrcfile(), this.id, null, currentPositions), nested, requestedTimestamp);
        }
    }

    protected static final class ElementTracepointsCollection {
        private final long updatingStamp;
        private final ElementTracepoints current;
        private final List<ElementTracepoints> list;
        private final long requestedTimestamp;

        public ElementTracepointsCollection(long updatingStamp, ElementTracepoints current, List<ElementTracepoints> list, long requestedTimestamp) {
            this.updatingStamp = updatingStamp;
            this.current = current;
            this.list = list;
            this.requestedTimestamp = requestedTimestamp;
        }

        public ElementTracepointsCollection(long updatingStamp, ElementTracepoints current, ElementTracepoints single, long requestedTimestamp) {
            this.updatingStamp = updatingStamp;
            this.current = current;
            this.list = ImCollections.newList((Object)single);
            this.requestedTimestamp = requestedTimestamp;
        }

        public long getUpdatingStamp() {
            return this.updatingStamp;
        }

        public ElementTracepoints getCurrent() {
            return this.current;
        }

        public List<ElementTracepoints> getList() {
            return this.list;
        }

        public boolean isActualPositionsEmpty() {
            return this.current.getPositions().isEmpty();
        }

        public List<? extends TracepointPosition> getActualPositions(List<? extends TracepointPosition> positions) {
            return Tracepoints.filterPositionsByIdRequired(positions, this.current.getPositions());
        }

        public long getRequestedTimestamp() {
            return this.requestedTimestamp;
        }
    }

    protected static class PathEntry {
        private final String path;
        private long updateStamp;
        private @Nullable SrcfileData srcfile;
        private final List<ElementEntry> elementEntries = new ArrayList<ElementEntry>();
        private final StateSet states = new StateSet(8);
        private final List<ElementTracepointsCollection> updatingInstalled = new ArrayList<ElementTracepointsCollection>();

        public PathEntry(String path) {
            this.path = path;
        }

        public final String getPath() {
            return this.path;
        }

        public final long getUpdateStamp() {
            return this.updateStamp;
        }

        private int indexOf(String id) {
            int low = 0;
            int high = this.elementEntries.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int diff = this.elementEntries.get((int)mid).id.compareTo(id);
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~low;
        }

        private ElementEntry ensureElement(String id) {
            int idx = this.indexOf(id);
            if (idx >= 0) {
                return this.elementEntries.get(idx);
            }
            ElementEntry entry = new ElementEntry(id);
            this.elementEntries.add(~idx, entry);
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTracepoints(ElementTracepoints tracepoints, long updateStamp) {
            List<ElementEntry> list = this.elementEntries;
            synchronized (list) {
                this.updateStamp = updateStamp;
                this.srcfile = tracepoints.getSrcfile();
                ElementEntry elementEntry = this.ensureElement(tracepoints.getElementId().startsWith(AbstractTracepointManager.TOPLEVEL_ELEMENT_ID) ? AbstractTracepointManager.TOPLEVEL_ELEMENT_ID : tracepoints.getElementId());
                elementEntry.setTracepoints(tracepoints, updateStamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementEntry getElementEntry(String id) {
            List<ElementEntry> list = this.elementEntries;
            synchronized (list) {
                int idx = this.indexOf(id);
                return idx >= 0 ? this.elementEntries.get(idx) : null;
            }
        }

        public @Nullable ElementTracepoints findElementTracepoints(@Nullable String id, long timestamp) {
            if (id == null) {
                return null;
            }
            ElementEntry elementEntry = this.getElementEntry(id);
            return elementEntry != null ? elementEntry.findTracepoints(timestamp, this.states) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ElementTracepointsCollection findCurrentElementTracepoints(@Nullable String id, long timestamp, int @Nullable [] srcref) {
            if (id == null && srcref == null) {
                return null;
            }
            ElementEntry elementEntry = null;
            boolean isNestedMatch = false;
            if (id != null) {
                elementEntry = this.getElementEntry(id);
            } else {
                if (timestamp != 0L) {
                    List<ElementEntry> list = this.elementEntries;
                    synchronized (list) {
                        for (ElementEntry entry : this.elementEntries) {
                            ElementTracepoints cand;
                            if (entry.getId() == AbstractTracepointManager.TOPLEVEL_ELEMENT_ID || (cand = entry.getTracepoints(timestamp)) == null || cand.getElementSrcref() == null || !Srcref.contains(cand.getElementSrcref(), srcref)) continue;
                            if (Srcref.equalsStart(cand.getElementSrcref(), srcref)) {
                                elementEntry = entry;
                                isNestedMatch = false;
                                break;
                            }
                            elementEntry = entry;
                            isNestedMatch = true;
                        }
                    }
                }
                List<ElementEntry> list = this.elementEntries;
                synchronized (list) {
                    ElementTracepoints best = null;
                    boolean requireDim = false;
                    for (ElementEntry entry : this.elementEntries) {
                        ElementTracepoints cand;
                        if (entry.getId() == AbstractTracepointManager.TOPLEVEL_ELEMENT_ID || (cand = entry.getCurrentTracepoints()) == null || cand.getElementSrcref() == null || !Srcref.equalsStart(cand.getElementSrcref(), srcref) || AbstractTracepointManager.isAllDeleted(cand.getPositions(), this.states)) continue;
                        if (Srcref.equalsDim(cand.getElementSrcref(), srcref)) {
                            if (!requireDim) {
                                requireDim = true;
                                best = null;
                            }
                        } else if (requireDim) continue;
                        if (best != null && entry.getUpdateStamp() <= elementEntry.getUpdateStamp()) continue;
                        elementEntry = entry;
                        best = cand;
                    }
                    if (requireDim && best != null) {
                        return new ElementTracepointsCollection(elementEntry.getUpdateStamp(), best, best, timestamp);
                    }
                }
            }
            return elementEntry != null ? (isNestedMatch ? elementEntry.findCurrentNestedTracepoints(timestamp, srcref, this.states) : elementEntry.findCurrentTracepoints(timestamp, srcref, this.states)) : null;
        }

        public StateSet getStates() {
            return this.states;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable StateEntry getBreakpointState(long id) {
            StateSet stateSet = this.states;
            synchronized (stateSet) {
                return AbstractTracepointManager.getBreakpointState(this.states, id);
            }
        }

        public void addInstalled(ElementTracepointsCollection collection) {
            this.updatingInstalled.add(collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishUpdatingInst(RhEnv env, boolean clear, StateSet installed, StateSet changed) {
            StateSet stateSet = this.states;
            synchronized (stateSet) {
                int i = 0;
                while (i < this.states.size()) {
                    StateEntry stateEntry = (StateEntry)this.states.get(i);
                    int isInstalled = 0;
                    boolean isUpdated = false;
                    int j = 0;
                    while (j < this.updatingInstalled.size()) {
                        ElementTracepointsCollection collection = this.updatingInstalled.get(j);
                        if (Tracepoints.indexOfTracepointById(collection.getCurrent().getPositions(), stateEntry.getId()) >= 0) {
                            ++isInstalled;
                            isUpdated |= stateEntry.addUpdatingInstElement(collection);
                        }
                        ++j;
                    }
                    if (isInstalled > 0) {
                        if (!stateEntry.instEnvs.contains(env) && stateEntry.instEnvs.add(env)) {
                            changed.add(stateEntry);
                            if (Tracepoints.LOGGER.isLoggable(Level.FINE)) {
                                Tracepoints.LOGGER.log(Level.FINE, "[TP] Updating element tracepoint {0}: installed in {2} element(s) of {1} now.", new Object[]{stateEntry, env, clear ? Integer.valueOf(isInstalled) : "one or more"});
                            }
                        } else if (isUpdated) {
                            changed.add(stateEntry);
                        }
                        installed.add(stateEntry);
                    } else if (clear && stateEntry.instEnvs.remove(env)) {
                        if (stateEntry.instEnvs.isEmpty()) {
                            changed.add(stateEntry);
                        }
                        if (Tracepoints.LOGGER.isLoggable(Level.FINE)) {
                            Tracepoints.LOGGER.log(Level.FINE, "[TP] Updating element tracepoint {0}: installed in NO element of {1} now.", new Object[]{stateEntry, env});
                        }
                    }
                    ++i;
                }
            }
            this.updatingInstalled.clear();
        }
    }

    protected class StateEntry
    implements Comparable<StateEntry> {
        private final String path;
        private final long id;
        private final List<RhEnv> instEnvs = new ArrayList<RhEnv>();
        private @Nullable ElementTracepoints instElement;
        private long instUpdatingStamp;
        private @Nullable ElementTracepointsCollection updatingInstElement;
        private @Nullable TracepointState state;
        private @Nullable ParsedExpr parsedExpr;

        public StateEntry(String path, long id) {
            this.path = path;
            this.id = id;
        }

        public final long getId() {
            return this.id;
        }

        public final boolean isInstalled() {
            return !this.instEnvs.isEmpty();
        }

        public synchronized void setState(TracepointState state) {
            this.state = state;
        }

        public final synchronized @Nullable TracepointState getState() {
            return this.state;
        }

        public synchronized ParsedExpr getParsedExpr(String source) {
            ParsedExpr pe = this.parsedExpr;
            if (pe != null) {
                if (pe.getSource().equals(source)) {
                    return pe;
                }
                AbstractTracepointManager.this.objManager.addToDispose(pe);
                this.parsedExpr = null;
            }
            pe = new ParsedExpr(source);
            if (this.state != null) {
                this.parsedExpr = pe;
            }
            return pe;
        }

        public synchronized void removed() {
            this.state = null;
            if (this.parsedExpr != null) {
                AbstractTracepointManager.this.objManager.addToDispose(this.parsedExpr);
                this.parsedExpr = null;
            }
        }

        private @Nullable TracepointEvent checkInstalled(@Nullable ElementTracepoints prevElement) {
            ElementTracepoints element = this.instElement;
            if (!(element == null || element == prevElement || prevElement != null && element.getElementId().equals(prevElement.getElementId()))) {
                return new TracepointEvent(16, 0, element.getSrcfile().getPath(), this.id, element.getElementId(), null, 0);
            }
            return null;
        }

        private @Nullable TracepointEvent checkUninstalled() {
            ElementTracepoints element = this.instElement;
            if (element != null) {
                this.instElement = null;
                return new TracepointEvent(32, 0, element.getSrcfile().getPath(), this.id, element.getElementId(), null, 0);
            }
            return null;
        }

        private boolean addUpdatingInstElement(ElementTracepointsCollection collection) {
            if (this.updatingInstElement == null || collection.getUpdatingStamp() > this.updatingInstElement.getUpdatingStamp()) {
                this.updatingInstElement = collection;
                return true;
            }
            return false;
        }

        private void finishUpdatingInst(List<TracepointEvent> events) {
            TracepointEvent event = null;
            if (this.isInstalled()) {
                ElementTracepoints prevElement = this.instElement;
                if (this.updatingInstElement != null && (AbstractTracepointManager.this.getClearUpdatingInst() || this.instElement == null || this.updatingInstElement.getUpdatingStamp() > this.instUpdatingStamp)) {
                    this.instElement = this.updatingInstElement.getCurrent();
                    this.instUpdatingStamp = this.updatingInstElement.getUpdatingStamp();
                    event = this.checkInstalled(prevElement);
                }
            } else {
                event = this.checkUninstalled();
            }
            if (event != null) {
                events.add(event);
            }
            this.updatingInstElement = null;
        }

        private void removeInst(RhEnv env, List<TracepointEvent> events) {
            TracepointEvent event = null;
            if (this.isInstalled() && this.instEnvs.remove(env) && this.instEnvs.isEmpty()) {
                event = this.checkUninstalled();
            }
            if (event != null) {
                events.add(event);
            }
        }

        @Override
        public int compareTo(StateEntry other) {
            return this.id < other.id ? -1 : (this.id != other.id ? 1 : this.path.compareTo(other.path));
        }

        private int compareToId(long otherId) {
            return this.id < otherId ? -1 : (this.id != otherId ? 1 : 0);
        }

        public final int hashCode() {
            return Long.hashCode(this.id);
        }

        public final boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof StateEntry && this.id == ((StateEntry)obj).id && this.path.equals(((StateEntry)obj).path);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(22 + this.path.length());
            Tracepoints.append(this.id, sb);
            sb.append(" in '");
            sb.append(this.path);
            sb.append('\'');
            return sb.toString();
        }
    }

    protected static final class StateSet
    extends SortedArraySet<StateEntry> {
        public StateSet(int initialSize) {
            super((Object[])new StateEntry[initialSize], 0, null);
        }

        protected static final int binarySearchId(StateEntry[] a, int begin, int end, long id) {
            --end;
            while (begin <= end) {
                int i = begin + end >>> 1;
                int d = a[i].compareToId(id);
                if (d < 0) {
                    begin = i + 1;
                    continue;
                }
                if (d > 0) {
                    end = i - 1;
                    continue;
                }
                return i;
            }
            return ~begin;
        }

        public int indexOfId(long id) {
            return StateSet.binarySearchId((StateEntry[])this.array(), 0, this.size(), id);
        }
    }
}

