/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.settings.DecorationPreferences;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

@NonNullByDefault
public abstract class SourceEditorViewerConfigurator
implements ISettingsChangedHandler,
PropertyChangeListener {
    private final SourceEditorViewerConfiguration configuration;
    private @Nullable SourceEditor sourceEditor;
    private final List<SourceEditorAddon> addons = new ArrayList<SourceEditorAddon>();
    private @Nullable List<SourceEditorAddon> configurationAddons;
    protected boolean isConfigured;
    protected boolean updateCompleteConfig;
    protected boolean updateTextPresentation;
    protected boolean updateTabWidth;
    protected boolean updateIndent;
    protected boolean updateInfoHovers;

    protected SourceEditorViewerConfigurator(SourceEditorViewerConfiguration config) {
        this.configuration = (SourceEditorViewerConfiguration)((Object)ObjectUtils.nonNullAssert((Object)((Object)config)));
    }

    public abstract IDocumentSetupParticipant getDocumentSetupParticipant();

    public final DocContentSections getDocumentContentInfo() {
        return this.configuration.getDocumentContentInfo();
    }

    protected abstract Set<String> getResetGroupIds();

    public SourceEditorViewerConfiguration getSourceViewerConfiguration() {
        return this.configuration;
    }

    public void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        CharPairMatcher pairMatcher = this.configuration.getPairMatcher();
        DecorationPreferences preferences = this.configuration.getDecorationPreferences();
        if (pairMatcher != null && preferences != null) {
            support.setCharacterPairMatcher((ICharacterPairMatcher)pairMatcher);
            support.setMatchingCharacterPainterPreferenceKeys(preferences.getMatchingBracketsEnabled().getKey(), preferences.getMatchingBracketsColor().getKey());
        }
    }

    public void setTarget(SourceEditor sourceEditor) {
        this.sourceEditor = (SourceEditor)ObjectUtils.nonNullAssert((Object)sourceEditor);
        if (!(sourceEditor instanceof AbstractDecoratedTextEditor)) {
            sourceEditor.getViewer().getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (SourceEditorViewerConfigurator.this.isConfigured) {
                        SourceEditorViewerConfigurator.this.uninstallCurrentAddons();
                    }
                }
            });
            this.configureTarget();
        } else {
            this.isConfigured = true;
            this.installCurrentAddons(sourceEditor);
        }
        this.handleSettingsChanged(null, null);
    }

    protected @Nullable ISourceViewer getSourceViewer() {
        SourceEditor sourceEditor = this.sourceEditor;
        if (sourceEditor != null) {
            return sourceEditor.getViewer();
        }
        return null;
    }

    public final void unconfigureTarget() {
        SourceEditor sourceEditor = this.sourceEditor;
        if (sourceEditor != null) {
            this.isConfigured = false;
            this.uninstallCurrentAddons();
            sourceEditor.getViewer().unconfigure();
        }
    }

    public final void configureTarget() {
        SourceEditor sourceEditor = this.sourceEditor;
        if (sourceEditor != null) {
            this.isConfigured = true;
            sourceEditor.getViewer().configure((SourceViewerConfiguration)this.configuration);
            this.installCurrentAddons(sourceEditor);
        }
    }

    private void installCurrentAddons(SourceEditor sourceEditor) {
        List<SourceEditorAddon> configurationAddons = this.getSourceViewerConfiguration().getAddOns();
        this.configurationAddons = configurationAddons;
        for (SourceEditorAddon addon : configurationAddons) {
            addon.install(sourceEditor);
        }
        for (SourceEditorAddon addon : this.addons) {
            addon.install(sourceEditor);
        }
    }

    private void uninstallCurrentAddons() {
        for (SourceEditorAddon addon : this.addons) {
            addon.uninstall();
        }
        List<SourceEditorAddon> configurationAddons = this.configurationAddons;
        if (configurationAddons != null) {
            this.configurationAddons = null;
            for (SourceEditorAddon addon : configurationAddons) {
                addon.uninstall();
            }
        }
    }

    public final void installAddon(SourceEditorAddon installable) {
        this.addons.add(installable);
        if (this.isConfigured) {
            SourceEditor sourceEditor = (SourceEditor)ObjectUtils.nonNullAssert((Object)this.sourceEditor);
            installable.install(sourceEditor);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if (name.equals("tabWidth")) {
            this.updateTabWidth = true;
            this.updateIndent = true;
            return;
        }
        if (name.equals("indentSpacesCount") || name.equals("indentDefaultType")) {
            this.updateIndent = true;
            return;
        }
    }

    public void handleSettingsChanged(@Nullable Set<String> groupIds, @Nullable Map<String, Object> options) {
        SourceViewer viewer;
        SourceEditor sourceEditor = this.sourceEditor;
        if (sourceEditor == null || (viewer = sourceEditor.getViewer()) == null) {
            return;
        }
        Point selectedRange = viewer.getSelectedRange();
        if (groupIds == null) {
            groupIds = this.getResetGroupIds();
        }
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        options.put("context.Viewer", viewer);
        this.checkSettingsChanges(groupIds, options);
        if (options.containsKey("affects.Presentation")) {
            this.updateTextPresentation = true;
        }
        this.updateSourceViewer((ISourceViewer)viewer);
        viewer.setSelectedRange(selectedRange.x, selectedRange.y);
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        this.configuration.handleSettingsChanged(groupIds, options);
    }

    protected void updateSourceViewer(ISourceViewer viewer) {
        if (!this.isConfigured) {
            return;
        }
        SourceEditor sourceEditor = (SourceEditor)ObjectUtils.nonNullAssert((Object)this.sourceEditor);
        if (this.updateCompleteConfig) {
            SpellingProblem.removeAll((ISourceViewer)sourceEditor.getViewer(), null);
            this.reconfigureSourceViewer(sourceEditor.getViewer());
        } else {
            if (this.updateTabWidth) {
                viewer.getTextWidget().setTabs(this.getSourceViewerConfiguration().getTabWidth(viewer));
            }
            if (this.updateTextPresentation) {
                viewer.invalidateTextPresentation();
            }
            if (this.updateIndent && sourceEditor instanceof SourceEditor1) {
                ((SourceEditor1)sourceEditor).updateIndentSettings();
            }
            if (this.updateInfoHovers) {
                this.updateConfiguredInfoHovers(sourceEditor.getViewer());
            }
        }
        this.updateCompleteConfig = false;
        this.updateTextPresentation = false;
        this.updateTabWidth = false;
        this.updateIndent = false;
    }

    private final void reconfigureSourceViewer(SourceViewer viewer) {
        this.isConfigured = false;
        viewer.unconfigure();
        this.isConfigured = true;
        viewer.configure((SourceViewerConfiguration)this.configuration);
    }

    private void updateConfiguredInfoHovers(SourceViewer viewer) {
        String[] contentTypes;
        String[] stringArray = contentTypes = this.configuration.getConfiguredContentTypes((ISourceViewer)viewer);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            viewer.removeTextHovers(contentType);
            int[] stateMasks = this.configuration.getConfiguredTextHoverStateMasks((ISourceViewer)viewer, contentType);
            if (stateMasks != null) {
                int j = 0;
                while (j < stateMasks.length) {
                    int stateMask = stateMasks[j];
                    ITextHover textHover = this.configuration.getTextHover((ISourceViewer)viewer, contentType, stateMask);
                    if (textHover != null) {
                        viewer.setTextHover(textHover, contentType, stateMask);
                    }
                    ++j;
                }
            } else {
                ITextHover textHover = this.configuration.getTextHover((ISourceViewer)viewer, contentType);
                if (textHover != null) {
                    viewer.setTextHover(textHover, contentType, 255);
                }
            }
            ++n2;
        }
    }
}

