/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.text.core;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.TextTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class HeuristicTokenScanner
implements TextTokenScanner {
    protected static final PartitionConstraint ANY_PARTITIONS_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return true;
        }
    };
    protected static final CharPairSet COMMON_BRACKETS = new CharPairSet(ImCollections.newIdentityList((Object[])new CharPair[]{Chars.CURLY_BRACKETS, Chars.SQUARE_BRACKETS, Chars.ROUND_BRACKETS}));
    protected static final StopCondition COMMON_WORD_CONDITION = new StopCondition(){

        @Override
        public boolean matches(char c) {
            return !Character.isLetterOrDigit(c);
        }
    };
    private final String partitioning;
    private final PartitionConstraint defaultPartitionConstraint;
    private IDocument document;
    private PartitionConstraint partitionConstraint;
    private int offset;
    protected char ch;
    private @Nullable ITypedRegion currentPartition;
    private boolean currentPartitionMatched;
    private int currentPartitionStart;
    private int currentPartitionEnd;
    private final StopCondition nonSSpaceCondition;
    private final StopCondition nonMSpaceCondition;

    public HeuristicTokenScanner(DocContentSections documentContentInfo, PartitionConstraint defaultContentConstraint) {
        this.partitioning = documentContentInfo.getPartitioning();
        this.defaultPartitionConstraint = defaultContentConstraint;
        this.nonSSpaceCondition = this.createSSpaceCondition();
        this.nonMSpaceCondition = this.createMSpaceCondition();
    }

    public CharPairSet getDefaultBrackets() {
        return COMMON_BRACKETS;
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final String getDocumentPartitioning() {
        return this.partitioning;
    }

    public final PartitionConstraint getDefaultPartitionConstraint() {
        return this.defaultPartitionConstraint;
    }

    protected final PartitionConstraint getPartitionConstraint() {
        return this.partitionConstraint;
    }

    private void resetPartition() {
        this.currentPartitionMatched = false;
    }

    private boolean updatePartition(int offset) throws BadLocationException {
        ITypedRegion partition;
        this.currentPartition = partition = TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)offset, (boolean)false);
        this.currentPartitionStart = partition.getOffset();
        int length = partition.getLength();
        this.currentPartitionEnd = this.currentPartitionStart + length;
        this.currentPartitionMatched = length > 0 && this.partitionConstraint.matches(partition.getType());
        return this.currentPartitionMatched;
    }

    private boolean isValidPartitionOffset(int offset) throws BadLocationException {
        return this.currentPartitionMatched && offset >= this.currentPartitionStart && offset < this.currentPartitionEnd || this.updatePartition(offset);
    }

    public int nextPartitionOffsetForward(int offset) throws BadLocationException {
        return this.isValidPartitionOffset(offset) || offset >= this.currentPartitionEnd ? offset + 1 : this.currentPartitionEnd;
    }

    public int nextPartitionOffsetBackward(int offset) throws BadLocationException {
        return this.isValidPartitionOffset(offset) ? offset - 1 : this.currentPartitionStart - 1;
    }

    public final char getChar() {
        return this.ch;
    }

    protected StopCondition createSSpaceCondition() {
        return new StopCondition(){

            @Override
            public boolean matches(char c) throws BadLocationException {
                boolean bl;
                if (c < '\u1680') {
                    switch (c) {
                        case '\t': 
                        case ' ': 
                        case '\u00a0': {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = Character.getType(c) != 12;
                }
                return bl;
            }
        };
    }

    protected StopCondition createMSpaceCondition() {
        return new StopCondition(){

            @Override
            public boolean matches(char c) throws BadLocationException {
                boolean bl;
                if (c < '\u1680') {
                    switch (c) {
                        case '\t': 
                        case ' ': 
                        case '\u00a0': {
                            bl = false;
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = Character.getType(c) != 12;
                }
                return bl;
            }
        };
    }

    public void configure(IDocument document, final String partitionType) {
        assert (document != null && partitionType != null);
        this.document = document;
        this.partitionConstraint = new PartitionConstraint(){

            public boolean matches(String partitionTypeToTest) {
                return partitionType == partitionTypeToTest;
            }
        };
    }

    public void configure(IDocument document) {
        assert (document != null);
        this.document = document;
        this.partitionConstraint = ANY_PARTITIONS_CONSTRAINT;
    }

    public void configureDefaultPartitions(IDocument document) {
        assert (document != null);
        this.document = document;
        this.partitionConstraint = this.getDefaultPartitionConstraint();
    }

    public void configure(IDocument document, PartitionConstraint partitionConstraint) {
        assert (document != null && partitionConstraint != null);
        this.document = document;
        this.partitionConstraint = partitionConstraint;
    }

    protected int createForwardBound(int start) throws BadLocationException {
        return this.document.getLength();
    }

    protected int createBackwardBound(int start) throws BadLocationException {
        return 0;
    }

    protected final int checkForwardBound(int start, int bound) throws BadLocationException {
        if (bound == -2) {
            bound = this.createForwardBound(start);
        }
        assert (bound >= start && bound <= this.document.getLength());
        return bound;
    }

    protected final int checkBackwardBound(int start, int bound) throws BadLocationException {
        if (bound == -2) {
            bound = this.createBackwardBound(start);
        }
        assert (bound <= start && bound >= 0);
        return bound - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int scanAnyForward(int start, int bound, StopCondition condition, char escapeChar) throws BadLocationException {
        int offset = start;
        while (offset < bound) {
            this.offset = offset;
            this.ch = this.document.getChar(offset);
            if (condition.matches(this.ch)) {
                if (escapeChar == '\u0000') return this.offset;
                while (--offset >= start && this.document.getChar(offset) == escapeChar) {
                }
                if ((this.offset - offset) % 2 != 0) return this.offset;
                offset = this.offset;
            }
            ++offset;
        }
        this.offset = bound;
        this.ch = (char)(this.offset >= 0 && this.offset < this.document.getLength() ? (int)this.document.getChar(this.offset) : 65535);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int scanForward(int start, int bound, StopCondition condition, char escapeChar) throws BadLocationException {
        if (bound == -2) {
            bound = this.document.getLength();
        }
        assert (start >= 0);
        this.resetPartition();
        int offset = start;
        while (offset < bound) {
            if (this.isValidPartitionOffset(offset)) {
                this.offset = offset;
                this.ch = this.document.getChar(offset);
                if (condition.matches(this.ch)) {
                    if (escapeChar == '\u0000') return this.offset;
                    while (--offset >= start && this.document.getChar(offset) == escapeChar) {
                    }
                    if ((this.offset - offset) % 2 != 0) return this.offset;
                    offset = this.offset;
                }
            }
            offset = this.nextPartitionOffsetForward(offset);
        }
        this.offset = bound;
        this.ch = (char)(this.offset >= 0 && this.offset < this.document.getLength() ? (int)this.document.getChar(this.offset) : 65535);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int scanAnyBackward(int start, int bound, StopCondition condition, char escapeChar) throws BadLocationException {
        int offset = start;
        while (offset > bound) {
            this.offset = offset;
            this.ch = this.document.getChar(offset);
            if (condition.matches(this.ch)) {
                if (escapeChar == '\u0000') return this.offset;
                while (--offset > bound && this.document.getChar(offset) == escapeChar) {
                }
                if ((this.offset - offset) % 2 != 0) return this.offset;
                offset = this.offset;
            }
            --offset;
        }
        this.offset = bound;
        this.ch = (char)(this.offset >= 0 && this.offset < this.document.getLength() ? (int)this.document.getChar(this.offset) : 65535);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int scanBackward(int start, int bound, StopCondition condition, char escapeChar) throws BadLocationException {
        if (bound == -2) {
            bound = -1;
        }
        this.resetPartition();
        int offset = start;
        while (offset > bound) {
            if (this.isValidPartitionOffset(offset)) {
                this.offset = offset;
                this.ch = this.document.getChar(offset);
                if (condition.matches(this.ch)) {
                    if (escapeChar == '\u0000') return this.offset;
                    while (--offset > bound && this.document.getChar(offset) == escapeChar) {
                    }
                    if ((this.offset - offset) % 2 != 0) return this.offset;
                    offset = this.offset;
                }
            }
            offset = this.nextPartitionOffsetBackward(offset);
        }
        this.offset = bound;
        this.ch = (char)(this.offset >= 0 && this.offset < this.document.getLength() ? (int)this.document.getChar(this.offset) : 65535);
        return -1;
    }

    protected final @Nullable IRegion findAnyRegion(int offset, StopCondition condition, boolean allowClosing) throws BadLocationException {
        int start = offset;
        int end = this.scanAnyForward(offset, this.createForwardBound(start), condition, '\u0000');
        if (end == -1) {
            end = this.offset;
        }
        if (allowClosing || end > offset) {
            --start;
            if ((start = this.scanAnyBackward(start, this.createBackwardBound(start) - 1, condition, '\u0000')) == -1) {
                start = this.offset;
            }
            ++start;
        }
        if (start < end) {
            return new Region(start, end - start);
        }
        return null;
    }

    protected final @Nullable IRegion findRegion(int offset, StopCondition condition, boolean allowClosing) throws BadLocationException {
        int start = offset;
        int end = this.scanForward(offset, -2, condition, '\u0000');
        if (end == -1) {
            end = this.offset;
        }
        if (allowClosing || end > offset) {
            --start;
            if ((start = this.scanBackward(start, -2, condition, '\u0000')) == -1) {
                start = this.offset;
            }
            ++start;
        }
        if (start < end) {
            return new Region(start, end - start);
        }
        return null;
    }

    public final int scanForward(int offset, int bound, char ch) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, new SingleCharacterMatchCondition(ch), '\u0000');
    }

    public final int scanBackward(int offset, int bound, char ch) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset, bound, new SingleCharacterMatchCondition(ch), '\u0000');
    }

    public final int scanForward(int offset, int bound, char[] chars) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, new CharacterMatchCondition(chars), '\u0000');
    }

    public final int scanBackward(int offset, int bound, char[] chars) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset, bound, new CharacterMatchCondition(chars), '\u0000');
    }

    public final int scanForward(int offset, int bound, String string) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound -= string.length(), new StringMatchCondition((ImList<String>)ImCollections.newList((Object)string)), '\u0000');
    }

    public final int scanForward(int offset, int bound, ImList<String> strings) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound -= ((String)strings.getFirst()).length(), new StringMatchCondition(strings), '\u0000');
    }

    public int findClosingPeer(int offset, CharPair pair, char escapeChar) throws BadLocationException {
        if (offset < 0) {
            throw new BadLocationException();
        }
        CharacterMatchCondition condition = new CharacterMatchCondition(pair.toArray());
        int depth = 1;
        int bound = this.checkForwardBound(offset, -2);
        --offset;
        do {
            if ((offset = this.scanForward(offset + 1, bound, condition, escapeChar)) == -1) {
                return -1;
            }
            if (this.ch == pair.opening) {
                ++depth;
                continue;
            }
            --depth;
        } while (depth != 0);
        return offset;
    }

    public int findOpeningPeer(int offset, CharPair pair, char escapeChar) throws BadLocationException {
        if (offset > this.document.getLength()) {
            throw new BadLocationException();
        }
        CharacterMatchCondition condition = new CharacterMatchCondition(pair.toArray());
        int depth = 1;
        int bound = this.checkBackwardBound(offset, -2);
        do {
            if ((offset = this.scanBackward(offset - 1, bound, condition, escapeChar)) == -1) {
                return -1;
            }
            if (this.ch == pair.closing) {
                ++depth;
                continue;
            }
            --depth;
        } while (depth != 0);
        return offset;
    }

    public int[] computePairBalance(int backwardOffset, int forwardOffset, @Nullable TextRegion region, CharPairSet brackets, int[] initial, int searchPairIndex) throws BadLocationException {
        CharPairSet.CharMatch match;
        int[] balance = new int[brackets.getPairCount()];
        class BracketBalanceCondition
        implements StopCondition {
            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable CharPairSet.CharMatch match;
            private final /* synthetic */ CharPairSet val$brackets;

            BracketBalanceCondition(CharPairSet charPairSet) {
                this.val$brackets = charPairSet;
            }

            @Override
            public boolean matches(char c) {
                this.match = this.val$brackets.getMatch((int)c);
                return this.match != null;
            }
        }
        BracketBalanceCondition condition = new BracketBalanceCondition(brackets);
        int breakPairIndex = -1;
        int bound = this.checkBackwardBound(backwardOffset, region != null ? region.getStartOffset() : -2);
        while (--backwardOffset > bound) {
            if ((backwardOffset = this.scanBackward(backwardOffset, bound, condition, brackets.getEscapeChar())) == -1) break;
            match = (CharPairSet.CharMatch)ObjectUtils.nonNullAssert((Object)condition.match);
            if (match.isOpening()) {
                int n = match.getPairIndex();
                balance[n] = balance[n] + 1;
                if (match.getPairIndex() == searchPairIndex || balance[match.getPairIndex()] <= 0) continue;
                breakPairIndex = match.getPairIndex();
                break;
            }
            int n = match.getPairIndex();
            balance[n] = balance[n] - 1;
        }
        int i = 0;
        while (i < balance.length) {
            balance[i] = (balance[i] > 0 ? balance[i] : 0) + initial[i];
            ++i;
        }
        bound = this.checkForwardBound(forwardOffset, region != null ? region.getEndOffset() : -2);
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, condition, brackets.getEscapeChar())) == -1) break;
            match = (CharPairSet.CharMatch)ObjectUtils.nonNullAssert((Object)condition.match);
            if (match.isOpening()) {
                int n = match.getPairIndex();
                balance[n] = balance[n] + 1;
            } else {
                int n = match.getPairIndex();
                balance[n] = balance[n] - 1;
            }
            if (breakPairIndex >= 0 && balance[breakPairIndex] == 0) break;
            ++forwardOffset;
        }
        return balance;
    }

    public int computePairBalance(int backwardOffset, int forwardOffset, @Nullable TextRegion region, CharPair pair, char escapeChar, int initial) throws BadLocationException {
        CharacterMatchCondition condition = new CharacterMatchCondition(pair.toArray());
        int balance = 0;
        int bound = this.checkBackwardBound(backwardOffset, region != null ? region.getStartOffset() : -2);
        while (--backwardOffset > bound) {
            if ((backwardOffset = this.scanBackward(backwardOffset, bound, condition, escapeChar)) == -1) break;
            if (this.ch == pair.opening) {
                ++balance;
                continue;
            }
            --balance;
        }
        balance = (balance > 0 ? balance : 0) + initial;
        bound = this.checkForwardBound(forwardOffset, region != null ? region.getEndOffset() : -2);
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, condition, escapeChar)) == -1) break;
            balance = this.ch == pair.opening ? ++balance : --balance;
            if (balance == 0) break;
            ++forwardOffset;
        }
        return balance;
    }

    public final int findAnyNonSSpaceForward(int offset, int bound) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanAnyForward(offset, bound, this.nonSSpaceCondition, '\u0000');
    }

    public final int findAnyNonMSpaceForward(int offset, int bound) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanAnyForward(offset, bound, this.nonMSpaceCondition, '\u0000');
    }

    public final int findAnyNonSSpaceBackward(int offset, int bound) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanAnyBackward(offset - 1, bound, this.nonSSpaceCondition, '\u0000');
    }

    public final int findAnyNonMSpaceBackward(int offset, int bound) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanAnyBackward(offset - 1, bound, this.nonMSpaceCondition, '\u0000');
    }

    public final int findNonSSpaceForward(int offset, int bound) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, this.nonSSpaceCondition, '\u0000');
    }

    public final int findNonMSpaceForward(int offset, int bound) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, this.nonMSpaceCondition, '\u0000');
    }

    public final int findNonSSpaceBackward(int offset, int bound) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset - 1, bound, this.nonSSpaceCondition, '\u0000');
    }

    public final int findNonMSpaceBackward(int offset, int bound) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset - 1, bound, this.nonMSpaceCondition, '\u0000');
    }

    public final int expandAnySSpaceForward(int offset, int bound) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        this.scanForward(offset, bound, this.nonSSpaceCondition, '\u0000');
        return this.offset;
    }

    public final int expandAnyMSpaceForward(int offset, int bound) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        this.scanForward(offset, bound, this.nonMSpaceCondition, '\u0000');
        return this.offset;
    }

    public final int expandAnySSpaceBackward(int offset, int bound) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        this.scanBackward(offset - 1, bound, this.nonSSpaceCondition, '\u0000');
        return this.offset + 1;
    }

    public final int expandAnyMSpaceBackward(int offset, int bound) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        this.scanBackward(offset - 1, bound, this.nonMSpaceCondition, '\u0000');
        return this.offset + 1;
    }

    public @Nullable IRegion findAnySSpaceRegion(int offset) throws BadLocationException {
        return this.findAnyRegion(offset, this.nonSSpaceCondition, false);
    }

    public @Nullable IRegion findAnyMSpaceRegion(int offset) throws BadLocationException {
        return this.findAnyRegion(offset, this.nonMSpaceCondition, false);
    }

    public boolean isBlankLine(int offset) throws BadLocationException {
        IRegion line = this.document.getLineInformationOfOffset(offset);
        if (line.getLength() > 0) {
            return this.findAnyNonSSpaceForward(line.getOffset(), line.getOffset() + line.getLength()) == -1;
        }
        return true;
    }

    public final @Nullable IRegion findCommonWord(int offset) throws BadLocationException {
        return this.findAnyRegion(offset, COMMON_WORD_CONDITION, false);
    }

    public final int getFirstLineOfRegion(IRegion region) throws BadLocationException {
        return this.document.getLineOfOffset(region.getOffset());
    }

    public final int getLastLineOfRegion(IRegion region) throws BadLocationException {
        if (region.getLength() == 0) {
            return this.document.getLineOfOffset(region.getOffset());
        }
        return this.document.getLineOfOffset(region.getOffset() + region.getLength() - 1);
    }

    public final int count(int start, int stop, char c) throws BadLocationException {
        SingleCharacterMatchCondition condition = new SingleCharacterMatchCondition(c);
        int count = 0;
        while (start < stop && (start = this.scanForward(start, stop, condition, '\u0000')) != -1) {
            ++count;
            ++start;
        }
        return count;
    }

    public final ITypedRegion getPartition(int offset) {
        try {
            return TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)offset, (boolean)false);
        }
        catch (BadLocationException e) {
            return new TypedRegion(this.offset, 0, "__no_partition_at_all");
        }
    }

    protected static class CharacterMatchCondition
    implements StopCondition {
        protected final char[] chars;

        public CharacterMatchCondition(char[] chars) {
            assert (chars != null);
            this.chars = chars;
        }

        @Override
        public boolean matches(char c) {
            int i = 0;
            while (i < this.chars.length) {
                if (c == this.chars[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    protected static class SingleCharacterMatchCondition
    implements StopCondition {
        protected final int singleChar;

        public SingleCharacterMatchCondition(char ch) {
            this.singleChar = ch;
        }

        @Override
        public boolean matches(char c) {
            return c == this.singleChar;
        }
    }

    protected static interface StopCondition {
        public boolean matches(char var1) throws BadLocationException;
    }

    protected class StringMatchCondition
    implements StopCondition {
        protected final ImList<String> strings;

        public StringMatchCondition(ImList<String> strings) {
            this.strings = strings;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matches(char c) {
            try {
                String string;
                Iterator iterator = this.strings.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (c != (string = (String)iterator.next()).charAt(0) || !string.regionMatches(1, HeuristicTokenScanner.this.document.get(HeuristicTokenScanner.this.offset + 1, string.length() - 1), 0, string.length() - 1));
                return true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }
    }
}

