/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.statet.jcommons.ts.core.Tool;

public abstract class ToolTerminateListener
implements IDebugEventSetListener {
    private final Tool tool;

    public ToolTerminateListener(Tool tool) {
        this.tool = tool;
    }

    public void install() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
            if (this.tool.isTerminated()) {
                debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
                this.toolTerminated();
            }
        }
    }

    public void dispose() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() == this.tool && event.getKind() == 8) {
                this.toolTerminated();
            }
            ++i;
        }
    }

    public abstract void toolTerminated();
}

