/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.core;

import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.CompositeLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.export.ExportCommandHandler;
import org.eclipse.statet.ecommons.waltable.grid.config.DefaultGridLayerConfiguration;
import org.eclipse.statet.ecommons.waltable.grid.core.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.print.PrintCommandHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class GridLayer
extends CompositeLayer {
    public GridLayer(Layer bodyLayer, Layer columnHeaderLayer, Layer rowHeaderLayer, Layer cornerLayer) {
        this(bodyLayer, columnHeaderLayer, rowHeaderLayer, cornerLayer, true);
    }

    public GridLayer(Layer bodyLayer, Layer columnHeaderLayer, Layer rowHeaderLayer, Layer cornerLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.setBodyLayer(bodyLayer);
        this.setColumnHeaderLayer(columnHeaderLayer);
        this.setRowHeaderLayer(rowHeaderLayer);
        this.setCornerLayer(cornerLayer);
        this.init(useDefaultConfiguration);
    }

    protected GridLayer(boolean useDefaultConfiguration) {
        super(2, 2);
        this.init(useDefaultConfiguration);
    }

    protected void init(boolean useDefaultConfiguration) {
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultGridLayerConfiguration(this));
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new PrintCommandHandler(this));
        this.registerCommandHandler(new ExportCommandHandler(this));
    }

    @Override
    protected boolean doCommandOnChildLayers(LayerCommand command) {
        if (this.getBodyLayer().doCommand(command)) {
            return true;
        }
        if (this.getColumnHeaderLayer().doCommand(command)) {
            return true;
        }
        if (this.getRowHeaderLayer().doCommand(command)) {
            return true;
        }
        return this.getCornerLayer().doCommand(command);
    }

    public Layer getCornerLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 0);
    }

    public void setCornerLayer(Layer cornerLayer) {
        this.setChildLayer("CORNER", cornerLayer, 0, 0);
    }

    public Layer getColumnHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 0);
    }

    public void setColumnHeaderLayer(Layer columnHeaderLayer) {
        this.setChildLayer("COLUMN_HEADER", columnHeaderLayer, 1, 0);
    }

    public Layer getRowHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 1);
    }

    public void setRowHeaderLayer(Layer rowHeaderLayer) {
        this.setChildLayer("ROW_HEADER", rowHeaderLayer, 0, 1);
    }

    public Layer getBodyLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 1);
    }

    public void setBodyLayer(Layer bodyLayer) {
        this.setChildLayer("BODY", bodyLayer, 1, 1);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[corner=" + String.valueOf(this.getCornerLayer()) + " columnHeader=" + String.valueOf(this.getColumnHeaderLayer()) + " rowHeader=" + String.valueOf(this.getRowHeaderLayer()) + " bodyLayer=" + String.valueOf(this.getBodyLayer()) + "]";
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            ClientAreaResizeCommand resizeCommand = (ClientAreaResizeCommand)command;
            LRectangle possibleArea = SwtUtils.toNatTable(resizeCommand.getScrollable().getClientArea());
            LRectangle rowLayerArea = this.getRowHeaderLayer().getClientAreaProvider().getClientArea();
            LRectangle columnLayerArea = this.getColumnHeaderLayer().getClientAreaProvider().getClientArea();
            resizeCommand.setCalcArea(new LRectangle(possibleArea.x, possibleArea.y, possibleArea.width - rowLayerArea.width, possibleArea.height - columnLayerArea.height));
        }
        return super.doCommand(command);
    }
}

