/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class BreadcrumbViewerRow
extends ViewerRow {
    private final BreadcrumbViewer viewer;
    private final BreadcrumbItem item;
    private @Nullable Color foreground;
    private @Nullable Font font;
    private @Nullable Color background;

    public BreadcrumbViewerRow(BreadcrumbViewer viewer, BreadcrumbItem item) {
        this.viewer = viewer;
        this.item = item;
    }

    public Object clone() {
        return new BreadcrumbViewerRow(this.viewer, this.item);
    }

    public @Nullable Color getBackground(int columnIndex) {
        return this.background;
    }

    public Rectangle getBounds(int columnIndex) {
        return this.getBounds();
    }

    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    public int getColumnCount() {
        return 1;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public Object getElement() {
        return this.item.getElement();
    }

    public @Nullable Font getFont(int columnIndex) {
        return this.font;
    }

    public @Nullable Color getForeground(int columnIndex) {
        return this.foreground;
    }

    public @Nullable Image getImage(int columnIndex) {
        return this.item.getImage();
    }

    public Widget getItem() {
        return this.item;
    }

    public @Nullable ViewerRow getNeighbor(int direction, boolean sameLevel) {
        return null;
    }

    public String getText(int columnIndex) {
        return this.item.getText();
    }

    public TreePath getTreePath() {
        return new TreePath(new Object[]{this.getElement()});
    }

    public void setBackground(int columnIndex, @Nullable Color color) {
        this.background = color;
    }

    public void setFont(int columnIndex, @Nullable Font font) {
        this.font = font;
    }

    public void setForeground(int columnIndex, @Nullable Color color) {
        this.foreground = color;
    }

    public void setImage(int columnIndex, @Nullable Image image) {
        this.item.setImage(image);
    }

    public void setText(int columnIndex, String text) {
        this.item.setText(text);
    }
}

