/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.Comparator;
import java.util.function.BiFunction;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.model.core.NamedElement;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.core.RPkgUtils;

@NonNullByDefault
public final class BasicRPkgList<E extends @NonNull NamedElement>
extends SortedArraySet<E>
implements RPkgList<E> {
    private static final Comparator<NamedElement> RPKG_BY_NAME_COMPARATOR = new Comparator<NamedElement>(){

        @Override
        public final int compare(NamedElement pkg1, NamedElement pkg2) {
            return RPkgUtils.NAMES_COLLATOR.compare(pkg1.getName(), pkg2.getName());
        }
    };
    private static final long serialVersionUID = -3022375551268568786L;

    public BasicRPkgList(int capacity) {
        super((Object[])new NamedElement[capacity], 0, RPKG_BY_NAME_COMPARATOR);
    }

    @Override
    public int indexOf(@Nullable String name) {
        if (name == null) {
            return -1;
        }
        int low = 0;
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RPkgUtils.NAMES_COLLATOR.compare(((NamedElement)super.get(mid)).getName(), name);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    public int indexOf(String name, int low) {
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RPkgUtils.NAMES_COLLATOR.compare(((NamedElement)super.get(mid)).getName(), name);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    public int indexOfE(E pkg) {
        return this.indexOf(pkg.getName());
    }

    @Override
    public boolean contains(@Nullable String name) {
        return this.indexOf(name) >= 0;
    }

    @Override
    public @Nullable E get(@Nullable String name) {
        int idx = this.indexOf(name);
        return (E)(idx >= 0 ? (NamedElement)this.getIndex(idx) : null);
    }

    public int addE(E pkg) {
        return this.addIndex(this.indexOf(pkg.getName()), pkg);
    }

    public <T extends NamedElement> void compute(@NonNull T e, BiFunction<@NonNull T, @Nullable E, @Nullable E> function) {
        int idx = this.indexOf(e.getName());
        NamedElement value = (NamedElement)function.apply(e, idx >= 0 ? (NamedElement)this.getIndex(idx) : null);
        if (value != null) {
            this.addIndex(idx, value);
        } else if (idx >= 0) {
            this.removeIndex(idx);
        }
    }

    public void remove(String name) {
        int idx = this.indexOf(name);
        if (idx >= 0) {
            this.remove(idx);
        }
    }
}

