/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveLaunchAction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.text.ui.TextViewerAction;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.NestedServices;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.css.StylingUtils;
import org.eclipse.statet.ecommons.ui.workbench.texteditor.ActionHandler;
import org.eclipse.statet.internal.nico.ui.LocalTaskTransfer;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.actions.CancelRunnableHandler;
import org.eclipse.statet.internal.nico.ui.actions.RelaunchToolHandler;
import org.eclipse.statet.internal.nico.ui.actions.TerminateToolHandler;
import org.eclipse.statet.internal.nico.ui.actions.ToggleExtStylingContributionItem;
import org.eclipse.statet.internal.nico.ui.console.OutputViewer;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.util.SourceViewerEditorPreferenceUpdater;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.nico.ui.console.InputSourceViewer;
import org.eclipse.statet.nico.ui.console.MultiActionHandler;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.ScrollLockAction;
import org.eclipse.statet.nico.ui.console.SubmitDropAdapter;
import org.eclipse.statet.nico.ui.console.SubmitPasteAction;
import org.eclipse.statet.nico.ui.util.ExportConsoleOutputWizard;
import org.eclipse.statet.nico.ui.util.NicoWizardDialog;
import org.eclipse.statet.nico.ui.util.OpenTrackingFilesContributionItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.FindReplaceAction;

@NonNullByDefault
public abstract class NIConsolePage
implements IPageBookViewPage,
IAdaptable,
IShowInSource,
IShowInTargetList,
IPropertyChangeListener,
ScrollLockAction.Receiver,
ToolProvider,
SettingsChangeNotifier.ChangeListener {
    private static final String DIALOG_ID = "Console";
    private static final String SETTING_INPUTHEIGHT = "InputHeight";
    public static final String NICO_CONTROL_MENU_ID = "nico.control";
    public static final String TRACKING_GROUP_ID = "tracking";
    private static final String FIND_AND_REPLACE_COMMAND_ID = "org.eclipse.ui.edit.findReplace";
    protected static final int CONTENT_DEPENDENT = 2;
    private final NIConsole console;
    private final IConsoleView consoleView;
    private IPageSite site;
    private Composite control;
    private Clipboard clipboard;
    private OutputViewer outputViewer;
    private ConsolePageEditor inputEditor;
    private SizeController resizer;
    private MenuManager outputMenuManager;
    private MenuManager inputMenuManager;
    private volatile boolean isCreated = false;
    private MultiActionHandler multiActionHandler;
    private final CopyOnWriteIdentityListSet<ActiveToolListener> toolListeners = new CopyOnWriteIdentityListSet();
    NestedServices inputServices;
    private OutputContentListener outputContentListener;
    private TextViewerAction outputCopyAction;
    private SubmitPasteAction outputPasteAction;
    private TextViewerAction outputSelectAllAction;
    private ClearOutputAction outputClearAllAction;
    private Action outputScrollLockAction;
    private TextViewerAction inputDeleteAction;
    private TextViewerAction inputCutAction;
    private TextViewerAction inputCopyAction;
    private TextViewerAction inputPasteAction;
    private TextViewerAction inputSelectAllAction;
    private TextViewerAction inputUndoAction;
    private TextViewerAction inputRedoAction;
    private StatusListener debugListener;
    private ConsoleRemoveLaunchAction removeAction;
    private ConsoleRemoveAllTerminatedAction removeAllAction;
    private ContextHandlers pageHandlers;
    private ContextHandlers inputHandlers;

    public NIConsolePage(NIConsole console, IConsoleView view) {
        this.console = console;
        this.consoleView = view;
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
        this.inputEditor = this.createInputEditor();
        this.debugListener = new StatusListener();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.debugListener);
    }

    protected ConsolePageEditor createInputEditor() {
        return new ConsolePageEditor(this, null);
    }

    protected ConsolePageEditor getInputEditor() {
        return this.inputEditor;
    }

    public void createControl(Composite parent) {
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
        this.console.addPropertyChangeListener(this);
        this.control = new Composite(parent, 0){

            public boolean setFocus() {
                NIConsolePage.this.setFocus();
                return true;
            }

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    NIConsolePage.this.setFocus();
                }
            }

            public void redraw() {
                Control outputControl;
                super.redraw();
                OutputViewer outputViewer = NIConsolePage.this.outputViewer;
                if (outputViewer != null && (outputControl = outputViewer.getControl()) != null && !outputControl.isDisposed()) {
                    outputControl.redraw();
                }
            }
        };
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        this.outputViewer = new OutputViewer(this.control, this.console);
        GridData outputGD = new GridData(4, 4, true, true);
        this.outputViewer.getControl().setLayoutData((Object)outputGD);
        this.outputViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.doit && e.character > '\u0000' && (e.stateMask == 0 || e.stateMask == 131072) && (e.keyCode & 0x1000000) == 0) {
                    StyledText textWidget = NIConsolePage.this.inputEditor.getViewer().getTextWidget();
                    if (textWidget == null || !UIAccess.isOkToUse((Control)textWidget)) {
                        return;
                    }
                    int cType = Character.getType(e.character);
                    if (cType > 0 && cType < 15 && textWidget.getCharCount() == 0) {
                        textWidget.replaceTextRange(0, 0, Character.toString(e.character));
                        textWidget.setCaretOffset(textWidget.getCharCount());
                    } else {
                        Display.getCurrent().beep();
                    }
                    NIConsolePage.this.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        final Sash sash = new Sash(this.control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, false));
        new SourceViewerEditorPreferenceUpdater((SourceViewer)this.outputViewer, true, false, EditorsUI.getPreferenceStore()){

            protected void updateColors(ISourceViewer viewer, StyledText styledText) {
                super.updateColors(viewer, styledText);
                if (!StylingUtils.isStylingSupported()) {
                    sash.setBackground(null);
                    Color outputBackground = styledText.getBackground();
                    if (outputBackground.equals((Object)sash.getBackground())) {
                        Color altColor = styledText.getDisplay().getSystemColor(22);
                        if (outputBackground.equals((Object)altColor)) {
                            altColor = styledText.getDisplay().getSystemColor(19);
                        }
                        sash.setBackground(altColor);
                    }
                }
            }
        };
        this.inputEditor.createControl(this.control, this.createInputEditorConfigurator());
        GridData inputGD = new GridData(4, 4, true, false);
        this.inputEditor.getComposite().setLayoutData((Object)inputGD);
        ScrollBar scrollBar = this.outputViewer.getTextWidget().getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(false);
        }
        this.resizer = new SizeController(sash, outputGD, inputGD);
        sash.addListener(13, (Listener)this.resizer);
        this.control.addListener(11, (Listener)this.resizer);
        this.clipboard = new Clipboard(this.control.getDisplay());
        this.initActions();
        this.hookContextMenu();
        this.hookDND();
        this.contributeToActionBars((IServiceLocator)this.getSite(), this.getSite().getActionBars(), (HandlerCollection)this.pageHandlers);
        new ConsoleActivationNotifier();
        this.isCreated = true;
        this.debugListener.init();
        IDialogSettings dialogSettings = DialogUtils.getDialogSettings((Plugin)NicoUIPlugin.getInstance(), (String)DIALOG_ID);
        try {
            int height = dialogSettings.getInt(SETTING_INPUTHEIGHT);
            if (height > 0) {
                this.resizer.lastExplicit = height;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.resizer.fontChanged();
        Display.getCurrent().asyncExec(() -> {
            if (this.inputEditor != null && UIAccess.isOkToUse((Viewer)this.inputEditor.getViewer())) {
                this.outputViewer.revealEndOfDocument();
                if (this.outputViewer.getControl().isFocusControl()) {
                    this.setFocus();
                }
            }
        });
    }

    protected abstract SourceEditorViewerConfigurator createInputEditorConfigurator();

    private void activated() {
        NicoUIPlugin.getInstance().getToolRegistry().consoleActivated(this.consoleView, this.console);
        IEclipseContext service = (IEclipseContext)this.site.getService(IEclipseContext.class);
        if (service != null) {
            service.activate();
        }
    }

    private void initActions() {
        Control outputControl = this.outputViewer.getControl();
        InputSourceViewer inputViewer = this.inputEditor.getViewer();
        Control inputControl = inputViewer.getControl();
        IPageSite pageServiceLocator = this.getSite();
        this.inputServices = new NestedServices((IServiceLocator)pageServiceLocator, "ConsoleInput");
        this.inputServices.bindToFocus(inputControl);
        this.pageHandlers = new ContextHandlers((IServiceLocator)pageServiceLocator);
        this.inputHandlers = new ContextHandlers(this.inputServices.getLocator());
        this.multiActionHandler = new MultiActionHandler();
        this.removeAction = new ConsoleRemoveLaunchAction(this.console.getProcess().getLaunch());
        this.removeAllAction = new ConsoleRemoveAllTerminatedAction();
        this.pageHandlers.addActivate("org.eclipse.debug.ui.commands.Terminate", (IHandler2)new TerminateToolHandler(this.getSite(), this, "org.eclipse.debug.ui.commands.Terminate"));
        this.pageHandlers.addActivate("org.eclipse.statet.nico.commands.CancelCurrent", (IHandler2)new CancelRunnableHandler(this.getSite(), this, "org.eclipse.statet.nico.commands.CancelCurrent"));
        this.pageHandlers.addActivate("org.eclipse.statet.nico.commands.CancelCurrentAndPause", (IHandler2)new CancelRunnableHandler(this.getSite(), this, "org.eclipse.statet.nico.commands.CancelCurrentAndPause"));
        this.pageHandlers.addActivate("org.eclipse.statet.nico.commands.CancelAll", (IHandler2)new CancelRunnableHandler(this.getSite(), this, "org.eclipse.statet.nico.commands.CancelAll"));
        this.pageHandlers.addActivate("org.eclipse.statet.nico.commands.RelaunchTool", (IHandler2)new RelaunchToolHandler(this.getSite(), this, "org.eclipse.statet.nico.commands.RelaunchTool"));
        this.outputCopyAction = TextViewerAction.createCopyAction((ITextViewer)this.outputViewer);
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.COPY.getId(), (IAction)this.outputCopyAction);
        this.outputPasteAction = new SubmitPasteAction(this);
        this.outputPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.PASTE.getId(), (IAction)this.outputPasteAction);
        this.outputSelectAllAction = TextViewerAction.createSelectAllAction((ITextViewer)this.outputViewer);
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.SELECT_ALL.getId(), (IAction)this.outputSelectAllAction);
        this.outputClearAllAction = new ClearOutputAction((TextConsole)this.console);
        this.outputScrollLockAction = new ScrollLockAction(this, false);
        this.inputDeleteAction = TextViewerAction.createDeleteAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.DELETE.getId(), (IAction)this.inputDeleteAction);
        this.inputCutAction = TextViewerAction.createCutAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.CUT.getId(), (IAction)this.inputCutAction);
        this.inputCopyAction = TextViewerAction.createCopyAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.COPY.getId(), (IAction)this.inputCopyAction);
        this.inputPasteAction = TextViewerAction.createPasteAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.PASTE.getId(), (IAction)this.inputPasteAction);
        this.inputSelectAllAction = TextViewerAction.createSelectAllAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.SELECT_ALL.getId(), (IAction)this.inputSelectAllAction);
        this.inputUndoAction = TextViewerAction.createUndoAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.UNDO.getId(), (IAction)this.inputUndoAction);
        this.inputRedoAction = TextViewerAction.createRedoAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.REDO.getId(), (IAction)this.inputRedoAction);
        ResourceBundle bundle = SharedMessages.getCompatibilityBundle();
        this.pageHandlers.addActivate(FIND_AND_REPLACE_COMMAND_ID, (IHandler2)new ActionHandler((IAction)new FindReplaceAction(bundle, "FindReplaceAction_", (IWorkbenchPart)this.consoleView)), 2);
        this.pageHandlers.addActivate("org.eclipse.ui.edit.findNext", (IHandler2)new ActionHandler((IAction)new FindNextAction(bundle, "FindNextMatchAction_", (IWorkbenchPart)this.consoleView, true)), 2);
        this.pageHandlers.addActivate("org.eclipse.ui.edit.findPrevious", (IHandler2)new ActionHandler((IAction)new FindNextAction(bundle, "FindPreviousMatchAction_", (IWorkbenchPart)this.consoleView, true)), 2);
        this.outputContentListener = new OutputContentListener();
        this.console.getDocument().addDocumentListener((IDocumentListener)this.outputContentListener);
        inputViewer.getDocument().addDocumentListener((IDocumentListener)new InputContentListener());
        inputViewer.addSelectionChangedListener(this.multiActionHandler);
        this.outputViewer.addSelectionChangedListener(this.multiActionHandler);
        this.initActions((IServiceLocator)this.getSite(), (HandlerCollection)this.pageHandlers);
        this.inputEditor.initActions(this.inputServices.getLocator(), this.inputHandlers);
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
    }

    private void hookContextMenu() {
        String id = "org.eclipse.statet.nico.console#OutputContextMenu";
        this.outputMenuManager = new MenuManager("ContextMenu", id);
        this.outputMenuManager.setRemoveAllWhenShown(true);
        this.outputMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NIConsolePage.this.fillOutputContextMenu(manager);
            }
        });
        Control control = this.outputViewer.getControl();
        Menu menu = this.outputMenuManager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(id, this.outputMenuManager, (ISelectionProvider)this.outputViewer);
        id = "org.eclipse.statet.nico.console#InputContextMenu";
        this.inputMenuManager = new MenuManager("ContextMenu", id);
        this.inputMenuManager.setRemoveAllWhenShown(true);
        this.inputMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NIConsolePage.this.fillInputContextMenu(manager);
            }
        });
        control = this.inputEditor.getViewer().getControl();
        menu = this.inputMenuManager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(id, this.inputMenuManager, (ISelectionProvider)this.inputEditor.getViewer());
    }

    protected void hookDND() {
        DNDUtils.addDropSupport((Control)this.outputViewer.getControl(), (DropTargetListener)new SubmitDropAdapter(this), (Transfer[])new Transfer[]{TextTransfer.getInstance(), LocalTaskTransfer.getTransfer()});
    }

    protected void contributeToActionBars(final IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        this.multiActionHandler.registerActions(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.appendToGroup("outputGroup", (IAction)this.outputClearAllAction);
        toolBarManager.appendToGroup("outputGroup", (IAction)this.outputScrollLockAction);
        toolBarManager.appendToGroup("launchGroup", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "org.eclipse.statet.nico.menus.Cancel", "org.eclipse.statet.nico.commands.CancelCurrent", null, null, null, null, Messages.CancelAction_name, null, Messages.CancelAction_tooltip, 4, null, false), handlers){

            protected void initDropDownMenu(final MenuManager menuManager) {
                menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                    public void menuAboutToShow(IMenuManager menuManager2) {
                        menuManager2.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.CancelCurrent", 8)));
                        menuManager2.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.CancelCurrentAndPause", 8)));
                        menuManager2.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.CancelAll", 8)));
                    }

                    public void menuAboutToHide(IMenuManager manager) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                menuManager.dispose();
                            }
                        });
                    }
                });
            }
        });
        toolBarManager.appendToGroup("launchGroup", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.RelaunchTool", null, null, null, null, null, null, Messages.RelaunchToolAction_tooltip, 8, null, false), handlers));
        toolBarManager.appendToGroup("launchGroup", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.debug.ui.commands.Terminate", null, null, null, null, null, null, Messages.TerminateToolAction_tooltip, 8, null, false), handlers));
        toolBarManager.appendToGroup("launchGroup", (IAction)this.removeAction);
        toolBarManager.appendToGroup("launchGroup", (IAction)this.removeAllAction);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator(NICO_CONTROL_MENU_ID));
        menuManager.add((IContributionItem)new Separator("view"));
        if (this.console.getStreams().anyMatch(stream -> stream.getEscSequenceMode() != 0)) {
            menuManager.appendToGroup("view", (IContributionItem)new ToggleExtStylingContributionItem(this));
        }
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator(TRACKING_GROUP_ID));
        MenuManager trackingMenu = new MenuManager("Open In Editor"){

            public boolean isVisible() {
                return !NIConsolePage.this.getTool().getTracks().isEmpty();
            }
        };
        trackingMenu.add((IContributionItem)new OpenTrackingFilesContributionItem(this.getTool()));
        menuManager.appendToGroup(TRACKING_GROUP_ID, (IContributionItem)trackingMenu);
        menuManager.appendToGroup(TRACKING_GROUP_ID, (IContributionItem)new SimpleContributionItem("Export Console Output...", null){

            protected void execute() throws ExecutionException {
                ExportConsoleOutputWizard wizard = new ExportConsoleOutputWizard(NIConsolePage.this);
                NicoWizardDialog dialog = new NicoWizardDialog(NIConsolePage.this.getSite().getShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new SimpleContributionItem("Preferences...", "P"){

            protected void execute() throws ExecutionException {
                Shell shell = NIConsolePage.this.getSite().getShell();
                ArrayList<String> pageIds = new ArrayList<String>();
                NIConsolePage.this.collectContextMenuPreferencePages(pageIds);
                if (!(pageIds.isEmpty() || shell != null && shell.isDisposed())) {
                    org.eclipse.ui.dialogs.PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)((String)pageIds.getFirst()), (String[])pageIds.toArray(new String[pageIds.size()]), null).open();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
    }

    protected void fillInputContextMenu(IMenuManager manager) {
        manager.add((IAction)this.inputCutAction);
        manager.add((IAction)this.inputCopyAction);
        manager.add((IAction)this.inputPasteAction);
        manager.add((IContributionItem)new GroupMarker("cut.ext"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.inputUndoAction);
        manager.add((IAction)this.inputRedoAction);
        manager.add((IContributionItem)new GroupMarker("undo.ext"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillOutputContextMenu(IMenuManager manager) {
        manager.add((IAction)this.outputCopyAction);
        manager.add((IAction)this.outputSelectAllAction);
        manager.add((IContributionItem)new Separator("edit"));
        manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.site, FIND_AND_REPLACE_COMMAND_ID, FIND_AND_REPLACE_COMMAND_ID, null, null, null, null, SharedMessages.FindAction_name, null, null, 8, null, false), (HandlerCollection)this.pageHandlers));
        manager.add((IContributionItem)new Separator("submit"));
        manager.add((IAction)this.outputPasteAction);
        manager.add((IContributionItem)new Separator("view"));
        manager.add((IAction)this.outputClearAllAction);
        manager.add((IAction)this.outputScrollLockAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void dispose() {
        this.console.removePropertyChangeListener(this);
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
        if (this.debugListener != null) {
            DebugPlugin debug = DebugPlugin.getDefault();
            if (debug != null) {
                debug.removeDebugEventListener((IDebugEventSetListener)this.debugListener);
            }
            this.debugListener = null;
        }
        if (this.isCreated) {
            this.isCreated = false;
            try {
                this.console.getDocument().removeDocumentListener((IDocumentListener)this.outputContentListener);
                this.outputViewer.removeSelectionChangedListener(this.multiActionHandler);
                this.inputEditor.getViewer().removeSelectionChangedListener(this.multiActionHandler);
            }
            catch (Exception e) {
                NicoUIPlugin.logError(100, Messages.Console_error_UnexpectedException_message, e);
            }
            if (this.pageHandlers != null) {
                this.pageHandlers.dispose();
                this.pageHandlers = null;
            }
            if (this.inputHandlers != null) {
                this.inputHandlers.dispose();
                this.inputHandlers = null;
            }
            this.multiActionHandler.dispose();
            this.multiActionHandler = null;
            this.inputServices.dispose();
            this.inputServices = null;
            this.outputCopyAction = null;
            this.outputPasteAction = null;
            this.outputSelectAllAction = null;
            this.outputClearAllAction = null;
            this.inputDeleteAction = null;
            this.inputCutAction = null;
            this.inputCopyAction = null;
            this.inputPasteAction = null;
            this.inputSelectAllAction = null;
            this.inputUndoAction = null;
            this.debugListener = null;
            this.removeAction.dispose();
            this.removeAction = null;
            this.removeAllAction.dispose();
            this.removeAllAction = null;
            this.outputViewer = null;
        }
        if (this.inputEditor != null) {
            this.inputEditor.dispose();
            this.inputEditor = null;
        }
    }

    public IPageSite getSite() {
        return this.site;
    }

    public IConsoleView getView() {
        return this.consoleView;
    }

    public Control getControl() {
        return this.control;
    }

    public NIConsole getConsole() {
        return this.console;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public ToolProcess getTool() {
        return this.console.getProcess();
    }

    public void addToolListener(ActiveToolListener listener) {
        this.toolListeners.add((Object)((ActiveToolListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeToolListener(ActiveToolListener listener) {
        this.toolListeners.remove((Object)listener);
    }

    public TextConsoleViewer getOutputViewer() {
        return this.outputViewer;
    }

    public IMenuManager getOutputContextMenuManager() {
        return this.outputMenuManager;
    }

    public IMenuManager getInputContextMenuManager() {
        return this.inputMenuManager;
    }

    public String getInput() {
        return this.inputEditor.getDocument().get();
    }

    public void clearInput() {
        this.inputEditor.clear();
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (this.inputEditor != null) {
            if (adapterType == Widget.class) {
                if (this.outputViewer.getControl().isFocusControl()) {
                    return (T)this.outputViewer.getTextWidget();
                }
                return (T)this.inputEditor.getViewer().getTextWidget();
            }
            if (adapterType == IFindReplaceTarget.class) {
                if (this.inputEditor.getViewer().getControl().isFocusControl()) {
                    return (T)this.inputEditor.getViewer().getFindReplaceTarget();
                }
                return (T)this.outputViewer.getFindReplaceTarget();
            }
        }
        if (adapterType == SourceEditor.class) {
            return (T)this.inputEditor;
        }
        if (adapterType == IShowInSource.class) {
            return (T)this;
        }
        if (adapterType == IShowInTargetList.class) {
            return (T)this;
        }
        return this.console.getAdapter(adapterType);
    }

    public @Nullable ShowInContext getShowInContext() {
        ToolProcess process = this.console.getProcess();
        IDebugTarget target = (IDebugTarget)process.getAdapter(IDebugTarget.class);
        TreeSelection selection = null;
        selection = target == null ? new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), process.getLaunch(), process})) : new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), target.getLaunch(), target}));
        return new ShowInContext(null, (ISelection)selection);
    }

    public @NonNull String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.inputEditor.getViewer().getControl().setFocus();
    }

    protected void onToolTerminated() {
        if (this.isCreated) {
            ActiveToolListener.ActiveToolEvent event = new ActiveToolListener.ActiveToolEvent(2, (Tool)this.getTool());
            for (ActiveToolListener listener : this.toolListeners) {
                listener.onToolChanged(event);
            }
            this.outputPasteAction.setEnabled(false);
            Button button = this.inputEditor.getSubmitButton();
            UIAccess.getDisplay((Shell)this.getSite().getShell()).asyncExec(() -> {
                if (!button.isDisposed()) {
                    button.setEnabled(false);
                }
            });
            IDialogSettings dialogSettings = DialogUtils.getDialogSettings((Plugin)NicoUIPlugin.getInstance(), (String)DIALOG_ID);
            dialogSettings.put(SETTING_INPUTHEIGHT, this.resizer.lastExplicit);
        }
    }

    @Override
    public void setAutoScroll(boolean enabled) {
        this.outputViewer.setAutoScroll(enabled);
        this.outputScrollLockAction.setChecked(!enabled);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (UIAccess.isOkToUse((Control)this.control)) {
            Object source = event.getSource();
            String property = event.getProperty();
            if (source.equals((Object)this.console) && property.equals(IConsoleConstants.P_FONT)) {
                Font font = this.console.getFont();
                this.outputViewer.setFont(font);
                this.inputEditor.setFont(font);
                this.resizer.fontChanged();
                this.control.layout();
            } else if (property.equals(IConsoleConstants.P_FONT_STYLE)) {
                this.control.redraw();
                this.outputViewer.getTextWidget().redraw();
            } else if (property.equals(IConsoleConstants.P_STREAM_COLOR) || property.equals("ExtStyling")) {
                this.outputViewer.getTextWidget().redraw();
            } else if (source.equals((Object)this.console) && property.equals(IConsoleConstants.P_CONSOLE_WIDTH)) {
                this.outputViewer.setConsoleWidth(this.console.getConsoleWidth());
            }
        }
    }

    public void settingsChanged(Set<String> groupIds) {
        HashMap options = new HashMap();
        UIAccess.getDisplay().syncExec(() -> this.handleSettingsChanged(groupIds, options));
    }

    protected void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (this.inputEditor != null && UIAccess.isOkToUse((Control)this.control)) {
            this.inputEditor.handleSettingsChanged(groupIds, options);
        }
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        pageIds.add("org.eclipse.statet.nico.preferencePages.Console");
        pageIds.add("org.eclipse.statet.nico.preferencePages.ConsoleTextStyles");
    }

    private class ConsoleActivationNotifier
    implements Listener {
        private ConsoleActivationNotifier() {
            NIConsolePage.this.control.addListener(26, (Listener)this);
            NIConsolePage.this.control.addListener(12, (Listener)this);
            if (NIConsolePage.this.control.isVisible()) {
                NIConsolePage.this.activated();
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    NIConsolePage.this.activated();
                    break;
                }
                case 12: {
                    NIConsolePage.this.control.removeListener(26, (Listener)this);
                    NIConsolePage.this.control.removeListener(12, (Listener)this);
                }
            }
        }
    }

    private class InputContentListener
    implements IDocumentListener,
    Runnable {
        private volatile boolean isSheduled = false;

        private InputContentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!this.isSheduled) {
                this.isSheduled = true;
                Display display = UIAccess.getDisplay((Shell)NIConsolePage.this.getSite().getShell());
                display.asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.isSheduled = false;
            NIConsolePage.this.multiActionHandler.updateEnabledState();
            NIConsolePage.this.inputHandlers.update(null, 2);
        }
    }

    private class OutputContentListener
    implements IDocumentListener {
        private boolean wasEmpty = true;

        private OutputContentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            boolean isEmpty;
            boolean bl = isEmpty = event.fDocument.getLength() == 0;
            if (isEmpty != this.wasEmpty) {
                this.wasEmpty = isEmpty;
                NIConsolePage.this.multiActionHandler.updateEnabledState();
                NIConsolePage.this.pageHandlers.update(null, 2);
            }
        }
    }

    private class SizeController
    implements Listener {
        private final Sash sash;
        private final GridData outputGD;
        private final GridData inputGD;
        private int lastExplicit;

        public SizeController(Sash sash, GridData outputGD, GridData inputGD) {
            this.sash = sash;
            this.outputGD = outputGD;
            this.inputGD = inputGD;
            this.lastExplicit = -1;
        }

        public void handleEvent(Event event) {
            Composite composite = NIConsolePage.this.control;
            if (composite.isDisposed()) {
                return;
            }
            if (event.widget == this.sash) {
                if (event.type == 13 && event.detail != 1) {
                    Rectangle bounds = composite.getClientArea();
                    this.setNewInputHeight(composite, bounds.height - event.y - this.sash.getSize().y, true);
                }
                return;
            }
            if (event.widget == composite && event.type == 11) {
                this.setNewInputHeight(composite, this.inputGD.heightHint, false);
            }
        }

        private void setNewInputHeight(Composite composite, int height, boolean explicit) {
            if (!explicit) {
                height = this.lastExplicit;
            }
            if (height == -1) {
                return;
            }
            Rectangle bounds = composite.getClientArea();
            int max = bounds.height - this.outputGD.minimumHeight - this.sash.getSize().y;
            if (height > max) {
                height = max;
            }
            if (height < this.inputGD.minimumHeight) {
                height = -1;
            }
            if (explicit) {
                this.lastExplicit = height;
            }
            if (this.inputGD.heightHint == height) {
                return;
            }
            this.inputGD.heightHint = height;
            composite.layout(new Control[]{NIConsolePage.this.inputEditor.getComposite()});
        }

        private void fontChanged() {
            this.outputGD.minimumHeight = LayoutUtils.hintHeight((StyledText)NIConsolePage.this.outputViewer.getTextWidget(), (int)4);
            ScrollBar bar = NIConsolePage.this.outputViewer.getTextWidget().getHorizontalBar();
            if (bar.isVisible()) {
                this.outputGD.minimumHeight += bar.getSize().y;
            }
            this.inputGD.minimumHeight = NIConsolePage.this.inputEditor.getComposite().computeSize((int)800, (int)-1).y;
            if (this.inputGD.heightHint != -1 && this.inputGD.minimumHeight > this.inputGD.heightHint) {
                this.inputGD.heightHint = -1;
            }
        }
    }

    private class StatusListener
    implements IDebugEventSetListener {
        private boolean isProcessing = false;
        private boolean isTerminated = false;
        private int updateId = Integer.MIN_VALUE;
        private @Nullable Prompt newPrompt = null;
        private boolean currentBusy = false;
        private boolean newBusy = false;

        private StatusListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            ToolController controller = NIConsolePage.this.getConsole().getProcess().getController();
            StatusListener statusListener = this;
            synchronized (statusListener) {
                if (controller != null) {
                    ToolStatus status = controller.getStatus();
                    this.isProcessing = status == ToolStatus.STARTED_PROCESSING || status == ToolStatus.STARTING;
                    this.isTerminated = status == ToolStatus.TERMINATED;
                    this.newBusy = this.isProcessing || this.isTerminated;
                    this.currentBusy = this.newBusy;
                } else {
                    this.isProcessing = false;
                    this.isTerminated = true;
                    this.newBusy = true;
                    this.currentBusy = true;
                }
                NIConsolePage.this.inputEditor.updatePrompt(null);
                NIConsolePage.this.inputEditor.updateBusy(this.currentBusy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDebugEvents(@NonNull DebugEvent[] events) {
            int thisId;
            long schedule;
            ToolProcess process = NIConsolePage.this.getConsole().getProcess();
            ToolWorkspace data = process.getWorkspace();
            Prompt prompt = null;
            boolean match = false;
            Object object = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = object[n2];
                if (event.getSource() == process) {
                    if (event.getKind() == 8) {
                        match = true;
                        this.isTerminated = true;
                        NIConsolePage.this.onToolTerminated();
                    }
                } else if (event.getSource() == process.getQueue()) {
                    if (Queue.isStateChange((DebugEvent)event)) {
                        Queue.StateDelta delta = (Queue.StateDelta)event.getData();
                        match = true;
                        this.isProcessing = delta.newState == 2;
                        this.isTerminated = delta.newState == 6;
                    }
                } else if (event.getSource() == data && event.getKind() == 16 && event.getDetail() == 1) {
                    match = true;
                    prompt = (Prompt)event.getData();
                }
                ++n2;
            }
            if (!match) {
                return;
            }
            object = this;
            synchronized (object) {
                this.newBusy = this.isProcessing || this.isTerminated;
                long l = schedule = this.newBusy ? System.nanoTime() + 50000000L : System.nanoTime();
                if (prompt != null) {
                    this.newPrompt = prompt;
                }
                if (!NIConsolePage.this.isCreated || this.newBusy == this.currentBusy && this.newPrompt == null) {
                    return;
                }
                thisId = ++this.updateId;
            }
            UIAccess.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long remaining = schedule - System.nanoTime();
                    if (remaining > 4000000L) {
                        Display.getCurrent().timerExec((int)((remaining + 400000L) / 1000000L), (Runnable)this);
                        return;
                    }
                    if (!((StatusListener)StatusListener.this).NIConsolePage.this.isCreated) {
                        return;
                    }
                    StatusListener statusListener = StatusListener.this;
                    synchronized (statusListener) {
                        if (thisId != StatusListener.this.updateId) {
                            return;
                        }
                        if (StatusListener.this.newPrompt != null) {
                            ((StatusListener)StatusListener.this).NIConsolePage.this.inputEditor.updatePrompt(StatusListener.this.newPrompt);
                            StatusListener.this.newPrompt = null;
                        }
                        if (StatusListener.this.newBusy != StatusListener.this.currentBusy) {
                            ((StatusListener)StatusListener.this).NIConsolePage.this.inputEditor.updateBusy(StatusListener.this.newBusy);
                            StatusListener.this.currentBusy = StatusListener.this.newBusy;
                        }
                    }
                }
            });
        }
    }
}

