/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model.build;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.rmodel.RModelIndexOrder;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.impl.GenericResourceSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.project.RProject;

@NonNullByDefault
public class RModelIndexUpdate
extends RModelIndexOrder {
    public RModelIndexUpdate(RProject rProject, List<String> modelTypeIds, boolean isFullBuild) {
        super(rProject, modelTypeIds, isFullBuild);
    }

    public void update(RPkgData pkgData) {
        this.pkgData = pkgData;
    }

    public void update(RSourceUnit sourceUnit, @Nullable RSourceUnitModelInfo model) {
        RModelIndexOrder.Result result = this.createResult(sourceUnit, model);
        if (result != null) {
            this.updated.add(result);
        }
    }

    public void remove(RSourceUnit sourceUnit) {
        if (!this.isFullBuild) {
            this.removed.add(sourceUnit.getId());
        }
    }

    public void remove(IFile file) {
        if (!this.isFullBuild) {
            this.removed.add(GenericResourceSourceUnit.createResourceId((IResource)file));
        }
    }

    public void submit(IProgressMonitor monitor) throws CoreException {
        RModelManagerImpl rManager = RCorePlugin.getInstance().getRModelManager();
        rManager.getIndex().update(this, monitor);
    }
}

