/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.customcharts.core;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.customcharts.core.Messages;
import org.eclipse.swtchart.customcharts.core.ResetChromatogramHandler;
import org.eclipse.swtchart.extensions.axisconverter.MillisecondsToMinuteConverter;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.ResetChartHandler;

public class ChromatogramChart
extends LineChart {
    public ChromatogramChart() {
        this.initialize();
    }

    public ChromatogramChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(true);
        chartSettings.getRangeRestriction().setZeroX(true);
        chartSettings.getRangeRestriction().setZeroY(true);
        chartSettings.removeMenuEntry(chartSettings.getChartMenuEntryByClass(ResetChartHandler.class));
        chartSettings.addMenuEntry((IChartMenuEntry)new ResetChromatogramHandler());
        this.setPrimaryAxisSet(chartSettings);
        this.addSecondaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "ChromatogramChart");
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(Messages.getString("RETENTION_TIME"));
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(this.getDisplay().getSystemColor(24));
        primaryAxisSettingsX.setPosition(IAxis.Position.Secondary);
        primaryAxisSettingsX.setVisible(false);
        primaryAxisSettingsX.setGridLineStyle(LineStyle.NONE);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(Messages.getString("INTENSITY"));
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(this.getDisplay().getSystemColor(24));
        primaryAxisSettingsY.setGridLineStyle(LineStyle.NONE);
    }

    private void addSecondaryAxisSet(IChartSettings chartSettings) {
        SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(Messages.getString("MINUTES"), (IAxisScaleConverter)new MillisecondsToMinuteConverter());
        secondaryAxisSettingsX.setPosition(IAxis.Position.Primary);
        secondaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsX.setColor(this.getDisplay().getSystemColor(24));
        chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(Messages.getString("RELATIVE_INTENSITY"), (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(this.getDisplay().getSystemColor(24));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }
}

