/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.preferences;

import org.eclipse.actf.ui.preferences.IScaleValueLabelProvider;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;

public class ScaleFieldEditorWithValue
extends ScaleFieldEditor {
    private Label valueLabel;
    private Label minLabel;
    private Label maxLabel;
    private IScaleValueLabelProvider scaleValueLabelProvider;

    public ScaleFieldEditorWithValue(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.scaleValueLabelProvider = new DefaultScaleValueLabelProvider();
    }

    public ScaleFieldEditorWithValue(String name, String labelText, Composite parent, int min, int max, int increment, int pageIncrement) {
        super(name, labelText, parent, min, max, increment, pageIncrement);
        this.minLabel.setText(Integer.toString(min));
        this.maxLabel.setText(Integer.toString(max));
        this.scaleValueLabelProvider = new DefaultScaleValueLabelProvider();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.valueLabel = new Label(parent, 131072);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        this.valueLabel.setLayoutData((Object)gridData);
        this.scale.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ScaleFieldEditorWithValue.this.valueLabel.setText(ScaleFieldEditorWithValue.this.scaleValueLabelProvider.getScaleValueText(ScaleFieldEditorWithValue.this.scale));
            }
        });
        new Label(parent, 0).setLayoutData((Object)new GridData());
        this.minLabel = new Label(parent, 16384);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.minLabel.setLayoutData((Object)gridData);
        this.maxLabel = new Label(parent, 131072);
        gridData = new GridData();
        gridData.widthHint = 50;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 131072;
        this.maxLabel.setLayoutData((Object)gridData);
        new Label(parent, 0).setLayoutData((Object)new GridData());
    }

    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns - 1);
        ((GridData)this.maxLabel.getLayoutData()).horizontalSpan = numColumns - 3;
    }

    public int getNumberOfControls() {
        return super.getNumberOfControls() + 2;
    }

    protected void doLoad() {
        super.doLoad();
        this.valueLabel.setText(this.scaleValueLabelProvider.getScaleValueText(this.scale));
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        this.valueLabel.setText(this.scaleValueLabelProvider.getScaleValueText(this.scale));
    }

    protected Label getMaxLabel() {
        return this.maxLabel;
    }

    protected Label getMinLabel() {
        return this.minLabel;
    }

    protected Label getValueLabel() {
        return this.valueLabel;
    }

    public void setScaleValueLabelProvider(IScaleValueLabelProvider scaleValueLabelProvider) {
        if (scaleValueLabelProvider != null) {
            this.scaleValueLabelProvider = scaleValueLabelProvider;
        }
    }

    private class DefaultScaleValueLabelProvider
    implements IScaleValueLabelProvider {
        private DefaultScaleValueLabelProvider() {
        }

        public String getScaleValueText(Scale scale) {
            return Integer.toString(scale.getSelection());
        }
    }
}

