/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui;

import java.io.File;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class ModelServiceImageCreator {
    public static final int DUMP_IMG_SIZE_LIMIT = 10000000;
    private IModelService modelService;

    public ModelServiceImageCreator(IModelService modelService) {
        this.modelService = modelService;
    }

    public File getScreenImageAsBMP(String saveFileName, boolean isWhole) {
        ImageData[] wholeImgData;
        IModelServiceScrollManager scrollManager = this.modelService.getScrollManager();
        int[] size = scrollManager.getSize(isWhole).toArray();
        boolean hugeImage = false;
        if (size[0] < 1 || size[1] < 1) {
            size = new int[]{1, 1, 1, 1};
        }
        if (size[2] * size[3] > 10000000) {
            size[3] = 10000000 / size[2];
            if (isWhole) {
                hugeImage = true;
            }
        }
        if (isWhole) {
            switch (scrollManager.getScrollType()) {
                case 0: {
                    wholeImgData = this.getImageByAbsoluteCoordinateScroll(size, scrollManager, true);
                    break;
                }
                case 2: {
                    wholeImgData = this.getImageByPageScroll(size, scrollManager);
                    break;
                }
                case 1: {
                    wholeImgData = this.getImageByIncrementalScroll(size, scrollManager);
                    break;
                }
                default: {
                    hugeImage = false;
                    wholeImgData = this.getImageByAbsoluteCoordinateScroll(size, scrollManager, false);
                    break;
                }
            }
        } else {
            wholeImgData = this.getImageByAbsoluteCoordinateScroll(size, scrollManager, false);
        }
        ImageLoader loader = new ImageLoader();
        loader.data = wholeImgData;
        loader.save(saveFileName, 0);
        if (hugeImage) {
            MessageBox warn = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 34);
            warn.setMessage(ModelServiceMessages.ImageCreator_ImageTooLarge);
            warn.open();
        }
        return new File(saveFileName);
    }

    private ImageData[] getImageByAbsoluteCoordinateScroll(int[] size, IModelServiceScrollManager scrollManager, boolean isWhole) {
        int yCnt;
        int xCnt;
        Image img = new Image((Device)Display.getDefault(), size[0] + 2, size[1] + 2);
        ImageData[] wholeImgData = new ImageData[1];
        GC gc = new GC((Drawable)this.modelService.getTargetComposite());
        if (isWhole) {
            xCnt = (size[2] + size[0] - 1) / size[0];
            yCnt = (size[3] + size[1] - 1) / size[1];
        } else {
            xCnt = 1;
            yCnt = 1;
            size[2] = size[0];
            size[3] = size[1];
        }
        ImageData[][] imgData = new ImageData[xCnt][yCnt];
        int i = 0;
        while (i < xCnt) {
            int j = 0;
            while (j < yCnt) {
                if (isWhole) {
                    scrollManager.absoluteCoordinateScroll(i * size[0], j * size[1], true);
                }
                gc.copyArea(img, 0, 0);
                imgData[i][j] = img.getImageData();
                ++j;
            }
            ++i;
        }
        if (isWhole) {
            scrollManager.absoluteCoordinateScroll(0, 0, false);
        }
        int depth = imgData[0][0].depth;
        wholeImgData[0] = new ImageData(size[2], size[3], depth, imgData[0][0].palette);
        int wholeRowBytes = (size[2] * depth + 31) / 32 * 4;
        int partRowBytes = ((size[0] + 2) * depth + 31) / 32 * 4;
        depth /= 8;
        int wholeSize = wholeImgData[0].data.length;
        if (yCnt > 1) {
            int j = 0;
            while (j < yCnt) {
                int i2 = 0;
                while (i2 < xCnt) {
                    int yBegin = j < yCnt - 1 ? 0 : size[1] * yCnt - size[3];
                    int xBegin = i2 < xCnt - 1 ? 0 : size[0] * xCnt - size[2];
                    xBegin += 2;
                    int k = yBegin;
                    while (k < size[1]) {
                        int wholeBegin = (j * size[1] + (k - yBegin)) * wholeRowBytes + i2 * size[0] * depth;
                        int copySize = partRowBytes - xBegin * depth;
                        if (wholeSize < wholeBegin + copySize) {
                            copySize = wholeSize - wholeBegin;
                        }
                        System.arraycopy(imgData[i2][j].data, (k + 2) * partRowBytes + xBegin * depth, wholeImgData[0].data, wholeBegin, copySize);
                        ++k;
                    }
                    ++i2;
                }
                ++j;
            }
        } else {
            int i3 = 0;
            while (i3 < xCnt) {
                int yBegin = 0;
                int xBegin = i3 < xCnt - 1 ? 0 : size[0] * xCnt - size[2];
                xBegin += 2;
                int k = yBegin;
                while (k < size[3]) {
                    int wholeBegin = (k - yBegin) * wholeRowBytes + i3 * size[0] * depth;
                    int copySize = partRowBytes - xBegin * depth;
                    if (wholeSize < wholeBegin + copySize) {
                        copySize = wholeSize - wholeBegin;
                    }
                    System.arraycopy(imgData[i3][0].data, (k + 2) * partRowBytes + xBegin * depth, wholeImgData[0].data, wholeBegin, copySize);
                    ++k;
                }
                ++i3;
            }
        }
        gc.dispose();
        return wholeImgData;
    }

    private ImageData[] getImageByIncrementalScroll(int[] size, IModelServiceScrollManager scrollManager) {
        Image img = new Image((Device)Display.getDefault(), size[0] + 2, size[1] + 2);
        ImageData[] wholeImgData = new ImageData[1];
        GC gc = new GC((Drawable)this.modelService.getTargetComposite());
        int xCnt = 1;
        int yCnt = 1;
        while (scrollManager.incrementLargeScrollX(false) > 0) {
        }
        while (scrollManager.incrementLargeScrollY(false) > 0) {
        }
        while (scrollManager.decrementLargeScrollX(false) > 0) {
            ++xCnt;
        }
        while (scrollManager.decrementLargeScrollY(false) > 0) {
            ++yCnt;
        }
        scrollManager.decrementLargeScrollY(true);
        ImageData[][] imgData = new ImageData[xCnt][yCnt];
        int[] scrollX = new int[xCnt];
        int[] scrollY = new int[yCnt];
        int i = 0;
        while (i < xCnt) {
            int j = 0;
            while (j < yCnt) {
                gc.copyArea(img, 0, 0);
                imgData[i][j] = img.getImageData();
                scrollY[j] = scrollManager.incrementLargeScrollY(true);
                ++j;
            }
            scrollX[i] = scrollManager.incrementLargeScrollX(true);
            while (scrollManager.decrementLargeScrollY(false) > 0) {
            }
            ++i;
        }
        int depth = imgData[0][0].depth;
        wholeImgData[0] = new ImageData(size[2], size[3], depth, imgData[0][0].palette);
        int wholeRowBytes = (size[2] * depth + 31) / 32 * 4;
        int partRowBytes = ((size[0] + 2) * depth + 31) / 32 * 4;
        depth /= 8;
        int curX = 0;
        int curY = 0;
        int finX = 0;
        int finY = 0;
        int wholeSize = wholeImgData[0].data.length;
        int j = 0;
        while (j < yCnt) {
            int yBegin = j == 0 ? 0 : finY - curY;
            int i2 = 0;
            while (i2 < xCnt) {
                int xBegin = i2 == 0 ? 0 : finX - curX;
                xBegin += 2;
                int k = 0;
                while (k < size[1]) {
                    int wholeBegin = (finY + (k - yBegin)) * wholeRowBytes + finX * depth;
                    int copySize = partRowBytes - xBegin * depth;
                    if (wholeSize < wholeBegin + copySize) {
                        copySize = wholeSize - wholeBegin;
                    }
                    if (copySize > 0) {
                        System.arraycopy(imgData[i2][j].data, (k + 2) * partRowBytes + xBegin * depth, wholeImgData[0].data, wholeBegin, copySize);
                    }
                    ++k;
                }
                curX += scrollX[i2];
                finX += size[0] - xBegin;
                ++i2;
            }
            curY += scrollY[j];
            finY += size[1] - yBegin;
            ++j;
        }
        gc.dispose();
        return wholeImgData;
    }

    private ImageData[] getImageByPageScroll(int[] size, IModelServiceScrollManager scrollManager) {
        Image img = new Image((Device)Display.getDefault(), size[0] + 2, size[1] + 2);
        ImageData[] wholeImgData = new ImageData[1];
        GC gc = new GC((Drawable)this.modelService.getTargetComposite());
        int yCnt = 1;
        yCnt = scrollManager.getLastPageNumber();
        if (yCnt < 1) {
            yCnt = 1;
        }
        scrollManager.jumpToPage(1, true);
        ImageData[] imgData = new ImageData[yCnt];
        int j = 0;
        while (j < yCnt) {
            gc.copyArea(img, 0, 0);
            imgData[j] = img.getImageData();
            scrollManager.incrementPageScroll(true);
            ++j;
        }
        scrollManager.jumpToPage(1, false);
        int depth = imgData[0].depth;
        wholeImgData[0] = new ImageData(size[2], size[3], depth, imgData[0].palette);
        int wholeRowBytes = (size[2] * depth + 31) / 32 * 4;
        int partRowBytes = ((size[0] + 2) * depth + 31) / 32 * 4;
        depth /= 8;
        int wholeSize = wholeImgData[0].data.length;
        int j2 = 0;
        while (j2 < yCnt) {
            int k = 0;
            while (k < size[1]) {
                int wholeBegin = (size[1] * j2 + k) * wholeRowBytes;
                int copySize = partRowBytes;
                if (wholeSize < wholeBegin + copySize) {
                    copySize = wholeSize - wholeBegin;
                }
                if (copySize > 0) {
                    System.arraycopy(imgData[j2].data, (k + 2) * partRowBytes, wholeImgData[0].data, wholeBegin, copySize);
                }
                ++k;
            }
            ++j2;
        }
        gc.dispose();
        return wholeImgData;
    }
}

