/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class RBBIDataWrapper {
    RBBIDataHeader fHeader;
    short[] fFTable;
    short[] fRTable;
    short[] fSFTable;
    short[] fSRTable;
    CharTrie fTrie;
    String fRuleSource;
    int[] fStatusTable;
    private boolean isBigEndian;
    static final int DATA_FORMAT = 1114794784;
    static final int FORMAT_VERSION = 0x3010000;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    static final int DH_SIZE = 24;
    static final int DH_MAGIC = 0;
    static final int DH_FORMATVERSION = 1;
    static final int DH_LENGTH = 2;
    static final int DH_CATCOUNT = 3;
    static final int DH_FTABLE = 4;
    static final int DH_FTABLELEN = 5;
    static final int DH_RTABLE = 6;
    static final int DH_RTABLELEN = 7;
    static final int DH_SFTABLE = 8;
    static final int DH_SFTABLELEN = 9;
    static final int DH_SRTABLE = 10;
    static final int DH_SRTABLELEN = 11;
    static final int DH_TRIE = 12;
    static final int DH_TRIELEN = 13;
    static final int DH_RULESOURCE = 14;
    static final int DH_RULESOURCELEN = 15;
    static final int DH_STATUSTABLE = 16;
    static final int DH_STATUSTABLELEN = 17;
    static final int ACCEPTING = 0;
    static final int LOOKAHEAD = 1;
    static final int TAGIDX = 2;
    static final int RESERVED = 3;
    static final int NEXTSTATES = 4;
    static final int NUMSTATES = 0;
    static final int ROWLEN = 2;
    static final int FLAGS = 4;
    private static final int ROW_DATA = 8;
    static final int RBBI_LOOKAHEAD_HARD_BREAK = 1;
    static final int RBBI_BOF_REQUIRED = 2;
    static TrieFoldingFunc fTrieFoldingFunc = new TrieFoldingFunc();

    int getRowIndex(int state) {
        return 8 + state * (this.fHeader.fCatCount + 4);
    }

    RBBIDataWrapper() {
    }

    static RBBIDataWrapper get(ByteBuffer bytes) throws IOException {
        RBBIDataWrapper This = new RBBIDataWrapper();
        ICUBinary.readHeader(bytes, 1114794784, IS_ACCEPTABLE);
        This.isBigEndian = bytes.order() == ByteOrder.BIG_ENDIAN;
        This.fHeader = new RBBIDataHeader();
        This.fHeader.fMagic = bytes.getInt();
        This.fHeader.fVersion = bytes.getInt(bytes.position());
        This.fHeader.fFormatVersion[0] = bytes.get();
        This.fHeader.fFormatVersion[1] = bytes.get();
        This.fHeader.fFormatVersion[2] = bytes.get();
        This.fHeader.fFormatVersion[3] = bytes.get();
        This.fHeader.fLength = bytes.getInt();
        This.fHeader.fCatCount = bytes.getInt();
        This.fHeader.fFTable = bytes.getInt();
        This.fHeader.fFTableLen = bytes.getInt();
        This.fHeader.fRTable = bytes.getInt();
        This.fHeader.fRTableLen = bytes.getInt();
        This.fHeader.fSFTable = bytes.getInt();
        This.fHeader.fSFTableLen = bytes.getInt();
        This.fHeader.fSRTable = bytes.getInt();
        This.fHeader.fSRTableLen = bytes.getInt();
        This.fHeader.fTrie = bytes.getInt();
        This.fHeader.fTrieLen = bytes.getInt();
        This.fHeader.fRuleSource = bytes.getInt();
        This.fHeader.fRuleSourceLen = bytes.getInt();
        This.fHeader.fStatusTable = bytes.getInt();
        This.fHeader.fStatusTableLen = bytes.getInt();
        ICUBinary.skipBytes(bytes, 24);
        if (This.fHeader.fMagic != 45472 || This.fHeader.fVersion != 1 && This.fHeader.fFormatVersion[0] != 3) {
            throw new IOException("Break Iterator Rule Data Magic Number Incorrect, or unsupported data version.");
        }
        int pos = 96;
        if (This.fHeader.fFTable < pos || This.fHeader.fFTable > This.fHeader.fLength) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fFTable - pos);
        pos = This.fHeader.fFTable;
        This.fFTable = new short[This.fHeader.fFTableLen / 2];
        int i = 0;
        while (i < This.fFTable.length) {
            This.fFTable[i] = bytes.getShort();
            pos += 2;
            ++i;
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fRTable - pos);
        pos = This.fHeader.fRTable;
        This.fRTable = new short[This.fHeader.fRTableLen / 2];
        i = 0;
        while (i < This.fRTable.length) {
            This.fRTable[i] = bytes.getShort();
            pos += 2;
            ++i;
        }
        if (This.fHeader.fSFTableLen > 0) {
            ICUBinary.skipBytes(bytes, This.fHeader.fSFTable - pos);
            pos = This.fHeader.fSFTable;
            This.fSFTable = new short[This.fHeader.fSFTableLen / 2];
            i = 0;
            while (i < This.fSFTable.length) {
                This.fSFTable[i] = bytes.getShort();
                pos += 2;
                ++i;
            }
        }
        if (This.fHeader.fSRTableLen > 0) {
            ICUBinary.skipBytes(bytes, This.fHeader.fSRTable - pos);
            pos = This.fHeader.fSRTable;
            This.fSRTable = new short[This.fHeader.fSRTableLen / 2];
            i = 0;
            while (i < This.fSRTable.length) {
                This.fSRTable[i] = bytes.getShort();
                pos += 2;
                ++i;
            }
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fTrie - pos);
        pos = This.fHeader.fTrie;
        bytes.mark();
        This.fTrie = new CharTrie(bytes, fTrieFoldingFunc);
        bytes.reset();
        if (pos > This.fHeader.fStatusTable) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fStatusTable - pos);
        pos = This.fHeader.fStatusTable;
        This.fStatusTable = new int[This.fHeader.fStatusTableLen / 4];
        i = 0;
        while (i < This.fStatusTable.length) {
            This.fStatusTable[i] = bytes.getInt();
            pos += 4;
            ++i;
        }
        if (pos > This.fHeader.fRuleSource) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fRuleSource - pos);
        pos = This.fHeader.fRuleSource;
        StringBuilder sb = new StringBuilder(This.fHeader.fRuleSourceLen / 2);
        i = 0;
        while (i < This.fHeader.fRuleSourceLen) {
            sb.append(bytes.getChar());
            pos += 2;
            i += 2;
        }
        This.fRuleSource = sb.toString();
        if (RuleBasedBreakIterator.fDebugEnv != null && RuleBasedBreakIterator.fDebugEnv.indexOf("data") >= 0) {
            This.dump();
        }
        return This;
    }

    private int getStateTableNumStates(short[] table) {
        if (this.isBigEndian) {
            return table[0] << 16 | table[1] & 0xFFFF;
        }
        return table[1] << 16 | table[0] & 0xFFFF;
    }

    int getStateTableFlags(short[] table) {
        return table[this.isBigEndian ? 5 : 4];
    }

    void dump() {
        if (this.fFTable.length == 0) {
            throw new NullPointerException();
        }
        System.out.println("RBBI Data Wrapper dump ...");
        System.out.println();
        System.out.println("Forward State Table");
        this.dumpTable(this.fFTable);
        System.out.println("Reverse State Table");
        this.dumpTable(this.fRTable);
        System.out.println("Forward Safe Points Table");
        this.dumpTable(this.fSFTable);
        System.out.println("Reverse Safe Points Table");
        this.dumpTable(this.fSRTable);
        this.dumpCharCategories();
        System.out.println("Source Rules: " + this.fRuleSource);
    }

    public static String intToString(int n, int width) {
        StringBuilder dest = new StringBuilder(width);
        dest.append(n);
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return dest.toString();
    }

    public static String intToHexString(int n, int width) {
        StringBuilder dest = new StringBuilder(width);
        dest.append(Integer.toHexString(n));
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return dest.toString();
    }

    private void dumpTable(short[] table) {
        if (table == null) {
            System.out.println("  -- null -- ");
        } else {
            StringBuilder header = new StringBuilder(" Row  Acc Look  Tag");
            int n = 0;
            while (n < this.fHeader.fCatCount) {
                header.append(RBBIDataWrapper.intToString(n, 5));
                ++n;
            }
            System.out.println(header.toString());
            n = 0;
            while (n < header.length()) {
                System.out.print("-");
                ++n;
            }
            System.out.println();
            int state = 0;
            while (state < this.getStateTableNumStates(table)) {
                this.dumpRow(table, state);
                ++state;
            }
            System.out.println();
        }
    }

    private void dumpRow(short[] table, int state) {
        StringBuilder dest = new StringBuilder(this.fHeader.fCatCount * 5 + 20);
        dest.append(RBBIDataWrapper.intToString(state, 4));
        int row = this.getRowIndex(state);
        if (table[row + 0] != 0) {
            dest.append(RBBIDataWrapper.intToString(table[row + 0], 5));
        } else {
            dest.append("     ");
        }
        if (table[row + 1] != 0) {
            dest.append(RBBIDataWrapper.intToString(table[row + 1], 5));
        } else {
            dest.append("     ");
        }
        dest.append(RBBIDataWrapper.intToString(table[row + 2], 5));
        int col = 0;
        while (col < this.fHeader.fCatCount) {
            dest.append(RBBIDataWrapper.intToString(table[row + 4 + col], 5));
            ++col;
        }
        System.out.println(dest);
    }

    private void dumpCharCategories() {
        int n = this.fHeader.fCatCount;
        String[] catStrings = new String[n + 1];
        int rangeStart = 0;
        int rangeEnd = 0;
        int lastCat = -1;
        int[] lastNewline = new int[n + 1];
        int category = 0;
        while (category <= this.fHeader.fCatCount) {
            catStrings[category] = "";
            ++category;
        }
        System.out.println("\nCharacter Categories");
        System.out.println("--------------------");
        int char32 = 0;
        while (char32 <= 0x10FFFF) {
            category = this.fTrie.getCodePointValue(char32);
            if ((category &= 0xFFFFBFFF) < 0 || category > this.fHeader.fCatCount) {
                System.out.println("Error, bad category " + Integer.toHexString(category) + " for char " + Integer.toHexString(char32));
                break;
            }
            if (category == lastCat) {
                rangeEnd = char32;
            } else {
                if (lastCat >= 0) {
                    if (catStrings[lastCat].length() > lastNewline[lastCat] + 70) {
                        lastNewline[lastCat] = catStrings[lastCat].length() + 10;
                        int n2 = lastCat;
                        catStrings[n2] = String.valueOf(catStrings[n2]) + "\n       ";
                    }
                    int n3 = lastCat;
                    catStrings[n3] = String.valueOf(catStrings[n3]) + " " + Integer.toHexString(rangeStart);
                    if (rangeEnd != rangeStart) {
                        int n4 = lastCat;
                        catStrings[n4] = String.valueOf(catStrings[n4]) + "-" + Integer.toHexString(rangeEnd);
                    }
                }
                lastCat = category;
                rangeStart = rangeEnd = char32;
            }
            ++char32;
        }
        int n5 = lastCat;
        catStrings[n5] = String.valueOf(catStrings[n5]) + " " + Integer.toHexString(rangeStart);
        if (rangeEnd != rangeStart) {
            int n6 = lastCat;
            catStrings[n6] = String.valueOf(catStrings[n6]) + "-" + Integer.toHexString(rangeEnd);
        }
        category = 0;
        while (category <= this.fHeader.fCatCount) {
            System.out.println(String.valueOf(RBBIDataWrapper.intToString(category, 5)) + "  " + catStrings[category]);
            ++category;
        }
        System.out.println();
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        public boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 3;
        }
    }

    static final class RBBIDataHeader {
        int fMagic = 0;
        int fVersion;
        byte[] fFormatVersion = new byte[4];
        int fLength;
        int fCatCount;
        int fFTable;
        int fFTableLen;
        int fRTable;
        int fRTableLen;
        int fSFTable;
        int fSFTableLen;
        int fSRTable;
        int fSRTableLen;
        int fTrie;
        int fTrieLen;
        int fRuleSource;
        int fRuleSourceLen;
        int fStatusTable;
        int fStatusTableLen;
    }

    static class TrieFoldingFunc
    implements Trie.DataManipulate {
        TrieFoldingFunc() {
        }

        public int getFoldingOffset(int data) {
            if ((data & 0x8000) != 0) {
                return data & Short.MAX_VALUE;
            }
            return 0;
        }
    }
}

