/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class GlareOp
implements ILowVisionOperator {
    private float glareDegree = 0.0f;

    public GlareOp() {
    }

    public GlareOp(float f) throws LowVisionException {
        if (!GlareOp.checkDegree(f)) {
            throw new LowVisionException("Glare Degree " + f + " is out of range.");
        }
        this.glareDegree = f;
    }

    public float getGlareDegree() {
        return this.glareDegree;
    }

    public void setGlareDegree(float f) {
        this.glareDegree = f;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) throws LowVisionException {
        WritableRaster writableRaster;
        DataBufferInt dataBufferInt;
        int[] nArray;
        int n;
        WritableRaster writableRaster2 = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster2.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getData();
        int n2 = nArray2.length;
        BufferedImage bufferedImage3 = bufferedImage2;
        if (bufferedImage2 == null) {
            bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        }
        if (n2 != (n = (nArray = (dataBufferInt = (DataBufferInt)(writableRaster = bufferedImage3.copyData(null)).getDataBuffer()).getData()).length)) {
            throw new LowVisionException("Sizes of src and dest images differ.");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = new Integer(nArray2[n3]);
            Integer n5 = null;
            n5 = (Integer)hashMap.get(n4);
            if (n5 == null) {
                n5 = new Integer(GlareOp.convertColor(nArray2[n3], this.glareDegree));
                hashMap.put(n4, n5);
            }
            nArray[n3] = n5;
            ++n3;
        }
        bufferedImage3.setData(writableRaster);
        return bufferedImage3;
    }

    public static int convertColor(int n, float f) throws LowVisionException {
        if (!GlareOp.checkDegree(f)) {
            throw new LowVisionException("Glare Degree " + f + " is out of range.");
        }
        int[] nArray = ColorUtil.intToRGB(n);
        int n2 = GlareOp.convertColorComponent(nArray[0], f);
        int n3 = GlareOp.convertColorComponent(nArray[1], f);
        int n4 = GlareOp.convertColorComponent(nArray[2], f);
        return ColorUtil.RGBToInt(n2, n3, n4);
    }

    private static int convertColorComponent(int n, float f) {
        int n2 = n + Math.round(f * (float)(255 - n));
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 255) {
            return 255;
        }
        return n2;
    }

    private static boolean checkDegree(float f) {
        return 0.0f <= f && f <= 1.0f;
    }
}

