/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import java.util.HashSet;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.IStyle;
import org.eclipse.actf.model.dom.dombycom.impl.AttrImpl;
import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NamedNodeMapImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.StyleImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLTerms;
import org.eclipse.actf.model.dom.dombycom.impl.html.ImageElementImpl;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements IElementEx {
    private static final Integer getSetAttributeFlag = 2;
    private NamedNodeMapImpl cachedAttributes;
    private String originalBorder;
    private static final InputType[] HTMLINPUTCLASSES = new InputType[]{new InputType("edit", "text", InputType.InputClass.EDIT), new InputType("password edit", "password", InputType.InputClass.PASSWORD), new InputType("radio button", "radio", InputType.InputClass.RADIO), new InputType("checkbox", "checkbox", InputType.InputClass.CHECKBOX), new InputType("file upload edit", "file", InputType.InputClass.FILE), new InputType("", "hidden", InputType.InputClass.HIDDEN), new InputType("button", "submit", InputType.InputClass.BUTTON), new InputType("reset button", "reset", InputType.InputClass.BUTTON), new InputType("button", "button", InputType.InputClass.BUTTON), new InputType("button", "image", InputType.InputClass.BUTTON)};

    protected ElementImpl(NodeImpl baseNode, IDispatch inode) {
        super(baseNode, inode, (short)1);
    }

    protected ElementImpl(DocumentImpl baseDoc, IDispatch inode) {
        super(baseDoc, inode, (short)1);
    }

    public String getTagName() {
        return (String)Helper.get(this.inode, "tagName");
    }

    public String getAttribute(String name) {
        IDispatch r = (IDispatch)this.inode.invoke1("getAttributeNode", (Object)name);
        if (r == null) {
            return null;
        }
        Boolean b = (Boolean)Helper.get(r, "specified");
        if (!b.booleanValue()) {
            return null;
        }
        return (String)Helper.get(r, "value");
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.inode.invoke("setAttribute", new Object[]{name, value, getSetAttributeFlag});
    }

    public void removeAttribute(String name) throws DOMException {
        this.inode.invoke1("removeAttribute", (Object)name);
    }

    public String getCurrentAttribute(String name) {
        String r = (String)this.inode.invoke("getAttribute", new Object[]{name, getSetAttributeFlag});
        return r;
    }

    public Attr getAttributeNode(String name) {
        IDispatch r = (IDispatch)this.inode.invoke1("getAttributeNode", (Object)name);
        if (r == null) {
            return null;
        }
        return (Attr)((Object)this.newNode(r, (short)2));
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        AttrImpl a;
        IDispatch r;
        if (!(newAttr instanceof AttrImpl)) {
            Helper.notSupported();
        }
        if ((r = (IDispatch)this.inode.invoke1("setAttributeNode", (Object)(a = (AttrImpl)newAttr).getINode())) == null) {
            return null;
        }
        return (Attr)((Object)this.newNode(r, (short)2));
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        AttrImpl a;
        IDispatch r;
        if (!(oldAttr instanceof AttrImpl)) {
            Helper.notSupported();
        }
        if ((r = (IDispatch)this.inode.invoke1("removeAttributeNode", (Object)(a = (AttrImpl)oldAttr).getINode())) == null) {
            return null;
        }
        return (Attr)((Object)this.newNode(r, (short)2));
    }

    public NodeList getElementsByTagName(String name) {
        IDispatch r = (IDispatch)this.inode.invoke1("getElementsByTagName", (Object)name);
        if (r == null) {
            return null;
        }
        return new NodeListImpl(this, r);
    }

    private void initCache() {
        if (this.cachedAttributes != null) {
            return;
        }
        this.cachedAttributes = (NamedNodeMapImpl)this.getAttributes();
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        this.initCache();
        Attr a = (Attr)this.cachedAttributes.getNamedItemNS(namespaceURI, localName);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.initCache();
        Attr a = (Attr)this.cachedAttributes.getNamedItemNS(namespaceURI, localName);
        if (a == null) {
            return;
        }
        this.removeAttributeNode(a);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        this.initCache();
        Attr a = (Attr)this.cachedAttributes.getNamedItemNS(namespaceURI, localName);
        if (a == null) {
            return null;
        }
        return a;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAttribute(String name) {
        String val = this.getAttribute(name);
        return val != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        String val = this.getAttributeNS(namespaceURI, localName);
        return val != null;
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean doClick() {
        block5: {
            block4: {
                try {
                    if (!"OPTION".equals(this.getLocalName())) break block4;
                    Helper.put(this.inode, "selected", true);
                    return true;
                }
                catch (DispatchException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (!"SELECT".equals(this.getLocalName())) break block5;
            return false;
        }
        this.inode.invoke0("click");
        return true;
    }

    public boolean highlight() {
        IDispatch style = (IDispatch)Helper.get(this.inode, "style");
        if (style == null) {
            return false;
        }
        this.originalBorder = (String)Helper.get(style, "cssText");
        String border = String.valueOf(this.originalBorder) + "border: 3px solid #071; background: #fdd;";
        Helper.put(style, "cssText", border);
        try {
            this.inode.invoke0("scrollIntoView");
            this.inode.invoke0("onmouseover");
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    public boolean unhighlight() {
        IDispatch style = (IDispatch)Helper.get(this.inode, "style");
        if (style == null) {
            return false;
        }
        Helper.put(style, "cssText", this.originalBorder);
        try {
            this.inode.invoke0("onmouseout");
        }
        catch (DispatchException dispatchException) {}
        return false;
    }

    InputType getInputType() {
        Object o = Helper.get(this.inode, "type");
        if (!(o instanceof String)) {
            return null;
        }
        String type = (String)o;
        int i = 0;
        while (i < HTMLINPUTCLASSES.length) {
            if (type.equals(ElementImpl.HTMLINPUTCLASSES[i].htmlType)) {
                return HTMLINPUTCLASSES[i];
            }
            ++i;
        }
        return null;
    }

    private String getInputValue() {
        return (String)Helper.get(this.inode, "value");
    }

    private String modifySrcStr(String src) {
        int st = src.lastIndexOf(47);
        int end = src.lastIndexOf(63);
        if (end == -1) {
            end = src.length();
        }
        if (st < 0) {
            if (end < 0) {
                return src;
            }
            st = 0;
        } else {
            ++st;
        }
        if (end <= st) {
            return src.substring(st);
        }
        return src.substring(st, end);
    }

    public String extractString() {
        String name = this.getLocalName();
        if ("IMG".equals(name)) {
            String src;
            String title;
            String alt = this.getAttribute("alt");
            if (alt != null) {
                alt = Helper.trimHTMLStr(alt);
            }
            if ((title = this.getAttribute("title")) != null) {
                title = Helper.trimHTMLStr(title);
                if (alt == null || alt.length() == 0) {
                    alt = title;
                }
            }
            if ((src = this.getAttribute("src")) != null) {
                src = this.modifySrcStr(src);
            }
            boolean noAlt = alt == null;
            boolean nullAlt = alt != null && alt.length() == 0;
            boolean isLink = Vocabulary.isLink().eval((IEvalTarget)this);
            if (isLink) {
                if (noAlt) {
                    if (Vocabulary.isReadNoAltImageLink()) {
                        return src;
                    }
                    return "";
                }
                if (nullAlt && Vocabulary.isReadNullAltImageLink()) {
                    return src;
                }
                return alt;
            }
            if (noAlt) {
                if (Vocabulary.isReadNoAltImage()) {
                    return src;
                }
                return "";
            }
            if (nullAlt && Vocabulary.isReadNullAltImage()) {
                return src;
            }
            return alt;
        }
        if (Vocabulary.isEmbeddedObject().eval((IEvalTarget)this)) {
            return "(Embedded Object)";
        }
        if ("INPUT".equals(name)) {
            InputType type = this.getInputType();
            if (type != null) {
                if (type.isHidden()) {
                    return "";
                }
                String alt = this.getAttribute("alt");
                if (alt != null && (alt = Helper.trimHTMLStr(alt)).length() > 0) {
                    return alt;
                }
                String value = this.getInputValue();
                if (type.isPassword()) {
                    value = value.replaceAll(".", "*");
                }
                if (value != null && value.length() > 0) {
                    return value;
                }
                String title = this.getAttribute("title");
                if (title != null) {
                    return title;
                }
            }
        } else {
            String alt;
            if ("SELECT".equals(name)) {
                return "Select";
            }
            if ("AREA".equals(name) && (alt = this.getAttribute("alt")) != null && (alt = Helper.trimHTMLStr(alt)).length() > 0) {
                return alt;
            }
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private boolean anyTextInParentLink() {
        current = this.getParentNode();
        if (current != null) ** GOTO lbl6
        return false;
        while (!"A".equals(current.getNodeName())) {
            current = current.getParentNode();
lbl6:
            // 2 sources

            if (current != null) continue;
        }
        if (current == null) {
            return false;
        }
        return this.anyTextInSiblings(current.getFirstChild());
    }

    private boolean anyTextInSiblings(Node element) {
        StringBuffer buff = new StringBuffer();
        Node next = element;
        while (next != null) {
            if (next instanceof ImageElementImpl) {
                next = next.getNextSibling();
                continue;
            }
            if (next instanceof Element && this.anyTextInSiblings(next.getFirstChild())) {
                return true;
            }
            if (next instanceof INodeEx) {
                INodeEx nex = (INodeEx)next;
                buff.append(nex.extractString());
            }
            next = next.getNextSibling();
        }
        return Helper.trimHTMLStr(buff.toString()).length() > 0;
    }

    public short getHeadingLevel() {
        String name = this.getLocalName();
        if (name.length() != 2) {
            return super.getHeadingLevel();
        }
        if (name.charAt(0) != 'H') {
            return super.getHeadingLevel();
        }
        switch (name.charAt(1)) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
        }
        return super.getHeadingLevel();
    }

    public boolean setFocus() {
        try {
            this.inode.invoke0("focus");
            return true;
        }
        catch (DispatchException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setTextContent(String text) {
        try {
            Helper.put(this.inode, "innerText", text);
        }
        catch (DispatchException e) {
            e.printStackTrace();
        }
    }

    public IStyle getStyle() {
        IDispatch style = (IDispatch)Helper.get(this.inode, "currentStyle");
        return new StyleImpl(style);
    }

    public AbstractTerms getTerms() {
        return HTMLTerms.getInstance();
    }

    public Rectangle getLocation() {
        try {
            return Helper.getLocation(this.inode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IElementEx.Position getRadioPosition() {
        if (this.getInputType() == null) {
            return null;
        }
        if (!this.getInputType().isRadio()) {
            return null;
        }
        Element form = this.getParentElement(new String[]{"FORM"});
        if (form == null) {
            return null;
        }
        String radioName = (String)Helper.get(this.inode, "name");
        IElementEx.Position p = new IElementEx.Position();
        this.searchRadioPosition(form, radioName, p, false);
        return p;
    }

    private void searchRadioPosition(Element parent, String radioName, IElementEx.Position p, boolean found) {
        NodeList list = parent.getChildNodes();
        int len = list.getLength();
        int i = 0;
        while (i < len) {
            Node n = list.item(i);
            if (n instanceof ElementImpl) {
                ElementImpl e = (ElementImpl)n;
                if (e.hasChildNodes()) {
                    this.searchRadioPosition(e, radioName, p, found);
                }
                if (e.getInputType() != null && e.getInputType().isRadio()) {
                    String name = (String)Helper.get(e.getINode(), "name");
                    if (radioName.equals(name)) {
                        if (!found) {
                            ++p.index;
                        }
                        ++p.total;
                    }
                    if (e.isSameNode(this)) {
                        found = true;
                    }
                }
            }
            ++i;
        }
    }

    public IElementEx.Position getListPosition() {
        Element list = this.getParentElement(new String[]{"UL", "OL", "DL"});
        Element item = this.getParentElement(new String[]{"LI", "DT"});
        if (list == null) {
            return null;
        }
        IElementEx.Position p = new IElementEx.Position();
        this.searchListPosition(list, item, p, false);
        return p;
    }

    private void searchListPosition(Element parent, Element item, IElementEx.Position p, boolean found) {
        NodeList list = parent.getChildNodes();
        int len = list.getLength();
        int i = 0;
        while (i < len) {
            Node n = list.item(i);
            if (n instanceof ElementImpl) {
                ElementImpl e = (ElementImpl)n;
                String name = e.getNodeName();
                if (e.hasChildNodes() && !"UL".equals(name) && !"OL".equals(name) && !"DL".equals(name)) {
                    this.searchListPosition(e, item, p, found);
                }
                if ("LI".equals(e.getNodeName()) || "DT".equals(e.getNodeName())) {
                    if (!found) {
                        ++p.index;
                    }
                    ++p.total;
                    if (e.isSameNode(item)) {
                        found = true;
                    }
                }
            }
            ++i;
        }
    }

    private Element getParentElement(String[] tagNames) {
        Element parent = this;
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < tagNames.length) {
            set.add(tagNames[i].intern());
            ++i;
        }
        String name = parent.getNodeName();
        while (!set.contains(name.intern())) {
            Node temp = parent.getParentNode();
            if (temp == null || !(temp instanceof Element)) {
                return null;
            }
            parent = (Element)temp;
            name = parent.getNodeName();
        }
        return parent;
    }

    public Element getFormLabel() {
        NodeList nl = this.getOwnerDocument().getElementsByTagName("LABEL");
        Object myId = Helper.get(this.inode, "id");
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof ElementImpl) {
                ElementImpl label = (ElementImpl)node;
                String id = (String)Helper.get(label.inode, "htmlFor");
                if (id != null && id.equals(myId)) {
                    return label;
                }
            }
            ++i;
        }
        return null;
    }

    public char getAccessKey() {
        String key = null;
        String name = this.getNodeName();
        if ("LABEL".equals(name)) {
            return '\u0000';
        }
        Element label = this.getFormLabel();
        key = label != null && label instanceof ElementImpl ? (String)Helper.get(((ElementImpl)label).inode, "accessKey") : (String)Helper.get(this.inode, "accessKey");
        if (key != null && key.length() == 1) {
            return key.toUpperCase().charAt(0);
        }
        return '\u0000';
    }

    public AnalyzedResult analyze(AnalyzedResult ar) {
        char key = this.getAccessKey();
        if (key != '\u0000') {
            ar.addAccessKey(this);
        }
        return super.analyze(ar);
    }

    static class InputType {
        private final InputClass inputClass;
        private final String uiString;
        final String htmlType;

        String getUIString() {
            return this.uiString;
        }

        boolean isEdit() {
            return this.inputClass == InputClass.EDIT;
        }

        boolean isFileEdit() {
            return this.inputClass == InputClass.FILE;
        }

        boolean isButton() {
            return this.inputClass == InputClass.BUTTON;
        }

        boolean isRadio() {
            return this.inputClass == InputClass.RADIO;
        }

        boolean isCheckBox() {
            return this.inputClass == InputClass.CHECKBOX;
        }

        boolean isComboBox() {
            return this.inputClass == InputClass.COMBOBOX;
        }

        boolean isHidden() {
            return this.inputClass == InputClass.HIDDEN;
        }

        boolean isPassword() {
            return this.inputClass == InputClass.PASSWORD;
        }

        boolean isClickable() {
            return this.isButton() || this.isRadio() || this.isCheckBox() || this.isComboBox();
        }

        InputType(String uiString, String htmlType, InputClass inputClass) {
            this.uiString = uiString;
            this.htmlType = htmlType;
            this.inputClass = inputClass;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InputClass {
            EDIT,
            BUTTON,
            RADIO,
            CHECKBOX,
            COMBOBOX,
            HIDDEN,
            PASSWORD,
            FILE;

        }
    }
}

