/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.SingletonNodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.StyleSheetImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLElementImpl;
import org.eclipse.actf.util.dom.EmptyNodeListImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IEnumUnknown;
import org.eclipse.actf.util.win32.comclutch.IOleContainer;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FrameNodeImpl
extends HTMLElementImpl {
    FrameNodeImpl(NodeImpl baseNode, IDispatch idisp) {
        super(baseNode, idisp);
    }

    public NodeList getElementsByTagName(String tagName) {
        IDispatch document = (IDispatch)Helper.get(this.inode, "document");
        IDispatch r = (IDispatch)document.invoke1("getElementsByTagName", (Object)tagName);
        if (r == null) {
            return null;
        }
        return new NodeListImpl(this, r);
    }

    private int getFrameIndex() {
        NodeList frame = this.getElementsByTagName("frame");
        if (frame.getLength() > 0) {
            return this.getFrameIndex(frame);
        }
        NodeList iframe = this.getElementsByTagName("iframe");
        if (iframe.getLength() > 0) {
            return this.getFrameIndex(iframe);
        }
        return -1;
    }

    private int getFrameIndex(NodeList frame) {
        int len = frame.getLength();
        int i = 0;
        while (i < len) {
            Node node = frame.item(i);
            if (node instanceof INodeEx && ((INodeEx)node).isSameNode(this)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IDispatch getFrameByIndex(IDispatch document, int index) {
        IOleContainer iole = (IOleContainer)document.queryInterface(IUnknown.IID_IOleContainer);
        IEnumUnknown ieu = iole.enumObjects(1);
        int count = -1;
        IUnknown[] iunks = ieu.next(1);
        while (iunks != null && iunks.length > 0) {
            try {
                IDispatch idisp = (IDispatch)iunks[0].queryInterface(IUnknown.IID_IWebBrowser2);
                iunks[0].release();
                if (idisp != null && ++count == index) {
                    return idisp;
                }
            }
            catch (DispatchException dispatchException) {}
            iunks = ieu.next(1);
        }
        return null;
    }

    private Element getFrameRootElement() {
        IDispatch document = (IDispatch)Helper.get(this.inode, "document");
        int index = this.getFrameIndex();
        if (index < 0) {
            return null;
        }
        IDispatch idisp = this.getFrameByIndex(document, index);
        if (idisp == null) {
            return null;
        }
        IDispatch idoc = (IDispatch)Helper.get(idisp, "Document");
        if (idoc == null) {
            return null;
        }
        IDispatch ielem = (IDispatch)Helper.get(idoc, "documentElement");
        if (ielem == null) {
            return null;
        }
        this.initialize(idoc);
        return (Element)((Object)this.newNode(ielem, (short)1, this));
    }

    private void initialize(IDispatch doc) {
        try {
            IDispatch r = (IDispatch)doc.invoke0("createStyleSheet");
            if (r == null) {
                return;
            }
            StyleSheetImpl style = new StyleSheetImpl(r);
            style.addRule(".CSStoHighlight", "border: 3px solid green; background: #fdd;");
        }
        catch (DispatchException dispatchException) {}
    }

    public Node getFirstChild() {
        return this.getFrameRootElement();
    }

    public Node getLastChild() {
        return this.getFrameRootElement();
    }

    public NodeList getChildNodes() {
        Element n = this.getFrameRootElement();
        if (n == null) {
            return EmptyNodeListImpl.getInstance();
        }
        return new SingletonNodeListImpl(n);
    }

    public boolean hasChildNodes() {
        Element n = this.getFrameRootElement();
        return n != null;
    }
}

