/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelVisitor;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;

public class NVDLMode
extends NVDLModel {
    public final String name;
    private NVDLRule anyNamespaceRuleForAttribute = null;
    private NVDLRule anyNamespaceRuleForElement = null;
    private List<NVDLRule> rules = new ArrayList<NVDLRule>();
    private List<NVDLMode> includedModes = null;

    public NVDLRule getAnyNamespaceRuleForAttribute() {
        return this.anyNamespaceRuleForAttribute;
    }

    public NVDLRule getAnyNamespaceRuleForElement() {
        return this.anyNamespaceRuleForElement;
    }

    private void addRuleInternal(NVDLRule rule) {
        if (rule.isAnyNamespace()) {
            if (rule.isTargetElement()) {
                assert (this.anyNamespaceRuleForElement == null);
                this.anyNamespaceRuleForElement = rule;
            }
            if (rule.isTargetAttribute()) {
                assert (this.anyNamespaceRuleForAttribute == null);
                this.anyNamespaceRuleForAttribute = rule;
            }
        } else {
            this.rules.add(rule);
        }
    }

    private NVDLRule getConflictRule(NVDLRule rule) {
        if (rule.isAnyNamespace()) {
            if (rule.isTargetElement()) {
                return this.anyNamespaceRuleForElement;
            }
            if (rule.isTargetAttribute()) {
                return this.anyNamespaceRuleForAttribute;
            }
        }
        int i = 0;
        while (i < this.rules.size()) {
            NVDLRule r = this.rules.get(i);
            if (r.isConflicted(rule)) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public NVDLRule addRule(NVDLRule rule) {
        NVDLRule r = this.getConflictRule(rule);
        if (r != null) {
            return r;
        }
        this.addRuleInternal(rule);
        return null;
    }

    public Iterator notAnyNamespaceRuleIterator() {
        return this.rules.iterator();
    }

    public NVDLRule chooseRule(String ns, boolean element) {
        Iterator it = this.notAnyNamespaceRuleIterator();
        while (it.hasNext()) {
            NVDLRule rule = (NVDLRule)it.next();
            if (!rule.match(ns, element)) continue;
            return rule;
        }
        if (element) {
            return this.anyNamespaceRuleForElement;
        }
        return this.anyNamespaceRuleForAttribute;
    }

    public NVDLModel visitModel(NVDLModelVisitor v) throws NVDLModelException {
        return v.visitNVDLMode(this);
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        if (this.name != null) {
            r.append(this.name);
            r.append(";");
        }
        Iterator it = this.notAnyNamespaceRuleIterator();
        while (it.hasNext()) {
            NVDLRule rule = (NVDLRule)it.next();
            r.append(rule.toString());
            r.append(";");
        }
        if (this.anyNamespaceRuleForElement != null) {
            r.append(this.anyNamespaceRuleForElement.toString());
            r.append(";");
        }
        if (this.anyNamespaceRuleForAttribute != null) {
            r.append(this.anyNamespaceRuleForAttribute.toString());
            r.append(";");
        }
        return r.toString();
    }

    public NVDLMode(String name) {
        this.name = name;
    }

    private void includeMode(NVDLMode childMode) {
        if (childMode.anyNamespaceRuleForAttribute != null && this.anyNamespaceRuleForAttribute == null) {
            this.addRule(childMode.anyNamespaceRuleForAttribute);
        }
        if (childMode.anyNamespaceRuleForElement != null && this.anyNamespaceRuleForElement == null) {
            this.addRule(childMode.anyNamespaceRuleForElement);
        }
        int i = 0;
        while (i < childMode.rules.size()) {
            block5: {
                NVDLRule cr = childMode.rules.get(i);
                int j = 0;
                while (j < this.rules.size()) {
                    NVDLRule r = this.rules.get(j);
                    if (!cr.isOverridden(r)) {
                        ++j;
                        continue;
                    }
                    break block5;
                }
                this.addRule(cr);
            }
            ++i;
        }
    }

    public void addIncludedMode(NVDLMode mode) {
        if (this.includedModes == null) {
            this.includedModes = new ArrayList<NVDLMode>(1);
        }
        this.includedModes.add(mode);
    }

    private void removeCancelActionRules() {
        if (this.anyNamespaceRuleForAttribute != null && this.anyNamespaceRuleForAttribute.getActionManager().isCancelAction()) {
            this.anyNamespaceRuleForAttribute = null;
        }
        if (this.anyNamespaceRuleForElement != null && this.anyNamespaceRuleForElement.getActionManager().isCancelAction()) {
            this.anyNamespaceRuleForElement = null;
        }
        int i = 0;
        while (i < this.rules.size()) {
            NVDLRule r = this.rules.get(i);
            if (r.getActionManager().isCancelAction()) {
                this.rules.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void simplifyInclusion() {
        if (this.includedModes == null) {
            return;
        }
        for (NVDLMode child : this.includedModes) {
            this.includeMode(child);
        }
        this.removeCancelActionRules();
        this.includedModes = null;
    }
}

