/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.validation.Schema;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLNoResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;

public class NVDLValidateAction
extends NVDLNoResultAction {
    private List<Option> options = new ArrayList<Option>(0);
    private String schemaType = null;
    private String schemaIRI = null;
    private Schema schema;
    private Schema schemaForAttribute;
    private SchemaLoader loader;

    public void addOption(String name, String arg, boolean mustSupport) {
        this.options.add(new Option(name, arg, mustSupport));
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    public String getSchemaIRI() {
        return this.schemaIRI;
    }

    public void setSchemaIRI(String schemaIRI) {
        this.schemaIRI = schemaIRI;
    }

    public Schema getSchema(boolean forAttribute) throws NVDLException {
        if (forAttribute) {
            if (this.schemaForAttribute != null) {
                return this.schemaForAttribute;
            }
            this.schemaForAttribute = this.loader.load(this, true);
            return this.schemaForAttribute;
        }
        if (this.schema != null) {
            return this.schema;
        }
        this.schema = this.loader.load(this, false);
        return this.schema;
    }

    public void setSchemaLoader(SchemaLoader loader) {
        this.loader = loader;
    }

    public void setSchema(Schema schema, boolean forAttribute) {
        if (forAttribute) {
            this.schemaForAttribute = schema;
        } else {
            this.schema = schema;
        }
    }

    public boolean isSchamaSpecified() {
        return this.schema != null || this.schemaForAttribute != null || this.getSchemaIRI() != null;
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        r.append("Validate");
        if (this.schemaIRI != null) {
            r.append("(");
            r.append(this.schemaIRI);
            r.append(")");
        }
        return r.toString();
    }

    public NVDLValidateAction(String name, String useModeName, NVDLRule belongingRule) {
        super(name, useModeName, belongingRule);
    }

    private static class Option {
        final String name;
        final String arg;
        final boolean mustSupport;

        Option(String name, String arg, boolean mustSupport) {
            this.name = name;
            this.arg = arg;
            this.mustSupport = mustSupport;
        }
    }

    public static interface SchemaLoader {
        public Schema load(NVDLValidateAction var1, boolean var2) throws NVDLException;
    }
}

