/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.reader;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.RELAXNGAttributeSchemaRewriter;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.SchemaRewriter;
import org.eclipse.actf.ai.xmlstore.nvdl.util.PrefixMapper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

class SchemaReaderProxy
extends Thread
implements XMLReader {
    ContentHandler h;
    ErrorHandler schemaReaderProxyErrorHandler = null;
    private static final int CMD_SETDOCUMENTLOCATOR = 1;
    private static final int CMD_STARTELEMENT = 2;
    private static final int CMD_ENDELEMENT = 3;
    private static final int CMD_CHARACTERS = 4;
    private static final int CMD_STARTPREFIXMAPPING = 5;
    private static final int CMD_ENDPREFIXMAPPING = 6;
    private static final int CMD_PROCESSINGINSTRUCTION = 7;
    private static final int CMD_END = 8;
    private int command;
    private int exitStatus;
    private boolean started = false;
    private SAXException exception;
    private Locator locator;
    private PrefixMapper prefixMapper;
    private SchemaRewriter schemaRewriter;
    private SchemaFactory schemaFactory;
    private Schema schema;
    private String uri;
    private String localName;
    private String qName;
    private Attributes attributes;
    private char[] ch;
    private int start;
    private int length;
    private String prefix;
    private String target;
    private String data;
    private SAXSource source;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public synchronized void setContentHandler(ContentHandler h) {
        this.h = h;
        if (this.schemaRewriter != null) {
            this.schemaRewriter.setup(h, this.prefixMapper);
        }
    }

    public ContentHandler getContentHandler() {
        return this.h;
    }

    public void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            throw new NullPointerException();
        }
        this.schemaReaderProxyErrorHandler = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.schemaReaderProxyErrorHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.startParse();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.startParse();
    }

    public Schema getSchema() {
        return this.schema;
    }

    private synchronized void sendCmd(int cmd) {
        if (!this.started) {
            return;
        }
        if (this.exception != null) {
            return;
        }
        this.command = cmd;
        this.exitStatus = 0;
        this.notify();
        while (this.exitStatus == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void checkException() throws SAXException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.sendCmd(1);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.attributes = attributes;
        this.sendCmd(2);
        this.checkException();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.ch = ch;
        this.start = start;
        this.length = length;
        this.sendCmd(4);
        this.checkException();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.sendCmd(3);
        this.checkException();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefix = prefix;
        this.uri = uri;
        this.sendCmd(5);
        this.checkException();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefix = prefix;
        this.sendCmd(6);
        this.checkException();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.target = target;
        this.data = data;
        this.sendCmd(7);
        this.checkException();
    }

    private void startElementI(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.startElement(uri, localName, qName, attrs);
        } else {
            this.schemaRewriter.startElement(uri, localName, qName, attrs);
        }
    }

    private void endElementI(String uri, String localName, String qName) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.endElement(uri, localName, qName);
        } else {
            this.schemaRewriter.endElement(uri, localName, qName);
        }
    }

    private void charactersI(char[] ch, int start, int length) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.characters(ch, start, length);
        } else {
            this.schemaRewriter.characters(ch, start, length);
        }
    }

    private void endDocumentI() throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.endDocument();
        } else {
            this.schemaRewriter.endDocument();
        }
    }

    private void endPrefixMappingI(String prefix) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.endPrefixMapping(prefix);
        } else {
            this.schemaRewriter.endPrefixMapping(prefix);
        }
    }

    private void ignorableWhitespaceI(char[] ch, int start, int length) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.ignorableWhitespace(ch, start, length);
        } else {
            this.schemaRewriter.ignorableWhitespace(ch, start, length);
        }
    }

    private void processingInstructionI(String target, String data) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.processingInstruction(target, data);
        } else {
            this.schemaRewriter.processingInstruction(target, data);
        }
    }

    private void setDocumentLocatorI(Locator l) {
        if (this.schemaRewriter == null) {
            this.h.setDocumentLocator(l);
        } else {
            this.schemaRewriter.setDocumentLocator(l);
        }
    }

    private void skippedEntityI(String name) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.skippedEntity(name);
        } else {
            this.schemaRewriter.skippedEntity(name);
        }
    }

    private void startDocumentI() throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.startDocument();
        } else {
            this.schemaRewriter.startDocument();
        }
    }

    private void startPrefixMappingI(String prefix, String uri) throws SAXException {
        if (this.schemaRewriter == null) {
            this.h.startPrefixMapping(prefix, uri);
        } else {
            this.schemaRewriter.startPrefixMapping(prefix, uri);
        }
    }

    private synchronized void startParse() throws SAXException {
        if (this.h == null) {
            throw new SAXException("Internal Error");
        }
        if (this.locator != null) {
            this.setDocumentLocatorI(this.locator);
        }
        this.startDocumentI();
        Object effectivePrefixMapping = this.prefixMapper.startEffectivePrefixMappings(this.h);
        block14: while (true) {
            if (this.exitStatus != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                switch (this.command) {
                    case 2: {
                        this.startElementI(this.uri, this.localName, this.qName, this.attributes);
                        break;
                    }
                    case 3: {
                        this.endElementI(this.uri, this.localName, this.qName);
                        break;
                    }
                    case 4: {
                        this.charactersI(this.ch, this.start, this.length);
                        break;
                    }
                    case 5: {
                        this.startPrefixMappingI(this.prefix, this.uri);
                        break;
                    }
                    case 6: {
                        this.endPrefixMappingI(this.prefix);
                        break;
                    }
                    case 7: {
                        this.processingInstructionI(this.target, this.data);
                        break;
                    }
                    case 1: {
                        this.setDocumentLocatorI(this.locator);
                        break;
                    }
                    case 8: {
                        break block14;
                    }
                }
            }
            catch (SAXException e) {
                this.exception = e;
            }
            this.exitStatus = 1;
            this.notify();
        }
        this.prefixMapper.endEffectivePrefixMappings(effectivePrefixMapping, this.h);
        this.endDocumentI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SchemaReaderProxy schemaReaderProxy = this;
        synchronized (schemaReaderProxy) {
            try {
                this.schema = this.schemaFactory.newSchema(this.source);
            }
            catch (SAXException e) {
                this.exception = e;
            }
            this.exitStatus = 2;
            this.notify();
        }
    }

    void begin(SchemaFactory schemaFactory, InputSource is, String ns, boolean forAttribute) {
        this.schemaFactory = schemaFactory;
        this.source = new SAXSource(this, is);
        if (forAttribute && "http://relaxng.org/ns/structure/1.0".equals(ns)) {
            this.schemaRewriter = new RELAXNGAttributeSchemaRewriter();
        }
        this.start();
        this.started = true;
    }

    void end() throws SAXException {
        this.sendCmd(8);
        this.started = false;
        this.checkException();
    }

    private SchemaReaderProxy(Locator locator, PrefixMapper prefixMapper) {
        super("SchemaReaderProxy");
        this.locator = locator;
        this.schema = null;
        this.prefixMapper = prefixMapper;
    }

    public static SchemaReaderProxy newProxy(Locator locator, PrefixMapper prefixMapper) {
        return new SchemaReaderProxy(locator, prefixMapper);
    }
}

