/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import com.ibm.icu.text.MessageFormat;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentPrintHandler
extends DefaultHandler {
    public final String name;
    private final PrintWriter out;
    private Locator locator;
    private int number;

    private void output(String mes) {
        this.out.println(mes);
        this.out.flush();
    }

    private String formatLocator() {
        ++this.number;
        if (this.locator == null) {
            return "Locator:null";
        }
        String systemId = this.locator.getSystemId();
        String r = systemId != null ? MessageFormat.format((String)"{0}|{1,number,integer}/{2}, Line:{3,number,integer}, Col:{4,number,integer}", (Object[])new Object[]{this.name, new Integer(this.number), this.locator.getSystemId(), new Integer(this.locator.getLineNumber()), new Integer(this.locator.getColumnNumber())}) : MessageFormat.format((String)"{0}|{1,number,integer}/Line:{2,number,integer}, Col:{3,number,integer}", (Object[])new Object[]{this.name, new Integer(this.number), new Integer(this.locator.getLineNumber()), new Integer(this.locator.getColumnNumber())});
        return r;
    }

    private String formatAttribute(Attributes attrs, int i) {
        String uri = attrs.getURI(i);
        if (uri.length() > 0) {
            return MessageFormat.format((String)"{0}/'{'{1}'}'{2}({3})={4},{5}", (Object[])new Object[]{new Integer(i), uri, attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i), attrs.getType(i)});
        }
        return MessageFormat.format((String)"{0}/{1}({2})={3},{4}", (Object[])new Object[]{new Integer(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i), attrs.getType(i)});
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.output(String.valueOf(this.formatLocator()) + ": setDocumentLocator");
    }

    public void startDocument() throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": startDocument");
    }

    public void endDocument() throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": endDocument");
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": startPrefixMapping {" + prefix + "=" + uri + "}");
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": endPrefixMapping {" + prefix + "}");
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": startElement {" + uri + "}" + localName + "(" + qName + ") ");
        if (attrs.getLength() > 0) {
            this.output("  Attributes:");
            int i = 0;
            while (i < attrs.getLength()) {
                this.output("    " + this.formatAttribute(attrs, i));
                ++i;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": endElement {" + uri + "}" + localName + "(" + qName + ") ");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": characters [" + new String(ch, start, length) + "]");
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": ignorableWhitespace [" + new String(ch, start, length) + "]");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": processingInstruction [" + target + "=" + data + "]");
    }

    public void skippedEntity(String name) throws SAXException {
        this.output(String.valueOf(this.formatLocator()) + ": skippedEntity [" + name + "]");
    }

    public ContentPrintHandler(String name) {
        this(name, System.out);
    }

    public ContentPrintHandler(String name, OutputStream os) {
        this(name, new PrintWriter(os));
    }

    public ContentPrintHandler(String name, PrintWriter out) {
        this.name = name;
        this.out = out;
        this.number = 0;
    }
}

