/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.actf.ai.xmlstore.nvdl.util.MessageFormatter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MessageErrorHandler
implements ErrorHandler {
    private final PrintWriter out;

    private void output(String mes) {
        this.out.println(mes);
        this.out.flush();
    }

    public void warning(SAXParseException e) throws SAXException {
        this.output(MessageFormatter.exception(e));
    }

    public void error(SAXParseException e) throws SAXException {
        this.output(MessageFormatter.exception(e));
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.output(MessageFormatter.exception(e));
        throw e;
    }

    public MessageErrorHandler() {
        this(System.err);
    }

    public MessageErrorHandler(OutputStream os) {
        this(new PrintWriter(os));
    }

    public MessageErrorHandler(PrintWriter out) {
        this.out = out;
    }
}

