/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.spi;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSelectorInfo
implements IXMLSelector {
    public static final String SELECTOR_NS = "http://www.ibm.com/xmlns/prod/AcTF/aiBrowser/selector/1.0";
    private static final int DEFAULT_PRIORITY = 0;
    private String documentElementName;
    private String documentElementNS;
    private String documentation;
    private boolean isUserEntry = false;
    private String pageTitle;
    private String authorName;
    private int priority = 0;
    private ArrayList<Pattern> targetURIPatterns = new ArrayList();
    private ArrayList<String> targetURIs = new ArrayList();

    public static XMLSelectorInfo parse(IXMLInfo info) throws XMLStoreException {
        SelectorHandler sh = new SelectorHandler(info);
        try {
            info.setContentHandler(sh);
            info.startSAX();
        }
        catch (SelectorHandler.FinishedException finishedException) {
        }
        catch (Exception exception) {
            throw new XMLStoreException("XMLSelectorInfo parse failed.");
        }
        return sh.getXMLSelectorInfo();
    }

    public String getDocumentElementName() {
        return this.documentElementName;
    }

    public String getDocumentElementNS() {
        return this.documentElementNS;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isUserEntry() {
        return this.isUserEntry;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getURI() {
        return "";
    }

    public int getPriority() {
        return this.priority;
    }

    private boolean matchDocumentElement(IXMLSelector selector) {
        if (selector.getDocumentElementNS() != null && !this.documentElementNS.equals(selector.getDocumentElementNS())) {
            return false;
        }
        return selector.getDocumentElementName() == null || this.documentElementName.equals(selector.getDocumentElementName());
    }

    private boolean matchURI(IXMLSelector selector) {
        String uri = selector.getURI();
        if (uri == null) {
            return true;
        }
        int size = this.targetURIPatterns.size();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            Pattern pat = this.targetURIPatterns.get(i);
            Matcher m = pat.matcher(uri);
            if (m.matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(IXMLSelector selector) {
        if (!this.matchDocumentElement(selector)) {
            return false;
        }
        return this.matchURI(selector);
    }

    private XMLSelectorInfo() {
    }

    /* synthetic */ XMLSelectorInfo(XMLSelectorInfo xMLSelectorInfo) {
        this();
    }

    private static abstract class BaseHandler
    extends DefaultHandler {
        private IXMLInfo info;

        protected void setHandler(BaseHandler h) {
            this.info.setContentHandler(h);
        }

        protected BaseHandler(IXMLInfo info) {
            this.info = info;
        }

        protected BaseHandler(BaseHandler base) {
            this.info = base.info;
        }
    }

    private static interface FinishHandler {
        public void set(String var1);
    }

    private static class SelectorHandler
    extends BaseHandler {
        private XMLSelectorInfo selectorInfo = new XMLSelectorInfo(null);
        private boolean rootFlag;
        private boolean metaFlag;

        public XMLSelectorInfo getXMLSelectorInfo() {
            return this.selectorInfo;
        }

        private String quote(String pat, char wildCardChar) {
            StringBuffer r = new StringBuffer();
            int i = 0;
            while (i < pat.length()) {
                char c = pat.charAt(i);
                if (c == wildCardChar) {
                    r.append(".*");
                } else if ("\\?*+.[]{}()$^".indexOf(c) >= 0) {
                    r.append('\\');
                    r.append(c);
                } else {
                    r.append(c);
                }
                ++i;
            }
            return r.toString();
        }

        private void parseTargetSite(Attributes attributes) {
            String targetURI = attributes.getValue("", "uri");
            if (targetURI != null) {
                this.selectorInfo.targetURIs.add(targetURI);
                this.selectorInfo.targetURIPatterns.add(Pattern.compile(this.quote(targetURI, '*')));
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.rootFlag) {
                this.selectorInfo.documentElementNS = uri;
                this.selectorInfo.documentElementName = localName;
                this.rootFlag = true;
                return;
            }
            if (!XMLSelectorInfo.SELECTOR_NS.equals(uri)) {
                return;
            }
            if (this.metaFlag) {
                if ("targetSite".equals(localName)) {
                    this.parseTargetSite(attributes);
                } else if ("documentation".equals(localName)) {
                    this.setHandler(new TextContentHandler(this, new FinishHandler(){

                        public void set(String s) {
                            SelectorHandler.this.selectorInfo.documentation = s;
                        }
                    }));
                } else if ("userEntry".equals(localName)) {
                    this.selectorInfo.isUserEntry = true;
                } else if ("pageTitle".equals(localName)) {
                    this.setHandler(new TextContentHandler(this, new FinishHandler(){

                        public void set(String s) {
                            SelectorHandler.this.selectorInfo.pageTitle = s;
                        }
                    }));
                } else if ("authorName".equals(localName)) {
                    this.setHandler(new TextContentHandler(this, new FinishHandler(){

                        public void set(String s) {
                            SelectorHandler.this.selectorInfo.authorName = s;
                        }
                    }));
                }
            } else if ("meta".equals(localName)) {
                this.metaFlag = true;
                return;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!XMLSelectorInfo.SELECTOR_NS.equals(uri)) {
                return;
            }
            if (this.metaFlag && "meta".equals(localName)) {
                throw new FinishedException();
            }
        }

        SelectorHandler(IXMLInfo info) {
            super(info);
        }

        public static class FinishedException
        extends SAXException {
            private static final long serialVersionUID = -7213987482937237478L;

            FinishedException() {
                super("Finished");
            }
        }
    }

    private static class TextContentHandler
    extends BaseHandler {
        private StringBuffer buf = new StringBuffer();
        private int level = 0;
        private final BaseHandler prevHandler;
        private final FinishHandler finishHandler;

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.level;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buf.append(ch, start, length);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            --this.level;
            if (this.level < 0) {
                this.finishHandler.set(this.buf.toString());
                this.setHandler(this.prevHandler);
            }
        }

        TextContentHandler(BaseHandler handler, FinishHandler fh) {
            super(handler);
            this.finishHandler = fh;
            this.prevHandler = handler;
        }
    }
}

