/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.actf.ai.internal.xmlstore.XMLStorePlugin;
import org.eclipse.actf.ai.xmlstore.IXMLEditableInfo;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.IXMLStoreService;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.local.UserXMLStore;
import org.eclipse.actf.ai.xmlstore.local.XMLStoreLocal;
import org.eclipse.actf.ai.xmlstore.spi.XMLSelectorDefault;
import org.eclipse.actf.ai.xmlstore.spi.XMLSelectorInfo;
import org.eclipse.actf.ai.xmlstore.spi.XMLStoreAggregator;

public class XMLStoreServiceImpl
implements IXMLStoreService {
    private XMLStoreAggregator rootStore;
    private static XMLStoreServiceImpl instance = new XMLStoreServiceImpl();
    private UserXMLStore userStore;
    public static final String Fennec_NAMESPACE_URI = "http://www.ibm.com/xmlns/prod/aiBrowser/fennec";
    public static final String Fennec_DOCUMENT_ELEMENT_NAME = "fennec";

    public IXMLStore getRootStore() {
        return this.rootStore;
    }

    public IXMLSelector getSelectorWithDocElem(String name, String iri) {
        return new XMLSelectorWithDocElem(name, iri);
    }

    public IXMLSelector getSelectorWithURI(String iri) {
        return new XMLSelectorWithIRI(iri);
    }

    private XMLStoreServiceImpl() {
        XMLStoreAggregator store;
        this.rootStore = store = new XMLStoreAggregator();
    }

    public void addStore(IXMLStore store) {
        this.rootStore.addStore(store);
    }

    public void setUserStore(UserXMLStore store) {
        this.userStore = store;
        this.rootStore.addStore(store);
    }

    public static XMLStoreServiceImpl getInstance() {
        return instance;
    }

    public IXMLEditableInfo newUserXML(String namespaceURI, String qualifiedName, String targetUriPattern) throws XMLStoreException {
        return this.userStore.newXML(namespaceURI, qualifiedName, targetUriPattern);
    }

    public boolean exportMetadata(IXMLInfo info, File dest) {
        try {
            if (info instanceof IXMLEditableInfo) {
                ((IXMLEditableInfo)info).save(dest);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean importMetadata(File src) {
        block3: {
            try {
                if (!this.importZippedMetadata(src)) break block3;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.importFile(src);
    }

    private boolean importFile(File src) {
        XMLSelectorInfo info;
        try {
            info = XMLSelectorInfo.parse(XMLStoreLocal.newXMLFile(src));
        }
        catch (XMLStoreException xMLStoreException) {
            return false;
        }
        if (info.getDocumentElementName() == null) {
            return false;
        }
        String docElementName = info.getDocumentElementName();
        String childDirName = info.isUserEntry() ? "user" : "system";
        File destBaseDir = XMLStorePlugin.getDefault().getLocalDir(childDirName);
        File dest = new File(destBaseDir = new File(destBaseDir, docElementName), src.getName());
        if (src.equals(dest)) {
            return true;
        }
        destBaseDir.mkdirs();
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                int read;
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                byte[] buff = new byte[4096];
                while ((read = fis.read(buff)) >= 0) {
                    fos.write(buff, 0, read);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean importZippedMetadata(File src) {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(src));
            byte[] buffer = new byte[4096];
            String destDir = XMLStorePlugin.getDefault().getStateLocation().toOSString();
            boolean flag = true;
            while ((entry = zis.getNextEntry()) != null) {
                File f = new File(String.valueOf(destDir) + "\\" + entry.getName());
                FileOutputStream fos = new FileOutputStream(f);
                int len = 0;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                zis.closeEntry();
                fos.close();
                this.importFile(f);
                f.delete();
                flag = false;
            }
            zis.close();
            return !flag;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean exportAllAnnotations(File dest) {
        try {
            IXMLSelector selector = this.getSelectorWithDocElem(Fennec_DOCUMENT_ELEMENT_NAME, Fennec_NAMESPACE_URI);
            IXMLStore store = this.getRootStore().specify(selector);
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dest));
            Iterator<IXMLInfo> i = store.getInfoIterator();
            while (i.hasNext()) {
                IXMLInfo info = i.next();
                if (!(info instanceof IXMLEditableInfo)) continue;
                IXMLEditableInfo eInfo = (IXMLEditableInfo)info;
                eInfo.save(zos);
            }
            zos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static class XMLSelectorWithDocElem
    extends XMLSelectorDefault {
        private String name;
        private String iri;

        public String getDocumentElementName() {
            return this.name;
        }

        public String getDocumentElementNS() {
            return this.iri;
        }

        XMLSelectorWithDocElem(String name, String iri) {
            this.name = name;
            this.iri = iri;
        }
    }

    private static class XMLSelectorWithIRI
    extends XMLSelectorDefault {
        private String iri;

        public String getURI() {
            return this.iri;
        }

        XMLSelectorWithIRI(String iri) {
            this.iri = iri;
        }
    }
}

