/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io.impl;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.actf.ai.audio.io.AudioIOException;
import org.eclipse.actf.ai.audio.io.IAudioReader;

public class RecordDevice
implements IAudioReader {
    private Mixer recordMixer;
    private AudioFormat format;
    private TargetDataLine recordLine;

    public boolean equals(Object o) {
        if (o instanceof RecordDevice) {
            RecordDevice rd = (RecordDevice)o;
            if (this.recordMixer.equals(rd.recordMixer)) {
                return this.format.getChannels() == rd.format.getChannels() && this.format.getFrameRate() == rd.format.getFrameRate() && this.format.getSampleSizeInBits() == rd.format.getSampleSizeInBits();
            }
        }
        return false;
    }

    public RecordDevice(Mixer mixer, int sampleRate, int channels) {
        this.recordMixer = mixer;
        this.format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, 16, channels, 2 * channels, sampleRate, false);
        if (!this.recordMixer.isLineSupported(new DataLine.Info(TargetDataLine.class, this.format))) {
            this.check(sampleRate, channels);
        }
    }

    private void check(int sampleRate, int channels) {
        int[] samples = new int[]{48000, 44100, 22050, 16000, 8000};
        int i = 0;
        while (i < samples.length) {
            AudioFormat temp;
            if (samples[i] < sampleRate && this.recordMixer.isLineSupported(new DataLine.Info(TargetDataLine.class, temp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, samples[i], 16, channels, 2 * channels, samples[i], false)))) {
                this.format = temp;
                break;
            }
            ++i;
        }
    }

    public String getName() {
        return "Device \"" + this.recordMixer.getMixerInfo().getName() + " (" + this.format.getFrameRate() / 1000.0f + " kHz, " + this.format.getChannels() + "ch)" + "\"";
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public synchronized void close() {
        if (this.recordLine != null) {
            this.recordLine.close();
        }
    }

    public boolean isClosed() {
        return !this.recordLine.isOpen();
    }

    public boolean canRead() {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
        return this.recordMixer.isLineSupported(info);
    }

    public synchronized void open() throws AudioIOException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
        try {
            this.recordLine = (TargetDataLine)this.recordMixer.getLine(info);
            this.recordLine.open(this.format);
            this.recordLine.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public synchronized int read(byte[] data, int offset, int length) throws AudioIOException {
        return this.recordLine.read(data, offset, length);
    }
}

