/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editor.dialogs;

import java.util.Map;
import org.eclipse.actf.model.internal.ui.editor.dialogs.FavoritesAddDialog;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesArrangeDialog
extends Dialog {
    private Map<String, String> _favoritesMap;
    private boolean modified = false;

    public FavoritesArrangeDialog(Shell shell, Map<String, String> favoritesMap) {
        super(shell);
        this._favoritesMap = favoritesMap;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        composite.setLayout((Layout)gridLayout1);
        final Table table = new Table(composite, 67586);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 100;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] cols = new String[]{ModelServiceMessages.DialogConst_Name_Label, "URL: "};
        TableColumn col = new TableColumn(table, 1);
        col.setText(cols[0]);
        col.setWidth(200);
        col = new TableColumn(table, 1);
        col.setText(cols[1]);
        col.setWidth(300);
        for (String name : this._favoritesMap.keySet()) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, name);
            item.setText(1, this._favoritesMap.get(name));
        }
        Button button = new Button(composite, 8);
        button.setText(ModelServiceMessages.DialogArrangeFavorite_Modify_Name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (table.getSelectionCount() > 0) {
                    String name = table.getSelection()[0].getText(0);
                    FavoritesAddDialog dlg = new FavoritesAddDialog(FavoritesArrangeDialog.this.getShell(), FavoritesArrangeDialog.this._favoritesMap, name);
                    int ret = dlg.open();
                    String newName = dlg.getName();
                    if (ret == 0 && !newName.equals(name)) {
                        table.getSelection()[0].setText(0, newName);
                        FavoritesArrangeDialog.this._favoritesMap.put(newName, (String)FavoritesArrangeDialog.this._favoritesMap.get(name));
                        FavoritesArrangeDialog.this._favoritesMap.remove(name);
                        FavoritesArrangeDialog.this.modified = true;
                    }
                }
            }
        });
        button = new Button(composite, 8);
        button.setText(ModelServiceMessages.DialogArrangeFavorite_Delete);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (table.getSelectionCount() > 0) {
                    TableItem[] items = table.getSelection();
                    int i = 0;
                    while (i < items.length) {
                        FavoritesArrangeDialog.this._favoritesMap.remove(items[i].getText(0));
                        ++i;
                    }
                    table.remove(table.getSelectionIndices());
                    FavoritesArrangeDialog.this.modified = true;
                }
            }
        });
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelServiceMessages.DialogArrangeFavorite_Title);
    }

    public Map<String, String> getFavoritesMap() {
        return this._favoritesMap;
    }

    public boolean isModified() {
        return this.modified;
    }
}

