/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import java.io.File;
import org.eclipse.actf.ai.navigator.IBrowserControl;
import org.eclipse.actf.ai.navigator.IManipulator;
import org.eclipse.actf.ai.navigator.extension.ManipulatorExtension;
import org.eclipse.actf.ai.navigator.impl.NavigatorImpl;
import org.eclipse.actf.ai.navigator.impl.TripJournal;
import org.eclipse.actf.ai.navigator.impl.WebEventListener;
import org.eclipse.actf.ai.navigator.util.URLOpenDialog;
import org.eclipse.actf.ai.navigator.voice.VoiceManager;
import org.eclipse.actf.ai.xmlstore.XMLStoreServiceUtil;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserNavigationEventListener;
import org.eclipse.actf.model.ui.editor.browser.WebBrowserNavigationEvent;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BrowserControlImpl
implements IBrowserControl,
IWebBrowserNavigationEventListener {
    private final TripJournal tripJournal;
    private final WebEventListener webEventListener;
    private final VoiceManager voiceManager = new VoiceManager(null);

    public void backward() {
        this.tripJournal.backward(this.webEventListener.getFocused());
    }

    public void forward() {
        this.tripJournal.forward(this.webEventListener.getFocused());
    }

    BrowserControlImpl(WebEventListener webEventListener, TripJournal tripJournal) {
        this.tripJournal = tripJournal;
        this.webEventListener = webEventListener;
    }

    public void goBack(WebBrowserNavigationEvent e) {
        this.tripJournal.backward(this.webEventListener.getFocused());
    }

    public void goForward(WebBrowserNavigationEvent e) {
        this.tripJournal.forward(this.webEventListener.getFocused());
    }

    public void refresh(WebBrowserNavigationEvent e) {
        IWebBrowserACTF wb = e.getBrowser();
        WebEventListener.BrowserState bs = this.webEventListener.getBrowserState(wb);
        if (bs == null) {
            return;
        }
        bs.getNavigator().navigateRefresh();
    }

    public void stop(WebBrowserNavigationEvent e) {
        IWebBrowserACTF wb = e.getBrowser();
        wb.navigateStop();
    }

    public void exportAllMetadata() {
        String[] ext = new String[]{"*.fnz"};
        this.voiceManager.speakWithFormat("Navigator.EXPORT_ALL_ANNOTATIONS", true, true);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterExtensions(ext);
        String path = fileDialog.open();
        if (path != null) {
            String message;
            String title;
            boolean ret;
            File dest;
            if (!path.endsWith(".fnz")) {
                path = String.valueOf(path) + ".fnz";
            }
            if ((dest = new File(path)).exists() && !(ret = MessageDialog.openQuestion((Shell)shell, (String)(title = this.voiceManager.getMessageFormatter().mes("Navigator.OVERWRITE_CONFIRM")), (String)(message = this.voiceManager.getMessageFormatter().mes("Navigator.OVERWRITE_MESSAGE", dest.getName()))))) {
                return;
            }
            if (XMLStoreServiceUtil.getXMLStoreService().exportAllAnnotations(dest)) {
                this.voiceManager.speakWithFormat("Navigator.EXPORT_IS_SUCCEEDED", true, true);
            } else {
                this.voiceManager.speakWithFormat("Navigator.EXPORT_IS_FAILED", true, true);
            }
        }
    }

    public void importMetadata() {
        String[] ext = new String[]{"*.fnc;*.fnz;*.xml"};
        this.voiceManager.speakWithFormat("Navigator.IMPORT_FENNEC_FILE", true, true);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterExtensions(ext);
        String path = fileDialog.open();
        if (path != null) {
            File src = new File(path);
            boolean r = XMLStoreServiceUtil.getXMLStoreService().importMetadata(src);
            XMLStoreServiceUtil.getXMLStoreService().getRootStore().refleshAll();
            NavigatorImpl navigator = this.webEventListener.getFocused();
            if (navigator != null) {
                navigator.forceRestart();
            }
            if (r) {
                this.voiceManager.speakWithFormat("Navigator.IMPORT_IS_SUCCEEDED", true, true);
            } else {
                this.voiceManager.speakWithFormat("Navigator.IMPORT_IS_FAILED", true, true);
            }
        }
    }

    public void openTab() {
        this.voiceManager.stop();
        URLOpenDialog openURLDialog = new URLOpenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (1 == openURLDialog.open()) {
            ManipulatorExtension.setMode(IManipulator.FORM_INPUT_MODE);
            String sUrl = openURLDialog.getUrl();
            ModelServiceUtils.openInExistingEditor((String)sUrl);
            ManipulatorExtension.setMode(IManipulator.TREE_NAVIGATION_MODE);
        }
    }
}

