/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.key.keyui.impl;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.actf.ai.key.keyui.Messages;
import org.eclipse.actf.ai.navigator.IBrowserControl;
import org.eclipse.actf.ai.navigator.IManipulator;
import org.eclipse.actf.ai.navigator.INavigatorUI;
import org.eclipse.actf.ai.navigator.ui.NavigatorUIUtil;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.IXMLStoreService;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.XMLStoreServiceUtil;
import org.eclipse.actf.util.win32.comclutch.ComPlugin;
import org.eclipse.actf.util.win32.keyhook.IKeyHook;
import org.eclipse.actf.util.win32.keyhook.IKeyHookListener;
import org.eclipse.actf.util.win32.keyhook.ISendEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyUIImpl
implements IKeyHookListener,
IManipulator {
    private static boolean initialized = false;
    public static final String PREFERENCES_NS = "http://www.ibm.com/xmlns/prod/AcTF/aiBrowser/preferences/1.0";
    public static final int CMD_PASSTHROUGH = -1;
    public static final int CMD_NOOP = 9999;
    public static final int CMD_SPEED_UP = 1300;
    public static final int CMD_SPEED_DOWN = 1301;
    public static final int CMD_PLAY_NEXT = 1302;
    public static final int CMD_PLAY_PREV = 1303;
    public static final int CMD_START_RECORDING = 1304;
    private static final int VK_RETURN = 13;
    private IManipulator.Mode mode = null;
    private IBrowserControl browserControl;
    private INavigatorUI navigatorUI;
    private HashMap<KeyEntry, KC> keyConfigMapForTreeNavigation = new HashMap();
    private static IKeyHook keyHook;
    private static ISendEvent sendEvent;

    public KeyUIImpl() {
        if (!initialized) {
            initialized = true;
            this.initialize();
        }
    }

    public void initialize() {
        keyHook = ComPlugin.getDefault().newKeyHook((IKeyHookListener)this);
        sendEvent = ComPlugin.getDefault().newSendEvent();
        IXMLStoreService xmlStoreService = XMLStoreServiceUtil.getXMLStoreService();
        IXMLSelector selector = xmlStoreService.getSelectorWithDocElem("UserPreferences", PREFERENCES_NS);
        IXMLStore rootStore = xmlStoreService.getRootStore();
        IXMLStore specifiedStroe = rootStore.specify(selector);
        Iterator i = specifiedStroe.getInfoIterator();
        while (i.hasNext()) {
            IXMLInfo info = (IXMLInfo)i.next();
            try {
                this.read(info.getRootNode());
            }
            catch (XMLStoreException e) {
                e.printStackTrace();
            }
        }
        this.initAccessKey();
    }

    private void initAccessKey() {
        KC kc;
        int i = 0;
        while (i < 10) {
            kc = new KC(KC.Type.ACCESSKEY, 48 + i, 9, null);
            this.register(kc);
            ++i;
        }
        i = 0;
        while (i < 26) {
            kc = new KC(KC.Type.ACCESSKEY, 65 + i, 9, null);
            this.register(kc);
            ++i;
        }
    }

    private void read(Node rootNode) {
        NodeList children = rootNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            block9: {
                KC.Type type;
                Node commands;
                block11: {
                    block10: {
                        commands = children.item(i);
                        type = KC.Type.COMMAND;
                        if (commands.getNodeType() != 1) break block9;
                        if (!commands.getLocalName().equals("Commands")) break block10;
                        type = KC.Type.COMMAND;
                        break block11;
                    }
                    if (!commands.getLocalName().equals("Functions")) break block9;
                    type = KC.Type.FUNCTION;
                }
                NodeList commandList = commands.getChildNodes();
                int j = 0;
                while (j < commandList.getLength()) {
                    Node command = commandList.item(j);
                    if (command.getNodeType() == 1) {
                        NodeList keyList = command.getChildNodes();
                        ArrayList<KC> array = new ArrayList<KC>();
                        int k = 0;
                        while (k < keyList.getLength()) {
                            Node key = keyList.item(k);
                            if (key.getNodeType() == 1) {
                                KC kc = this.createKC(type, command, key);
                                this.register(kc);
                                if (!"none".equals(((Element)key).getAttribute("display"))) {
                                    array.add(kc);
                                }
                            }
                            ++k;
                        }
                        this.addMenu(commands, command, array);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private KC createKC(KC.Type type, Node command, Node key) {
        String name = command.getLocalName();
        int vkey = 0;
        int mod = 0;
        if ("key".equals(key.getLocalName()) && PREFERENCES_NS.equals(key.getNamespaceURI())) {
            String stroke = key.getTextContent();
            stroke = stroke.trim();
            String[] keys = stroke.split("[ \n\t\r]+");
            int j = 0;
            while (j < keys.length) {
                try {
                    Field f;
                    if ("VK_RETURN".equals(keys[j])) {
                        vkey = 13;
                    } else if (keys[j].startsWith("VK_")) {
                        f = KeyEvent.class.getField(keys[j]);
                        vkey = f.getInt(KeyEvent.class);
                    } else if (keys[j].endsWith("_MASK")) {
                        f = KeyEvent.class.getField(keys[j]);
                        mod |= f.getInt(KeyEvent.class);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        return new KC(type, vkey, mod, name);
    }

    private void addMenu(Node commands, Node command, ArrayList<KC> kc) {
        String menuName = ((Element)commands).getAttribute("menu");
        if (menuName.length() == 0) {
            return;
        }
        String groupName = ((Element)commands).getAttribute("menuGroup");
        if (groupName.length() == 0) {
            return;
        }
        String name = command.getLocalName();
        IMenuManager menu = NavigatorUIUtil.menuManager;
        IMenuManager menu2 = menu.findMenuUsingPath(menuName);
        if ("separator".equals(name)) {
            menu2.appendToGroup(groupName, (IContributionItem)new Separator());
        } else {
            menu2.appendToGroup(groupName, (IAction)new KeyAction(name, kc));
        }
    }

    private void register(KC kc) {
        this.keyConfigMapForTreeNavigation.put(new KeyEntry(kc.vkey, kc.mod), kc);
        keyHook.registerHookedKey(kc.vkey, kc.mod);
    }

    public boolean hookedKey(int vkey, int modifier, boolean isUp) {
        if (this.mode == IManipulator.TREE_NAVIGATION_MODE) {
            KC kc = this.keyConfigMapForTreeNavigation.get(new KeyEntry(vkey, modifier));
            if (kc != null) {
                if (kc.type == KC.Type.COMMAND && kc.command == 9999) {
                    return true;
                }
                if (kc.type != KC.Type.ACCESSKEY && kc.method == null) {
                    return false;
                }
                if (!isUp) {
                    this.call(kc);
                }
                return true;
            }
        } else {
            if (this.mode == IManipulator.FORM_INPUT_MODE) {
                switch (vkey) {
                    case 9: {
                        break;
                    }
                    case 13: {
                        sendEvent.postKey(vkey, isUp);
                        break;
                    }
                    case 27: {
                        this.navigatorUI.exitFormMode();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            if (this.mode == IManipulator.KEYHOOK_DISABLED_MODE) {
                return false;
            }
        }
        return false;
    }

    private void call(KC kc) {
        if (kc.type == KC.Type.COMMAND) {
            switch (kc.command) {
                case 1300: {
                    this.sendKey(38, true);
                    break;
                }
                case 1301: {
                    this.sendKey(40, true);
                    break;
                }
                case 1302: {
                    this.sendKey(39, false);
                    break;
                }
                case 1303: {
                    this.sendKey(37, false);
                    break;
                }
                case 1304: {
                    this.sendKey(83, true);
                    break;
                }
            }
        } else if (kc.type == KC.Type.FUNCTION) {
            try {
                switch (kc.target) {
                    case IBROWSERCONTROL: {
                        if (this.browserControl != null) {
                            kc.method.invoke((Object)this.browserControl, new Object[0]);
                        }
                        break;
                    }
                    case INAVIGATORUI: {
                        if (this.navigatorUI == null) break;
                        kc.method.invoke((Object)this.navigatorUI, new Object[0]);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (kc.type == KC.Type.ACCESSKEY) {
            this.navigatorUI.jumpToAccessKey((char)kc.vkey);
        }
    }

    private void sendKey(int key, boolean ctrlFlag) {
        long h = sendEvent.findWindow("SWT_Window0", "Sound Controller");
        if (ctrlFlag) {
            sendEvent.postKeyToWindow(h, 17, false);
        }
        sendEvent.postKeyToWindow(h, key, false);
        sendEvent.postKeyToWindow(h, key, true);
        if (ctrlFlag) {
            sendEvent.postKeyToWindow(h, 17, true);
        }
    }

    public void setNavigator(INavigatorUI navigatorUI) {
        this.navigatorUI = navigatorUI;
    }

    public void setBrowserControl(IBrowserControl browserControl) {
        this.browserControl = browserControl;
    }

    public void dispose() {
        keyHook.dispose();
    }

    public void setMode(IManipulator.Mode mode) {
        this.mode = mode;
        if (mode == IManipulator.FORM_INPUT_MODE) {
            keyHook.hookAll(true);
        } else if (mode == IManipulator.KEYHOOK_DISABLED_MODE) {
            keyHook.hookAll(false);
        } else {
            keyHook.hookAll(false);
        }
    }

    static class KC {
        int vkey;
        int mod;
        Type type;
        String name;
        Target target;
        Method method;
        int command;

        KC(Type type, int vkey, int mod, String name) {
            this.type = type;
            this.vkey = vkey;
            this.mod = mod;
            this.name = name;
            if (type == Type.FUNCTION) {
                try {
                    this.method = INavigatorUI.class.getMethod(name, new Class[0]);
                    this.target = Target.INAVIGATORUI;
                }
                catch (Exception exception) {
                    this.method = null;
                }
                if (this.method == null) {
                    try {
                        this.method = IBrowserControl.class.getMethod(name, new Class[0]);
                        this.target = Target.IBROWSERCONTROL;
                    }
                    catch (Exception exception) {
                        System.err.println("No such method:" + name);
                    }
                }
            } else if (type == Type.COMMAND) {
                try {
                    Field field = KeyUIImpl.class.getField("CMD_" + name);
                    this.command = field.getInt(KeyUIImpl.class);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Target {
            INAVIGATORUI,
            IBROWSERCONTROL;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type {
            COMMAND,
            FUNCTION,
            NOOP,
            ACCESSKEY;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyAction
    extends Action {
        String name;
        ArrayList<KC> kcs;

        public KeyAction(String name, ArrayList<KC> kcs) {
            this.name = name;
            this.kcs = kcs;
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString(name));
            if (kcs.size() > 0) {
                sb.append("    (" + this.getKey(kcs) + ")");
            }
            this.setText(sb.toString());
        }

        private String getKey(ArrayList<KC> kcs) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < kcs.size()) {
                if (i != 0) {
                    sb.append(" " + Messages.getString("Key.OR") + " ");
                }
                int vkey = kcs.get((int)i).vkey;
                int mod = kcs.get((int)i).mod;
                if (this.is(mod, 2)) {
                    sb.append("Ctrl+");
                }
                if (this.is(mod, 8)) {
                    sb.append("Alt+");
                }
                if (this.is(mod, 1)) {
                    sb.append("Shift+");
                }
                String key = "";
                if (48 <= vkey && vkey <= 57 || 65 <= vkey && vkey <= 90) {
                    key = "" + (char)vkey;
                } else if (112 <= vkey && vkey <= 61451) {
                    key = "F" + (vkey - 112 + 1);
                } else {
                    switch (vkey) {
                        case 13: {
                            key = "Enter";
                            break;
                        }
                        case 38: {
                            key = "Up";
                            break;
                        }
                        case 40: {
                            key = "Down";
                            break;
                        }
                        case 37: {
                            key = "Left";
                            break;
                        }
                        case 39: {
                            key = "Right";
                            break;
                        }
                        case 36: {
                            key = "Home";
                            break;
                        }
                        case 35: {
                            key = "End";
                            break;
                        }
                        case 33: {
                            key = "PageUp";
                            break;
                        }
                        case 34: {
                            key = "PageDown";
                            break;
                        }
                        case 9: {
                            key = "Tab";
                            break;
                        }
                        case 19: {
                            key = "Pause";
                            break;
                        }
                        case 32: {
                            key = "Space";
                        }
                    }
                }
                sb.append(key);
                ++i;
            }
            return sb.toString();
        }

        private boolean is(int a, int b) {
            return (a & b) == b;
        }

        public void run() {
            if (this.kcs.size() > 0) {
                KeyUIImpl.this.call(this.kcs.get(0));
            }
        }
    }

    static class KeyEntry {
        int vkey;
        int mod;

        public int hashCode() {
            return this.vkey | this.mod << 16;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyEntry)) {
                return false;
            }
            KeyEntry e = (KeyEntry)o;
            return e.vkey == this.vkey && e.mod == this.mod;
        }

        KeyEntry(int vkey, int mod) {
            this.vkey = vkey;
            this.mod = mod;
        }
    }
}

